/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.linear;

import org.hipparchus.analysis.UnivariateFunction;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.NullArgumentException;
import org.hipparchus.linear.AnyMatrix;
import org.hipparchus.linear.RealMatrixChangingVisitor;
import org.hipparchus.linear.RealMatrixPreservingVisitor;
import org.hipparchus.linear.RealVector;
import org.hipparchus.util.FastMath;

public interface RealMatrix
extends AnyMatrix {
    public RealMatrix createMatrix(int var1, int var2) throws MathIllegalArgumentException;

    public RealMatrix copy();

    public RealMatrix add(RealMatrix var1) throws MathIllegalArgumentException;

    public RealMatrix subtract(RealMatrix var1) throws MathIllegalArgumentException;

    public RealMatrix scalarAdd(double var1);

    public RealMatrix scalarMultiply(double var1);

    public RealMatrix multiply(RealMatrix var1) throws MathIllegalArgumentException;

    default public RealMatrix multiplyTransposed(RealMatrix m) throws MathIllegalArgumentException {
        return this.multiply(m.transpose());
    }

    default public RealMatrix transposeMultiply(RealMatrix m) throws MathIllegalArgumentException {
        return this.transpose().multiply(m);
    }

    public RealMatrix preMultiply(RealMatrix var1) throws MathIllegalArgumentException;

    public RealMatrix power(int var1) throws MathIllegalArgumentException;

    public double[][] getData();

    default public double getNorm1() {
        return this.walkInColumnOrder(new RealMatrixPreservingVisitor(){
            private int endRow;
            private double columnSum;
            private double maxColSum;

            @Override
            public void start(int rows, int columns, int startRow, int endRow, int startColumn, int endColumn) {
                this.endRow = endRow;
                this.columnSum = 0.0;
                this.maxColSum = 0.0;
            }

            @Override
            public void visit(int row, int column, double value) {
                this.columnSum += FastMath.abs(value);
                if (row == this.endRow) {
                    this.maxColSum = FastMath.max(this.maxColSum, this.columnSum);
                    this.columnSum = 0.0;
                }
            }

            @Override
            public double end() {
                return this.maxColSum;
            }
        });
    }

    default public double getNormInfty() {
        return this.walkInRowOrder(new RealMatrixPreservingVisitor(){
            private int endColumn;
            private double rowSum;
            private double maxRowSum;

            @Override
            public void start(int rows, int columns, int startRow, int endRow, int startColumn, int endColumn) {
                this.endColumn = endColumn;
                this.rowSum = 0.0;
                this.maxRowSum = 0.0;
            }

            @Override
            public void visit(int row, int column, double value) {
                this.rowSum += FastMath.abs(value);
                if (column == this.endColumn) {
                    this.maxRowSum = FastMath.max(this.maxRowSum, this.rowSum);
                    this.rowSum = 0.0;
                }
            }

            @Override
            public double end() {
                return this.maxRowSum;
            }
        });
    }

    public double getFrobeniusNorm();

    public RealMatrix getSubMatrix(int var1, int var2, int var3, int var4) throws MathIllegalArgumentException;

    public RealMatrix getSubMatrix(int[] var1, int[] var2) throws MathIllegalArgumentException, NullArgumentException;

    public void copySubMatrix(int var1, int var2, int var3, int var4, double[][] var5) throws MathIllegalArgumentException;

    public void copySubMatrix(int[] var1, int[] var2, double[][] var3) throws MathIllegalArgumentException, NullArgumentException;

    public void setSubMatrix(double[][] var1, int var2, int var3) throws MathIllegalArgumentException, NullArgumentException;

    public RealMatrix getRowMatrix(int var1) throws MathIllegalArgumentException;

    public void setRowMatrix(int var1, RealMatrix var2) throws MathIllegalArgumentException;

    public RealMatrix getColumnMatrix(int var1) throws MathIllegalArgumentException;

    public void setColumnMatrix(int var1, RealMatrix var2) throws MathIllegalArgumentException;

    public RealVector getRowVector(int var1) throws MathIllegalArgumentException;

    public void setRowVector(int var1, RealVector var2) throws MathIllegalArgumentException;

    public RealVector getColumnVector(int var1) throws MathIllegalArgumentException;

    public void setColumnVector(int var1, RealVector var2) throws MathIllegalArgumentException;

    public double[] getRow(int var1) throws MathIllegalArgumentException;

    public void setRow(int var1, double[] var2) throws MathIllegalArgumentException;

    public double[] getColumn(int var1) throws MathIllegalArgumentException;

    public void setColumn(int var1, double[] var2) throws MathIllegalArgumentException;

    public double getEntry(int var1, int var2) throws MathIllegalArgumentException;

    public void setEntry(int var1, int var2, double var3) throws MathIllegalArgumentException;

    public void addToEntry(int var1, int var2, double var3) throws MathIllegalArgumentException;

    public void multiplyEntry(int var1, int var2, double var3) throws MathIllegalArgumentException;

    public RealMatrix transpose();

    public double getTrace() throws MathIllegalArgumentException;

    public double[] operate(double[] var1) throws MathIllegalArgumentException;

    public RealVector operate(RealVector var1) throws MathIllegalArgumentException;

    public double[] preMultiply(double[] var1) throws MathIllegalArgumentException;

    public RealVector preMultiply(RealVector var1) throws MathIllegalArgumentException;

    public double walkInRowOrder(RealMatrixChangingVisitor var1);

    public double walkInRowOrder(RealMatrixPreservingVisitor var1);

    public double walkInRowOrder(RealMatrixChangingVisitor var1, int var2, int var3, int var4, int var5) throws MathIllegalArgumentException;

    public double walkInRowOrder(RealMatrixPreservingVisitor var1, int var2, int var3, int var4, int var5) throws MathIllegalArgumentException;

    public double walkInColumnOrder(RealMatrixChangingVisitor var1);

    public double walkInColumnOrder(RealMatrixPreservingVisitor var1);

    public double walkInColumnOrder(RealMatrixChangingVisitor var1, int var2, int var3, int var4, int var5) throws MathIllegalArgumentException;

    public double walkInColumnOrder(RealMatrixPreservingVisitor var1, int var2, int var3, int var4, int var5) throws MathIllegalArgumentException;

    public double walkInOptimizedOrder(RealMatrixChangingVisitor var1);

    public double walkInOptimizedOrder(RealMatrixPreservingVisitor var1);

    public double walkInOptimizedOrder(RealMatrixChangingVisitor var1, int var2, int var3, int var4, int var5) throws MathIllegalArgumentException;

    public double walkInOptimizedOrder(RealMatrixPreservingVisitor var1, int var2, int var3, int var4, int var5) throws MathIllegalArgumentException;

    default public RealMatrix map(UnivariateFunction function) {
        return this.copy().mapToSelf(function);
    }

    default public RealMatrix mapToSelf(final UnivariateFunction function) {
        this.walkInOptimizedOrder(new RealMatrixChangingVisitor(){

            @Override
            public double visit(int row, int column, double value) {
                return function.value(value);
            }

            @Override
            public void start(int rows, int columns, int startRow, int endRow, int startColumn, int endColumn) {
            }

            @Override
            public double end() {
                return 0.0;
            }
        });
        return this;
    }
}

