/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.analysis.differentiation;

import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.analysis.differentiation.FDSFactory;
import org.hipparchus.analysis.differentiation.FieldGradient;
import org.hipparchus.util.MathArrays;

public class FieldGradientField<T extends CalculusFieldElement<T>>
implements Field<FieldGradient<T>> {
    private static final Map<Field<?>, FieldGradientField<?>[]> CACHE = new HashMap();
    private final FieldGradient<T> zero;
    private final FieldGradient<T> one;
    private final FDSFactory<T> factory;

    private FieldGradientField(Field<T> valueField, int parameters) {
        this.zero = new FieldGradient((CalculusFieldElement)valueField.getZero(), (CalculusFieldElement[])MathArrays.buildArray(valueField, (int)parameters));
        this.one = new FieldGradient((CalculusFieldElement)valueField.getOne(), (CalculusFieldElement[])MathArrays.buildArray(valueField, (int)parameters));
        this.factory = new FDSFactory<T>(valueField, parameters, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends CalculusFieldElement<T>> FieldGradientField<T> getField(Field<T> valueField, int parameters) {
        FieldGradientField<?>[] cachedFields;
        Map<Field<?>, FieldGradientField<?>[]> map = CACHE;
        synchronized (map) {
            cachedFields = CACHE.get(valueField);
            if (cachedFields == null || cachedFields.length <= parameters) {
                FieldGradientField[] newCachedFields = (FieldGradientField[])Array.newInstance(FieldGradientField.class, parameters + 1);
                if (cachedFields != null) {
                    System.arraycopy(cachedFields, 0, newCachedFields, 0, cachedFields.length);
                }
                cachedFields = newCachedFields;
                CACHE.put(valueField, cachedFields);
            }
        }
        if (cachedFields[parameters] == null) {
            cachedFields[parameters] = new FieldGradientField<T>(valueField, parameters);
        }
        FieldGradientField<?> tCached = cachedFields[parameters];
        return tCached;
    }

    @Override
    public FieldGradient<T> getOne() {
        return this.one;
    }

    @Override
    public FieldGradient<T> getZero() {
        return this.zero;
    }

    @Override
    public Class<FieldGradient<T>> getRuntimeClass() {
        return this.getZero().getClass();
    }

    FDSFactory<T> getConversionFactory() {
        return this.factory;
    }

    public boolean equals(Object other) {
        return this == other;
    }

    public int hashCode() {
        return -851537170;
    }
}

