/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode.sampling;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.ode.FieldEquationsMapper;
import org.hipparchus.ode.FieldODEStateAndDerivative;
import org.hipparchus.ode.sampling.FieldODEStateInterpolator;
import org.hipparchus.util.FastMath;

public abstract class AbstractFieldODEStateInterpolator<T extends CalculusFieldElement<T>>
implements FieldODEStateInterpolator<T> {
    private final FieldODEStateAndDerivative<T> globalPreviousState;
    private final FieldODEStateAndDerivative<T> globalCurrentState;
    private final FieldODEStateAndDerivative<T> softPreviousState;
    private final FieldODEStateAndDerivative<T> softCurrentState;
    private final boolean forward;
    private FieldEquationsMapper<T> mapper;

    protected AbstractFieldODEStateInterpolator(boolean isForward, FieldODEStateAndDerivative<T> globalPreviousState, FieldODEStateAndDerivative<T> globalCurrentState, FieldODEStateAndDerivative<T> softPreviousState, FieldODEStateAndDerivative<T> softCurrentState, FieldEquationsMapper<T> equationsMapper) {
        this.forward = isForward;
        this.globalPreviousState = globalPreviousState;
        this.globalCurrentState = globalCurrentState;
        this.softPreviousState = softPreviousState;
        this.softCurrentState = softCurrentState;
        this.mapper = equationsMapper;
    }

    public AbstractFieldODEStateInterpolator<T> restrictStep(FieldODEStateAndDerivative<T> previousState, FieldODEStateAndDerivative<T> currentState) {
        return this.create(this.forward, this.globalPreviousState, this.globalCurrentState, previousState, currentState, this.mapper);
    }

    protected abstract AbstractFieldODEStateInterpolator<T> create(boolean var1, FieldODEStateAndDerivative<T> var2, FieldODEStateAndDerivative<T> var3, FieldODEStateAndDerivative<T> var4, FieldODEStateAndDerivative<T> var5, FieldEquationsMapper<T> var6);

    public FieldODEStateAndDerivative<T> getGlobalPreviousState() {
        return this.globalPreviousState;
    }

    public FieldODEStateAndDerivative<T> getGlobalCurrentState() {
        return this.globalCurrentState;
    }

    @Override
    public FieldODEStateAndDerivative<T> getPreviousState() {
        return this.softPreviousState;
    }

    @Override
    public boolean isPreviousStateInterpolated() {
        return this.softPreviousState != this.globalPreviousState;
    }

    @Override
    public FieldODEStateAndDerivative<T> getCurrentState() {
        return this.softCurrentState;
    }

    @Override
    public boolean isCurrentStateInterpolated() {
        return this.softCurrentState != this.globalCurrentState;
    }

    @Override
    public FieldODEStateAndDerivative<T> getInterpolatedState(T time) {
        if (FastMath.abs((double)((CalculusFieldElement)this.globalCurrentState.getTime().subtract(this.globalPreviousState.getTime())).getReal()) <= FastMath.ulp((double)this.globalCurrentState.getTime().getReal())) {
            return this.globalCurrentState;
        }
        CalculusFieldElement thetaH = (CalculusFieldElement)time.subtract(this.globalPreviousState.getTime());
        CalculusFieldElement oneMinusThetaH = (CalculusFieldElement)this.globalCurrentState.getTime().subtract(time);
        CalculusFieldElement theta = (CalculusFieldElement)thetaH.divide(this.globalCurrentState.getTime().subtract(this.globalPreviousState.getTime()));
        return this.computeInterpolatedStateAndDerivatives(this.mapper, time, theta, thetaH, oneMinusThetaH);
    }

    @Override
    public boolean isForward() {
        return this.forward;
    }

    protected FieldEquationsMapper<T> getMapper() {
        return this.mapper;
    }

    protected abstract FieldODEStateAndDerivative<T> computeInterpolatedStateAndDerivatives(FieldEquationsMapper<T> var1, T var2, T var3, T var4, T var5) throws MathIllegalStateException;
}

