/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode.nonstiff;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.ode.FieldEquationsMapper;
import org.hipparchus.ode.FieldExpandableODE;
import org.hipparchus.ode.FieldODEState;
import org.hipparchus.ode.FieldODEStateAndDerivative;
import org.hipparchus.ode.nonstiff.AdaptiveStepsizeFieldIntegrator;
import org.hipparchus.ode.nonstiff.FieldButcherArrayProvider;
import org.hipparchus.ode.nonstiff.RungeKuttaFieldStateInterpolator;
import org.hipparchus.ode.nonstiff.StepsizeHelper;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;
import org.hipparchus.util.MathUtils;

public abstract class EmbeddedRungeKuttaFieldIntegrator<T extends CalculusFieldElement<T>>
extends AdaptiveStepsizeFieldIntegrator<T>
implements FieldButcherArrayProvider<T> {
    private final int fsal;
    private final T[] c;
    private final T[][] a;
    private final T[] b;
    private final double exp;
    private T safety;
    private T minReduction;
    private T maxGrowth;

    protected EmbeddedRungeKuttaFieldIntegrator(Field<T> field, String name, int fsal, double minStep, double maxStep, double scalAbsoluteTolerance, double scalRelativeTolerance) {
        super(field, name, minStep, maxStep, scalAbsoluteTolerance, scalRelativeTolerance);
        this.fsal = fsal;
        this.c = this.getC();
        this.a = this.getA();
        this.b = this.getB();
        this.exp = -1.0 / (double)this.getOrder();
        this.setSafety((CalculusFieldElement)((CalculusFieldElement)field.getZero()).add(0.9));
        this.setMinReduction((CalculusFieldElement)((CalculusFieldElement)field.getZero()).add(0.2));
        this.setMaxGrowth((CalculusFieldElement)((CalculusFieldElement)field.getZero()).add(10.0));
    }

    protected EmbeddedRungeKuttaFieldIntegrator(Field<T> field, String name, int fsal, double minStep, double maxStep, double[] vecAbsoluteTolerance, double[] vecRelativeTolerance) {
        super(field, name, minStep, maxStep, vecAbsoluteTolerance, vecRelativeTolerance);
        this.fsal = fsal;
        this.c = this.getC();
        this.a = this.getA();
        this.b = this.getB();
        this.exp = -1.0 / (double)this.getOrder();
        this.setSafety((CalculusFieldElement)((CalculusFieldElement)field.getZero()).add(0.9));
        this.setMinReduction((CalculusFieldElement)((CalculusFieldElement)field.getZero()).add(0.2));
        this.setMaxGrowth((CalculusFieldElement)((CalculusFieldElement)field.getZero()).add(10.0));
    }

    protected T fraction(int p, int q) {
        return (T)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.getField().getOne()).multiply(p)).divide((double)q));
    }

    protected T fraction(double p, double q) {
        return (T)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.getField().getOne()).multiply(p)).divide(q));
    }

    protected abstract RungeKuttaFieldStateInterpolator<T> createInterpolator(boolean var1, T[][] var2, FieldODEStateAndDerivative<T> var3, FieldODEStateAndDerivative<T> var4, FieldEquationsMapper<T> var5);

    public abstract int getOrder();

    public T getSafety() {
        return this.safety;
    }

    public void setSafety(T safety) {
        this.safety = safety;
    }

    @Override
    public FieldODEStateAndDerivative<T> integrate(FieldExpandableODE<T> equations, FieldODEState<T> initialState, T finalTime) throws MathIllegalArgumentException, MathIllegalStateException {
        this.sanityChecks(initialState, finalTime);
        this.setStepStart(this.initIntegration(equations, initialState, finalTime));
        boolean forward = ((CalculusFieldElement)finalTime.subtract(initialState.getTime())).getReal() > 0.0;
        int stages = this.c.length + 1;
        CalculusFieldElement[][] yDotK = (CalculusFieldElement[][])MathArrays.buildArray(this.getField(), (int)stages, (int)-1);
        CalculusFieldElement[] yTmp = (CalculusFieldElement[])MathArrays.buildArray(this.getField(), (int)equations.getMapper().getTotalDimension());
        CalculusFieldElement hNew = (CalculusFieldElement)this.getField().getZero();
        boolean firstTime = true;
        this.setIsLastStep(false);
        do {
            boolean filteredNextIsLast;
            double error = 10.0;
            while (error >= 1.0) {
                CalculusFieldElement[] y = this.getStepStart().getCompleteState();
                yDotK[0] = this.getStepStart().getCompleteDerivative();
                if (firstTime) {
                    StepsizeHelper helper = this.getStepSizeHelper();
                    CalculusFieldElement[] scale = (CalculusFieldElement[])MathArrays.buildArray(this.getField(), (int)helper.getMainSetDimension());
                    for (int i = 0; i < scale.length; ++i) {
                        scale[i] = helper.getTolerance(i, (CalculusFieldElement)y[i].abs());
                    }
                    hNew = (CalculusFieldElement)((CalculusFieldElement)this.getField().getZero()).add(this.initializeStep(forward, this.getOrder(), scale, this.getStepStart(), equations.getMapper()));
                    firstTime = false;
                }
                this.setStepSize(hNew);
                if (forward) {
                    if (((CalculusFieldElement)((CalculusFieldElement)this.getStepStart().getTime().add(this.getStepSize())).subtract(finalTime)).getReal() >= 0.0) {
                        this.setStepSize((CalculusFieldElement)finalTime.subtract(this.getStepStart().getTime()));
                    }
                } else if (((CalculusFieldElement)((CalculusFieldElement)this.getStepStart().getTime().add(this.getStepSize())).subtract(finalTime)).getReal() <= 0.0) {
                    this.setStepSize((CalculusFieldElement)finalTime.subtract(this.getStepStart().getTime()));
                }
                for (int k = 1; k < stages; ++k) {
                    for (int j = 0; j < y.length; ++j) {
                        CalculusFieldElement sum = (CalculusFieldElement)yDotK[0][j].multiply(this.a[k - 1][0]);
                        for (int l = 1; l < k; ++l) {
                            sum = (CalculusFieldElement)sum.add(yDotK[l][j].multiply(this.a[k - 1][l]));
                        }
                        yTmp[j] = (CalculusFieldElement)y[j].add(this.getStepSize().multiply((FieldElement)sum));
                    }
                    yDotK[k] = this.computeDerivatives((CalculusFieldElement)this.getStepStart().getTime().add(this.getStepSize().multiply(this.c[k - 1])), yTmp);
                }
                for (int j = 0; j < y.length; ++j) {
                    CalculusFieldElement sum = (CalculusFieldElement)yDotK[0][j].multiply(this.b[0]);
                    for (int l = 1; l < stages; ++l) {
                        sum = (CalculusFieldElement)sum.add(yDotK[l][j].multiply(this.b[l]));
                    }
                    yTmp[j] = (CalculusFieldElement)y[j].add(this.getStepSize().multiply((FieldElement)sum));
                }
                error = this.estimateError(yDotK, y, yTmp, (CalculusFieldElement)this.getStepSize());
                if (!(error >= 1.0)) continue;
                CalculusFieldElement factor = MathUtils.min(this.maxGrowth, (CalculusFieldElement)MathUtils.max(this.minReduction, (CalculusFieldElement)((CalculusFieldElement)this.safety.multiply(FastMath.pow((double)error, (double)this.exp)))));
                hNew = this.getStepSizeHelper().filterStep((CalculusFieldElement)this.getStepSize().multiply((FieldElement)factor), forward, false);
            }
            CalculusFieldElement stepEnd = (CalculusFieldElement)this.getStepStart().getTime().add(this.getStepSize());
            CalculusFieldElement[] yDotTmp = this.fsal >= 0 ? yDotK[this.fsal] : this.computeDerivatives(stepEnd, yTmp);
            FieldODEStateAndDerivative stateTmp = equations.getMapper().mapStateAndDerivative(stepEnd, yTmp, yDotTmp);
            this.setStepStart(this.acceptStep(this.createInterpolator(forward, yDotK, this.getStepStart(), stateTmp, equations.getMapper()), finalTime));
            if (this.isLastStep()) continue;
            CalculusFieldElement factor = MathUtils.min(this.maxGrowth, (CalculusFieldElement)MathUtils.max(this.minReduction, (CalculusFieldElement)((CalculusFieldElement)this.safety.multiply(FastMath.pow((double)error, (double)this.exp)))));
            CalculusFieldElement scaledH = (CalculusFieldElement)this.getStepSize().multiply((FieldElement)factor);
            CalculusFieldElement nextT = (CalculusFieldElement)this.getStepStart().getTime().add((FieldElement)scaledH);
            boolean nextIsLast = forward ? ((CalculusFieldElement)nextT.subtract(finalTime)).getReal() >= 0.0 : ((CalculusFieldElement)nextT.subtract(finalTime)).getReal() <= 0.0;
            hNew = this.getStepSizeHelper().filterStep(scaledH, forward, nextIsLast);
            CalculusFieldElement filteredNextT = (CalculusFieldElement)this.getStepStart().getTime().add((FieldElement)hNew);
            boolean bl = forward ? ((CalculusFieldElement)filteredNextT.subtract(finalTime)).getReal() >= 0.0 : (filteredNextIsLast = ((CalculusFieldElement)filteredNextT.subtract(finalTime)).getReal() <= 0.0);
            if (!filteredNextIsLast) continue;
            hNew = (CalculusFieldElement)finalTime.subtract(this.getStepStart().getTime());
        } while (!this.isLastStep());
        FieldODEStateAndDerivative finalState = this.getStepStart();
        this.resetInternalState();
        return finalState;
    }

    public T getMinReduction() {
        return this.minReduction;
    }

    public void setMinReduction(T minReduction) {
        this.minReduction = minReduction;
    }

    public T getMaxGrowth() {
        return this.maxGrowth;
    }

    public void setMaxGrowth(T maxGrowth) {
        this.maxGrowth = maxGrowth;
    }

    protected abstract double estimateError(T[][] var1, T[] var2, T[] var3, T var4);
}

