/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode.nonstiff;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.linear.Array2DRowFieldMatrix;
import org.hipparchus.linear.ArrayFieldVector;
import org.hipparchus.linear.FieldDecompositionSolver;
import org.hipparchus.linear.FieldLUDecomposition;
import org.hipparchus.linear.FieldMatrix;
import org.hipparchus.linear.FieldVector;
import org.hipparchus.util.MathArrays;

public class AdamsNordsieckFieldTransformer<T extends CalculusFieldElement<T>> {
    private static final Map<Integer, Map<Field<? extends CalculusFieldElement<?>>, AdamsNordsieckFieldTransformer<? extends CalculusFieldElement<?>>>> CACHE = new HashMap();
    private final Field<T> field;
    private final Array2DRowFieldMatrix<T> update;
    private final T[] c1;

    private AdamsNordsieckFieldTransformer(Field<T> field, int n) {
        this.field = field;
        int rows = n - 1;
        FieldMatrix<T> bigP = this.buildP(rows);
        FieldDecompositionSolver pSolver = new FieldLUDecomposition(bigP).getSolver();
        Object[] u = (CalculusFieldElement[])MathArrays.buildArray(field, (int)rows);
        Arrays.fill(u, field.getOne());
        this.c1 = (CalculusFieldElement[])pSolver.solve((FieldVector)new ArrayFieldVector((FieldElement[])u, false)).toArray();
        CalculusFieldElement[][] shiftedP = (CalculusFieldElement[][])bigP.getData();
        for (int i = shiftedP.length - 1; i > 0; --i) {
            shiftedP[i] = shiftedP[i - 1];
        }
        shiftedP[0] = (CalculusFieldElement[])MathArrays.buildArray(field, (int)rows);
        Arrays.fill(shiftedP[0], field.getZero());
        this.update = new Array2DRowFieldMatrix(pSolver.solve((FieldMatrix)new Array2DRowFieldMatrix((FieldElement[][])shiftedP, false)).getData());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends CalculusFieldElement<T>> AdamsNordsieckFieldTransformer<T> getInstance(Field<T> field, int nSteps) {
        Map<Integer, Map<Field<? extends CalculusFieldElement<?>>, AdamsNordsieckFieldTransformer<? extends CalculusFieldElement<?>>>> map = CACHE;
        synchronized (map) {
            AdamsNordsieckFieldTransformer<Object> t;
            Map<Field<CalculusFieldElement<?>>, AdamsNordsieckFieldTransformer<CalculusFieldElement<?>>> map2 = CACHE.get(nSteps);
            if (map2 == null) {
                map2 = new HashMap();
                CACHE.put(nSteps, map2);
            }
            if ((t = map2.get(field)) == null) {
                t = new AdamsNordsieckFieldTransformer<T>(field, nSteps);
                map2.put(field, t);
            }
            return t;
        }
    }

    private FieldMatrix<T> buildP(int rows) {
        CalculusFieldElement[][] pData = (CalculusFieldElement[][])MathArrays.buildArray(this.field, (int)rows, (int)rows);
        for (int i = 1; i <= pData.length; ++i) {
            CalculusFieldElement[] pI = pData[i - 1];
            int factor = -i;
            CalculusFieldElement aj = (CalculusFieldElement)((CalculusFieldElement)this.field.getZero()).add((double)factor);
            for (int j = 1; j <= pI.length; ++j) {
                pI[j - 1] = (CalculusFieldElement)aj.multiply(j + 1);
                aj = (CalculusFieldElement)aj.multiply(factor);
            }
        }
        return new Array2DRowFieldMatrix((FieldElement[][])pData, false);
    }

    public Array2DRowFieldMatrix<T> initializeHighOrderDerivatives(T h, T[] t, T[][] y, T[][] yDot) {
        CalculusFieldElement[][] a = (CalculusFieldElement[][])MathArrays.buildArray(this.field, (int)(this.c1.length + 1), (int)(this.c1.length + 1));
        CalculusFieldElement[][] b = (CalculusFieldElement[][])MathArrays.buildArray(this.field, (int)(this.c1.length + 1), (int)y[0].length);
        T[] y0 = y[0];
        T[] yDot0 = yDot[0];
        for (int i = 1; i < y.length; ++i) {
            CalculusFieldElement di = (CalculusFieldElement)t[i].subtract(t[0]);
            CalculusFieldElement ratio = (CalculusFieldElement)di.divide(h);
            CalculusFieldElement dikM1Ohk = (CalculusFieldElement)h.reciprocal();
            CalculusFieldElement[] aI = a[2 * i - 2];
            CalculusFieldElement[] aDotI = 2 * i - 1 < a.length ? a[2 * i - 1] : null;
            for (int j = 0; j < aI.length; ++j) {
                dikM1Ohk = (CalculusFieldElement)dikM1Ohk.multiply((FieldElement)ratio);
                aI[j] = (CalculusFieldElement)di.multiply((FieldElement)dikM1Ohk);
                if (aDotI == null) continue;
                aDotI[j] = (CalculusFieldElement)dikM1Ohk.multiply(j + 2);
            }
            T[] yI = y[i];
            T[] yDotI = yDot[i];
            CalculusFieldElement[] bI = b[2 * i - 2];
            CalculusFieldElement[] bDotI = 2 * i - 1 < b.length ? b[2 * i - 1] : null;
            for (int j = 0; j < yI.length; ++j) {
                bI[j] = (CalculusFieldElement)((CalculusFieldElement)yI[j].subtract(y0[j])).subtract(di.multiply(yDot0[j]));
                if (bDotI == null) continue;
                bDotI[j] = (CalculusFieldElement)yDotI[j].subtract(yDot0[j]);
            }
        }
        FieldLUDecomposition decomposition = new FieldLUDecomposition((FieldMatrix)new Array2DRowFieldMatrix((FieldElement[][])a, false));
        FieldMatrix x = decomposition.getSolver().solve((FieldMatrix)new Array2DRowFieldMatrix((FieldElement[][])b, false));
        Array2DRowFieldMatrix truncatedX = new Array2DRowFieldMatrix(this.field, x.getRowDimension() - 1, x.getColumnDimension());
        for (int i = 0; i < truncatedX.getRowDimension(); ++i) {
            for (int j = 0; j < truncatedX.getColumnDimension(); ++j) {
                truncatedX.setEntry(i, j, x.getEntry(i, j));
            }
        }
        return truncatedX;
    }

    public Array2DRowFieldMatrix<T> updateHighOrderDerivativesPhase1(Array2DRowFieldMatrix<T> highOrder) {
        return this.update.multiply(highOrder);
    }

    public void updateHighOrderDerivativesPhase2(T[] start, T[] end, Array2DRowFieldMatrix<T> highOrder) {
        CalculusFieldElement[][] data = (CalculusFieldElement[][])highOrder.getDataRef();
        for (int i = 0; i < data.length; ++i) {
            CalculusFieldElement[] dataI = data[i];
            T c1I = this.c1[i];
            for (int j = 0; j < dataI.length; ++j) {
                dataI[j] = (CalculusFieldElement)dataI[j].add(c1I.multiply(start[j].subtract(end[j])));
            }
        }
    }
}

