/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode.nonstiff;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.linear.Array2DRowFieldMatrix;
import org.hipparchus.linear.FieldMatrix;
import org.hipparchus.ode.FieldEquationsMapper;
import org.hipparchus.ode.FieldODEStateAndDerivative;
import org.hipparchus.ode.nonstiff.AdamsFieldIntegrator;
import org.hipparchus.ode.nonstiff.AdamsFieldStateInterpolator;
import org.hipparchus.ode.nonstiff.StepsizeHelper;
import org.hipparchus.util.FastMath;

public class AdamsBashforthFieldIntegrator<T extends CalculusFieldElement<T>>
extends AdamsFieldIntegrator<T> {
    private static final String METHOD_NAME = "Adams-Bashforth";

    public AdamsBashforthFieldIntegrator(Field<T> field, int nSteps, double minStep, double maxStep, double scalAbsoluteTolerance, double scalRelativeTolerance) throws MathIllegalArgumentException {
        super(field, METHOD_NAME, nSteps, nSteps, minStep, maxStep, scalAbsoluteTolerance, scalRelativeTolerance);
    }

    public AdamsBashforthFieldIntegrator(Field<T> field, int nSteps, double minStep, double maxStep, double[] vecAbsoluteTolerance, double[] vecRelativeTolerance) throws IllegalArgumentException {
        super(field, METHOD_NAME, nSteps, nSteps, minStep, maxStep, vecAbsoluteTolerance, vecRelativeTolerance);
    }

    @Override
    protected double errorEstimation(T[] previousState, T predictedTime, T[] predictedState, T[] predictedScaled, FieldMatrix<T> predictedNordsieck) {
        StepsizeHelper helper = this.getStepSizeHelper();
        double error = 0.0;
        for (int i = 0; i < helper.getMainSetDimension(); ++i) {
            double tol = helper.getTolerance(i, FastMath.abs((double)predictedState[i].getReal()));
            double variation = 0.0;
            int sign = predictedNordsieck.getRowDimension() % 2 == 0 ? -1 : 1;
            for (int k = predictedNordsieck.getRowDimension() - 1; k >= 0; --k) {
                variation += (double)sign * ((CalculusFieldElement)predictedNordsieck.getEntry(k, i)).getReal();
                sign = -sign;
            }
            double ratio = (predictedState[i].getReal() - previousState[i].getReal() + (variation -= predictedScaled[i].getReal())) / tol;
            error += ratio * ratio;
        }
        return FastMath.sqrt((double)(error / (double)helper.getMainSetDimension()));
    }

    @Override
    protected AdamsFieldStateInterpolator<T> finalizeStep(T stepSize, T[] predictedY, T[] predictedScaled, Array2DRowFieldMatrix<T> predictedNordsieck, boolean isForward, FieldODEStateAndDerivative<T> globalPreviousState, FieldODEStateAndDerivative<T> globalCurrentState, FieldEquationsMapper<T> equationsMapper) {
        return new AdamsFieldStateInterpolator(this.getStepSize(), globalCurrentState, predictedScaled, predictedNordsieck, isForward, this.getStepStart(), globalCurrentState, equationsMapper);
    }
}

