/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode.events;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.FieldElement;
import org.hipparchus.analysis.CalculusFieldUnivariateFunction;
import org.hipparchus.analysis.solvers.BracketedRealFieldUnivariateSolver;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.exception.MathRuntimeException;
import org.hipparchus.ode.FieldODEState;
import org.hipparchus.ode.FieldODEStateAndDerivative;
import org.hipparchus.ode.events.Action;
import org.hipparchus.ode.events.FieldEventHandlerConfiguration;
import org.hipparchus.ode.events.FieldODEEventHandler;
import org.hipparchus.ode.sampling.FieldODEStateInterpolator;
import org.hipparchus.util.FastMath;

public class FieldEventState<T extends CalculusFieldElement<T>>
implements FieldEventHandlerConfiguration<T> {
    private final FieldODEEventHandler<T> handler;
    private final double maxCheckInterval;
    private final T convergence;
    private final int maxIterationCount;
    private T t0;
    private T g0;
    private boolean g0Positive;
    private boolean pendingEvent;
    private T pendingEventTime;
    private T stopTime;
    private T afterEvent;
    private T afterG;
    private T earliestTimeConsidered;
    private boolean forward;
    private boolean increasing;
    private final BracketedRealFieldUnivariateSolver<T> solver;

    public FieldEventState(FieldODEEventHandler<T> handler, double maxCheckInterval, T convergence, int maxIterationCount, BracketedRealFieldUnivariateSolver<T> solver) {
        this.handler = handler;
        this.maxCheckInterval = maxCheckInterval;
        this.convergence = (CalculusFieldElement)convergence.abs();
        this.maxIterationCount = maxIterationCount;
        this.solver = solver;
        this.t0 = null;
        this.g0 = null;
        this.g0Positive = true;
        this.pendingEvent = false;
        this.pendingEventTime = null;
        this.increasing = true;
        this.earliestTimeConsidered = null;
        this.afterEvent = null;
        this.afterG = null;
    }

    @Override
    public FieldODEEventHandler<T> getEventHandler() {
        return this.handler;
    }

    @Override
    public double getMaxCheckInterval() {
        return this.maxCheckInterval;
    }

    @Override
    public T getConvergence() {
        return this.convergence;
    }

    @Override
    public int getMaxIterationCount() {
        return this.maxIterationCount;
    }

    @Override
    public BracketedRealFieldUnivariateSolver<T> getSolver() {
        return this.solver;
    }

    public void reinitializeBegin(FieldODEStateInterpolator<T> interpolator) throws MathIllegalStateException {
        this.forward = interpolator.isForward();
        FieldODEStateAndDerivative<T> s0 = interpolator.getPreviousState();
        this.t0 = s0.getTime();
        this.g0 = this.handler.g(s0);
        while (this.g0.getReal() == 0.0) {
            CalculusFieldElement epsilon = this.max(this.solver.getAbsoluteAccuracy(), (CalculusFieldElement)((CalculusFieldElement)this.solver.getRelativeAccuracy().multiply(this.t0)).abs());
            Object tStart = (CalculusFieldElement)this.t0.add(epsilon.multiply(this.forward ? 0.5 : -0.5));
            if (tStart.equals(this.t0)) {
                tStart = this.nextAfter(this.t0);
            }
            this.t0 = tStart;
            this.g0 = this.handler.g(interpolator.getInterpolatedState((CalculusFieldElement)tStart));
        }
        this.increasing = this.g0Positive = this.g0.getReal() > 0.0;
    }

    private T max(T a, T b) {
        return a.getReal() > b.getReal() ? a : b;
    }

    private T min(T a, T b) {
        return a.getReal() < b.getReal() ? a : b;
    }

    public boolean evaluateStep(FieldODEStateInterpolator<T> interpolator) throws MathIllegalArgumentException, MathIllegalStateException {
        this.forward = interpolator.isForward();
        FieldODEStateAndDerivative<T> s1 = interpolator.getCurrentState();
        Object t1 = s1.getTime();
        CalculusFieldElement dt = (CalculusFieldElement)t1.subtract(this.t0);
        if (((CalculusFieldElement)((CalculusFieldElement)dt.abs()).subtract(this.convergence)).getReal() < 0.0) {
            return false;
        }
        int n = FastMath.max((int)1, (int)((int)FastMath.ceil((double)(FastMath.abs((double)dt.getReal()) / this.maxCheckInterval))));
        CalculusFieldElement h = (CalculusFieldElement)dt.divide((double)n);
        T ta = this.t0;
        T ga = this.g0;
        for (int i = 0; i < n; ++i) {
            Object tb = i == n - 1 ? t1 : (CalculusFieldElement)this.t0.add(h.multiply(i + 1));
            T gb = this.handler.g(interpolator.getInterpolatedState(tb));
            if (gb.getReal() == 0.0 || this.g0Positive ^ gb.getReal() > 0.0) {
                if (!this.findRoot(interpolator, ta, ga, tb, gb)) continue;
                return true;
            }
            ta = tb;
            ga = gb;
        }
        this.pendingEvent = false;
        this.pendingEventTime = null;
        return false;
    }

    private boolean findRoot(FieldODEStateInterpolator<T> interpolator, T ta, T ga, T tb, T gb) {
        this.check(ga.getReal() == 0.0 || gb.getReal() == 0.0 || ga.getReal() > 0.0 && gb.getReal() < 0.0 || ga.getReal() < 0.0 && gb.getReal() > 0.0);
        CalculusFieldUnivariateFunction f = t -> this.handler.g(interpolator.getInterpolatedState(t));
        CalculusFieldElement beforeRootT = null;
        Object beforeRootG = null;
        Object afterRootT = ta;
        CalculusFieldElement afterRootG = (CalculusFieldElement)ga.getField().getZero();
        if (ta.getReal() == tb.getReal()) {
            beforeRootT = (CalculusFieldElement)ta;
            beforeRootG = ga;
            afterRootT = this.shiftedBy(beforeRootT, this.convergence);
            afterRootG = f.value(afterRootT);
        } else if (ga.getReal() != 0.0 && gb.getReal() == 0.0) {
            beforeRootT = (CalculusFieldElement)tb;
            beforeRootG = gb;
            afterRootT = this.shiftedBy(beforeRootT, this.convergence);
            afterRootG = f.value(afterRootT);
        } else if (ga.getReal() != 0.0) {
            CalculusFieldElement newGa = f.value(ta);
            if (ga.getReal() > 0.0 != newGa.getReal() > 0.0) {
                beforeRootT = (CalculusFieldElement)ta;
                beforeRootG = newGa;
                afterRootT = this.minTime(this.shiftedBy(beforeRootT, this.convergence), tb);
                afterRootG = f.value(afterRootT);
            }
        }
        T loopT = ta;
        Object loopG = ga;
        while ((afterRootG.getReal() == 0.0 || afterRootG.getReal() > 0.0 == this.g0Positive) && this.strictlyAfter(afterRootT, tb)) {
            BracketedRealFieldUnivariateSolver.Interval interval;
            if (loopG.getReal() == 0.0) {
                beforeRootT = (CalculusFieldElement)loopT;
                beforeRootG = loopG;
                afterRootT = this.minTime(this.shiftedBy(beforeRootT, this.convergence), tb);
                afterRootG = f.value(afterRootT);
            } else if (this.forward) {
                interval = this.solver.solveInterval(this.maxIterationCount, f, loopT, tb);
                beforeRootT = interval.getLeftAbscissa();
                beforeRootG = interval.getLeftValue();
                afterRootT = interval.getRightAbscissa();
                afterRootG = interval.getRightValue();
            } else {
                interval = this.solver.solveInterval(this.maxIterationCount, f, tb, loopT);
                beforeRootT = interval.getRightAbscissa();
                beforeRootG = interval.getRightValue();
                afterRootT = interval.getLeftAbscissa();
                afterRootG = interval.getLeftValue();
            }
            if (beforeRootT == afterRootT) {
                afterRootT = this.nextAfter(afterRootT);
                afterRootG = f.value(afterRootT);
            }
            this.check(this.forward && afterRootT.getReal() > beforeRootT.getReal() || !this.forward && afterRootT.getReal() < beforeRootT.getReal());
            loopT = afterRootT;
            loopG = afterRootG;
        }
        if (afterRootG.getReal() == 0.0 || afterRootG.getReal() > 0.0 == this.g0Positive) {
            return false;
        }
        this.check(beforeRootT != null && beforeRootG != null);
        this.increasing = !this.g0Positive;
        this.pendingEventTime = beforeRootT;
        this.stopTime = beforeRootG.getReal() == 0.0 ? beforeRootT : afterRootT;
        this.pendingEvent = true;
        this.afterEvent = afterRootT;
        this.afterG = afterRootG;
        this.check(this.afterG.getReal() > 0.0 == this.increasing);
        this.check(this.increasing == gb.getReal() >= ga.getReal());
        return true;
    }

    public boolean tryAdvance(FieldODEStateAndDerivative<T> state, FieldODEStateInterpolator<T> interpolator) {
        boolean meFirst;
        Object t = state.getTime();
        this.check(!this.pendingEvent || !this.strictlyAfter(this.pendingEventTime, t));
        if (this.earliestTimeConsidered != null && this.strictlyAfter(t, this.earliestTimeConsidered)) {
            meFirst = false;
        } else {
            boolean positive;
            T g = this.handler.g(state);
            boolean bl = positive = g.getReal() > 0.0;
            if (positive == this.g0Positive) {
                this.g0 = g;
                meFirst = false;
            } else {
                T oldPendingEventTime = this.pendingEventTime;
                boolean foundRoot = this.findRoot(interpolator, this.t0, this.g0, t, g);
                boolean bl2 = meFirst = foundRoot && !this.pendingEventTime.equals(oldPendingEventTime);
            }
        }
        if (!meFirst) {
            this.t0 = t;
        }
        return meFirst;
    }

    public EventOccurrence<T> doEvent(FieldODEStateAndDerivative<T> state) {
        this.check(this.pendingEvent);
        this.check(state.getTime() == this.pendingEventTime);
        Action action = this.handler.eventOccurred(state, this.increasing == this.forward);
        FieldODEState newState = action == Action.RESET_STATE ? this.handler.resetState(state) : state;
        this.pendingEvent = false;
        this.pendingEventTime = null;
        this.earliestTimeConsidered = this.afterEvent;
        this.t0 = this.afterEvent;
        this.g0 = this.afterG;
        this.g0Positive = this.increasing;
        this.check(this.g0.getReal() == 0.0 || this.g0Positive == this.g0.getReal() > 0.0);
        return new EventOccurrence<T>(action, newState, this.stopTime);
    }

    private boolean strictlyAfter(T t1, T t2) {
        return this.forward ? t1.getReal() < t2.getReal() : t2.getReal() < t1.getReal();
    }

    private T nextAfter(T t) {
        int sign = this.forward ? 1 : -1;
        double ulp = FastMath.ulp((double)t.getReal());
        return (T)((CalculusFieldElement)t.add((double)sign * ulp));
    }

    private void check(boolean condition) throws MathRuntimeException {
        if (!condition) {
            throw MathRuntimeException.createInternalError();
        }
    }

    private T minTime(T a, T b) {
        return this.forward ? this.min(a, b) : this.max(a, b);
    }

    private T shiftedBy(T t, T delta) {
        if (this.forward) {
            CalculusFieldElement ret = (CalculusFieldElement)t.add(delta);
            if (((CalculusFieldElement)ret.subtract(t)).getReal() > delta.getReal()) {
                return (T)((CalculusFieldElement)ret.subtract(FastMath.ulp((double)ret.getReal())));
            }
            return (T)ret;
        }
        CalculusFieldElement ret = (CalculusFieldElement)t.subtract(delta);
        if (((CalculusFieldElement)t.subtract((FieldElement)ret)).getReal() > delta.getReal()) {
            return (T)((CalculusFieldElement)ret.add(FastMath.ulp((double)ret.getReal())));
        }
        return (T)ret;
    }

    public T getEventTime() {
        return (T)(this.pendingEvent ? this.pendingEventTime : (CalculusFieldElement)((CalculusFieldElement)this.t0.getField().getZero()).add(this.forward ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY));
    }

    public static class EventOccurrence<T extends CalculusFieldElement<T>> {
        private final Action action;
        private final FieldODEState<T> newState;
        private final T stopTime;

        EventOccurrence(Action action, FieldODEState<T> newState, T stopTime) {
            this.action = action;
            this.newState = newState;
            this.stopTime = stopTime;
        }

        public Action getAction() {
            return this.action;
        }

        public FieldODEState<T> getNewState() {
            return this.newState;
        }

        public T getStopTime() {
            return this.stopTime;
        }
    }
}

