/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode.events;

import org.hipparchus.analysis.UnivariateFunction;
import org.hipparchus.analysis.solvers.BracketedUnivariateSolver;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.exception.MathRuntimeException;
import org.hipparchus.ode.ODEState;
import org.hipparchus.ode.ODEStateAndDerivative;
import org.hipparchus.ode.events.Action;
import org.hipparchus.ode.events.EventHandlerConfiguration;
import org.hipparchus.ode.events.ODEEventHandler;
import org.hipparchus.ode.sampling.ODEStateInterpolator;
import org.hipparchus.util.FastMath;

public class EventState
implements EventHandlerConfiguration {
    private final ODEEventHandler handler;
    private final double maxCheckInterval;
    private final double convergence;
    private final int maxIterationCount;
    private double t0;
    private double g0;
    private boolean g0Positive;
    private boolean pendingEvent;
    private double pendingEventTime;
    private double stopTime;
    private double afterEvent;
    private double afterG;
    private double earliestTimeConsidered;
    private boolean forward;
    private boolean increasing;
    private final BracketedUnivariateSolver<UnivariateFunction> solver;

    public EventState(ODEEventHandler handler, double maxCheckInterval, double convergence, int maxIterationCount, BracketedUnivariateSolver<UnivariateFunction> solver) {
        this.handler = handler;
        this.maxCheckInterval = maxCheckInterval;
        this.convergence = FastMath.abs((double)convergence);
        this.maxIterationCount = maxIterationCount;
        this.solver = solver;
        this.t0 = Double.NaN;
        this.g0 = Double.NaN;
        this.g0Positive = true;
        this.pendingEvent = false;
        this.pendingEventTime = Double.NaN;
        this.increasing = true;
        this.earliestTimeConsidered = Double.NaN;
        this.afterEvent = Double.NaN;
        this.afterG = Double.NaN;
    }

    @Override
    public ODEEventHandler getEventHandler() {
        return this.handler;
    }

    @Override
    public double getMaxCheckInterval() {
        return this.maxCheckInterval;
    }

    @Override
    public double getConvergence() {
        return this.convergence;
    }

    @Override
    public int getMaxIterationCount() {
        return this.maxIterationCount;
    }

    @Override
    public BracketedUnivariateSolver<UnivariateFunction> getSolver() {
        return this.solver;
    }

    public void reinitializeBegin(ODEStateInterpolator interpolator) throws MathIllegalStateException {
        this.forward = interpolator.isForward();
        ODEStateAndDerivative s0 = interpolator.getPreviousState();
        this.t0 = s0.getTime();
        this.g0 = this.handler.g(s0);
        while (this.g0 == 0.0) {
            double epsilon;
            double tStart = this.t0 + (this.forward ? 0.5 : -0.5) * (epsilon = FastMath.max((double)this.solver.getAbsoluteAccuracy(), (double)FastMath.abs((double)(this.solver.getRelativeAccuracy() * this.t0))));
            if (tStart == this.t0) {
                tStart = this.nextAfter(this.t0);
            }
            this.t0 = tStart;
            this.g0 = this.handler.g(interpolator.getInterpolatedState(tStart));
        }
        this.increasing = this.g0Positive = this.g0 > 0.0;
    }

    public boolean evaluateStep(ODEStateInterpolator interpolator) throws MathIllegalArgumentException, MathIllegalStateException {
        this.forward = interpolator.isForward();
        ODEStateAndDerivative s1 = interpolator.getCurrentState();
        double t1 = s1.getTime();
        double dt = t1 - this.t0;
        if (FastMath.abs((double)dt) < this.convergence) {
            return false;
        }
        int n = FastMath.max((int)1, (int)((int)FastMath.ceil((double)(FastMath.abs((double)dt) / this.maxCheckInterval))));
        double h = dt / (double)n;
        double ta = this.t0;
        double ga = this.g0;
        for (int i = 0; i < n; ++i) {
            double tb = i == n - 1 ? t1 : this.t0 + (double)(i + 1) * h;
            double gb = this.handler.g(interpolator.getInterpolatedState(tb));
            if (gb == 0.0 || this.g0Positive ^ gb > 0.0) {
                if (!this.findRoot(interpolator, ta, ga, tb, gb)) continue;
                return true;
            }
            ta = tb;
            ga = gb;
        }
        this.pendingEvent = false;
        this.pendingEventTime = Double.NaN;
        return false;
    }

    private boolean findRoot(ODEStateInterpolator interpolator, double ta, double ga, double tb, double gb) {
        double newGa;
        this.check(ga == 0.0 || gb == 0.0 || ga > 0.0 && gb < 0.0 || ga < 0.0 && gb > 0.0);
        UnivariateFunction f = t -> this.handler.g(interpolator.getInterpolatedState(t));
        double beforeRootT = Double.NaN;
        double beforeRootG = Double.NaN;
        double afterRootT = ta;
        double afterRootG = 0.0;
        if (ta == tb) {
            beforeRootT = ta;
            beforeRootG = ga;
            afterRootT = this.shiftedBy(beforeRootT, this.convergence);
            afterRootG = f.value(afterRootT);
        } else if (ga != 0.0 && gb == 0.0) {
            beforeRootT = tb;
            beforeRootG = gb;
            afterRootT = this.shiftedBy(beforeRootT, this.convergence);
            afterRootG = f.value(afterRootT);
        } else if (ga != 0.0 && ga > 0.0 != (newGa = f.value(ta)) > 0.0) {
            beforeRootT = ta;
            beforeRootG = newGa;
            afterRootT = this.minTime(this.shiftedBy(beforeRootT, this.convergence), tb);
            afterRootG = f.value(afterRootT);
        }
        double loopT = ta;
        double loopG = ga;
        while ((afterRootG == 0.0 || afterRootG > 0.0 == this.g0Positive) && this.strictlyAfter(afterRootT, tb)) {
            BracketedUnivariateSolver.Interval interval;
            if (loopG == 0.0) {
                beforeRootT = loopT;
                beforeRootG = loopG;
                afterRootT = this.minTime(this.shiftedBy(beforeRootT, this.convergence), tb);
                afterRootG = f.value(afterRootT);
            } else if (this.forward) {
                interval = this.solver.solveInterval(this.maxIterationCount, f, loopT, tb);
                beforeRootT = interval.getLeftAbscissa();
                beforeRootG = interval.getLeftValue();
                afterRootT = interval.getRightAbscissa();
                afterRootG = interval.getRightValue();
            } else {
                interval = this.solver.solveInterval(this.maxIterationCount, f, tb, loopT);
                beforeRootT = interval.getRightAbscissa();
                beforeRootG = interval.getRightValue();
                afterRootT = interval.getLeftAbscissa();
                afterRootG = interval.getLeftValue();
            }
            if (beforeRootT == afterRootT) {
                afterRootT = this.nextAfter(afterRootT);
                afterRootG = f.value(afterRootT);
            }
            this.check(this.forward && afterRootT > beforeRootT || !this.forward && afterRootT < beforeRootT);
            loopT = afterRootT;
            loopG = afterRootG;
        }
        if (afterRootG == 0.0 || afterRootG > 0.0 == this.g0Positive) {
            return false;
        }
        this.check(!Double.isNaN(beforeRootT) && !Double.isNaN(beforeRootG));
        this.increasing = !this.g0Positive;
        this.pendingEventTime = beforeRootT;
        this.stopTime = beforeRootG == 0.0 ? beforeRootT : afterRootT;
        this.pendingEvent = true;
        this.afterEvent = afterRootT;
        this.afterG = afterRootG;
        this.check(this.afterG > 0.0 == this.increasing);
        this.check(this.increasing == gb >= ga);
        return true;
    }

    private double nextAfter(double t) {
        double dir = this.forward ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
        return FastMath.nextAfter((double)t, (double)dir);
    }

    public double getEventTime() {
        return this.pendingEvent ? this.pendingEventTime : (this.forward ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY);
    }

    public boolean tryAdvance(ODEStateAndDerivative state, ODEStateInterpolator interpolator) {
        boolean meFirst;
        double t = state.getTime();
        this.check(!this.pendingEvent || !this.strictlyAfter(this.pendingEventTime, t));
        if (this.strictlyAfter(t, this.earliestTimeConsidered)) {
            meFirst = false;
        } else {
            boolean positive;
            double g = this.handler.g(state);
            boolean bl = positive = g > 0.0;
            if (positive == this.g0Positive) {
                this.g0 = g;
                meFirst = false;
            } else {
                double oldPendingEventTime = this.pendingEventTime;
                boolean foundRoot = this.findRoot(interpolator, this.t0, this.g0, t, g);
                boolean bl2 = meFirst = foundRoot && (Double.isNaN(oldPendingEventTime) || oldPendingEventTime != this.pendingEventTime);
            }
        }
        if (!meFirst) {
            this.t0 = t;
        }
        return meFirst;
    }

    public EventOccurrence doEvent(ODEStateAndDerivative state) {
        this.check(this.pendingEvent);
        this.check(state.getTime() == this.pendingEventTime);
        Action action = this.handler.eventOccurred(state, this.increasing == this.forward);
        ODEState newState = action == Action.RESET_STATE ? this.handler.resetState(state) : state;
        this.pendingEvent = false;
        this.pendingEventTime = Double.NaN;
        this.earliestTimeConsidered = this.afterEvent;
        this.t0 = this.afterEvent;
        this.g0 = this.afterG;
        this.g0Positive = this.increasing;
        this.check(this.g0 == 0.0 || this.g0Positive == this.g0 > 0.0);
        return new EventOccurrence(action, newState, this.stopTime);
    }

    private double shiftedBy(double t, double delta) {
        if (this.forward) {
            double ret = t + delta;
            if (ret - t > delta) {
                return FastMath.nextDown((double)ret);
            }
            return ret;
        }
        double ret = t - delta;
        if (t - ret > delta) {
            return FastMath.nextUp((double)ret);
        }
        return ret;
    }

    private double minTime(double a, double b) {
        return this.forward ? FastMath.min((double)a, (double)b) : FastMath.max((double)a, (double)b);
    }

    private boolean strictlyAfter(double t1, double t2) {
        return this.forward ? t1 < t2 : t2 < t1;
    }

    private void check(boolean condition) throws MathRuntimeException {
        if (!condition) {
            throw MathRuntimeException.createInternalError();
        }
    }

    public static class EventOccurrence {
        private final Action action;
        private final ODEState newState;
        private final double stopTime;

        EventOccurrence(Action action, ODEState newState, double stopTime) {
            this.action = action;
            this.newState = newState;
            this.stopTime = stopTime;
        }

        public Action getAction() {
            return this.action;
        }

        public ODEState getNewState() {
            return this.newState;
        }

        public double getStopTime() {
            return this.stopTime;
        }
    }
}

