/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.utils.units;

import org.hipparchus.exception.Localizable;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.utils.units.Unit;

public class UnitsConverter {
    public static final UnitsConverter IDENTITY = new UnitsConverter(Unit.ONE, Unit.ONE);
    public static final UnitsConverter PERCENTS_TO_UNIT = new UnitsConverter(Unit.PERCENT, Unit.ONE);
    public static final UnitsConverter ARC_SECONDS_TO_RADIANS = new UnitsConverter(Unit.parse("as"), Unit.RADIAN);
    public static final UnitsConverter MILLI_ARC_SECONDS_TO_RADIANS = new UnitsConverter(Unit.parse("mas"), Unit.RADIAN);
    public static final UnitsConverter MILLI_SECONDS_TO_SECONDS = new UnitsConverter(Unit.parse("ms"), Unit.SECOND);
    public static final UnitsConverter DAYS_TO_SECONDS = new UnitsConverter(Unit.DAY, Unit.SECOND);
    public static final UnitsConverter KILOMETRES_TO_METRES = new UnitsConverter(Unit.KILOMETRE, Unit.METRE);
    public static final UnitsConverter KILOMETRES_2_TO_METRES_2 = new UnitsConverter(Unit.parse("km\u00b2"), Unit.parse("m\u00b2"));
    public static final UnitsConverter KM3_P_S2_TO_M3_P_S2 = new UnitsConverter(Unit.parse("km\u00b3/s\u00b2"), Unit.parse("m\u00b3/s\u00b2"));
    private final Unit from;
    private final Unit to;
    private final double factor;

    public UnitsConverter(Unit from, Unit to) {
        this.from = from;
        this.to = to;
        if (!from.sameDimension(to)) {
            throw new OrekitException((Localizable)OrekitMessages.INCOMPATIBLE_UNITS, from.getName(), to.getName());
        }
        this.factor = from.getScale() / to.getScale();
    }

    public Unit getFrom() {
        return this.from;
    }

    public Unit getTo() {
        return this.to;
    }

    public double convert(double value) {
        return this.factor * value;
    }

    public String toString() {
        return this.from.getName() + " \u2192 " + this.to.getName();
    }
}

