/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.utils.units;

import org.hipparchus.exception.Localizable;
import org.hipparchus.fraction.Fraction;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.utils.units.Token;
import org.orekit.utils.units.TokenType;

class Lexer {
    private final CharSequence unitSpecification;
    private final int end;
    private int start;
    private Token nextToLast;
    private Token last;
    private Token upcoming;

    Lexer(CharSequence unitSpecification) {
        this.unitSpecification = unitSpecification;
        this.end = unitSpecification.length();
        this.start = 0;
        this.last = null;
    }

    public String getUnitSpecification() {
        return this.unitSpecification.toString();
    }

    public void pushBack() {
        this.upcoming = this.last;
        this.last = this.nextToLast;
    }

    public Token next() {
        char c;
        int numberStart;
        int sign;
        Converter converter;
        int current;
        if (this.upcoming != null) {
            this.nextToLast = this.last;
            this.last = this.upcoming;
            this.upcoming = null;
            return this.last;
        }
        while (this.start < this.end && Character.isWhitespace(this.unitSpecification.charAt(this.start))) {
            ++this.start;
        }
        if (this.start >= this.end) {
            this.nextToLast = this.last;
            this.last = null;
            return null;
        }
        for (current = this.start; current < this.end && (Character.isLowerCase(this.unitSpecification.charAt(current)) || Character.isUpperCase(this.unitSpecification.charAt(current)) || this.unitSpecification.charAt(current) == '\u00b0' || this.unitSpecification.charAt(current) == '\u25e6' || this.unitSpecification.charAt(current) == '\u2032' || this.unitSpecification.charAt(current) == '\'' || this.unitSpecification.charAt(current) == '\u2033' || this.unitSpecification.charAt(current) == '\"' || this.unitSpecification.charAt(current) == '%' || this.unitSpecification.charAt(current) == '#'); ++current) {
        }
        if (current > this.start) {
            return this.emit(current, TokenType.IDENTIFIER, 0, 1);
        }
        if (this.start < this.end - 1 && this.unitSpecification.charAt(this.start) == '*' && this.unitSpecification.charAt(this.start + 1) == '*') {
            return this.emit(this.start + 2, TokenType.POWER, 0, 1);
        }
        if (this.unitSpecification.charAt(this.start) == '^') {
            return this.emit(this.start + 1, TokenType.POWER, 0, 1);
        }
        if (this.convertSuperscript(this.start) != ' ' && this.last != null && this.last.getType() != TokenType.POWER) {
            return this.emit(this.start, TokenType.POWER, 0, 1);
        }
        if (this.unitSpecification.charAt(this.start) == '*') {
            return this.emit(this.start + 1, TokenType.MULTIPLICATION, 0, 1);
        }
        if (this.unitSpecification.charAt(this.start) == '\u00d7') {
            return this.emit(this.start + 1, TokenType.MULTIPLICATION, 0, 1);
        }
        if (this.unitSpecification.charAt(this.start) == '.') {
            return this.emit(this.start + 1, TokenType.MULTIPLICATION, 0, 1);
        }
        if (this.unitSpecification.charAt(this.start) == '\u00b7') {
            return this.emit(this.start + 1, TokenType.MULTIPLICATION, 0, 1);
        }
        if (this.unitSpecification.charAt(this.start) == '/') {
            return this.emit(this.start + 1, TokenType.DIVISION, 0, 1);
        }
        if (this.unitSpecification.charAt(this.start) == '\u2044') {
            return this.emit(this.start + 1, TokenType.DIVISION, 0, 1);
        }
        if (this.unitSpecification.charAt(this.start) == '(') {
            return this.emit(this.start + 1, TokenType.OPEN, 0, 1);
        }
        if (this.unitSpecification.charAt(this.start) == ')') {
            return this.emit(this.start + 1, TokenType.CLOSE, 0, 1);
        }
        if (this.unitSpecification.charAt(this.start) == '\u221a') {
            return this.emit(this.start + 1, TokenType.SQUARE_ROOT, 0, 1);
        }
        if (this.start < this.end - 2 && this.unitSpecification.charAt(this.start) == '0' && this.unitSpecification.charAt(this.start + 1) == '.' && this.unitSpecification.charAt(this.start + 2) == '5') {
            return this.emit(this.start + 3, TokenType.FRACTION, 1, 2);
        }
        if (this.unitSpecification.charAt(this.start) == '\u00bc') {
            return this.emit(this.start + 1, TokenType.FRACTION, 1, 4);
        }
        if (this.unitSpecification.charAt(this.start) == '\u00bd') {
            return this.emit(this.start + 1, TokenType.FRACTION, 1, 2);
        }
        if (this.unitSpecification.charAt(this.start) == '\u00be') {
            return this.emit(this.start + 1, TokenType.FRACTION, 3, 4);
        }
        if (this.unitSpecification.charAt(this.start) == '\u2150') {
            return this.emit(this.start + 1, TokenType.FRACTION, 1, 7);
        }
        if (this.unitSpecification.charAt(this.start) == '\u2151') {
            return this.emit(this.start + 1, TokenType.FRACTION, 1, 9);
        }
        if (this.unitSpecification.charAt(this.start) == '\u2152') {
            return this.emit(this.start + 1, TokenType.FRACTION, 1, 10);
        }
        if (this.unitSpecification.charAt(this.start) == '\u2153') {
            return this.emit(this.start + 1, TokenType.FRACTION, 1, 3);
        }
        if (this.unitSpecification.charAt(this.start) == '\u2154') {
            return this.emit(this.start + 1, TokenType.FRACTION, 2, 3);
        }
        if (this.unitSpecification.charAt(this.start) == '\u2155') {
            return this.emit(this.start + 1, TokenType.FRACTION, 1, 5);
        }
        if (this.unitSpecification.charAt(this.start) == '\u2156') {
            return this.emit(this.start + 1, TokenType.FRACTION, 2, 5);
        }
        if (this.unitSpecification.charAt(this.start) == '\u2157') {
            return this.emit(this.start + 1, TokenType.FRACTION, 3, 5);
        }
        if (this.unitSpecification.charAt(this.start) == '\u2158') {
            return this.emit(this.start + 1, TokenType.FRACTION, 4, 5);
        }
        if (this.unitSpecification.charAt(this.start) == '\u2159') {
            return this.emit(this.start + 1, TokenType.FRACTION, 1, 6);
        }
        if (this.unitSpecification.charAt(this.start) == '\u215a') {
            return this.emit(this.start + 1, TokenType.FRACTION, 5, 6);
        }
        if (this.unitSpecification.charAt(this.start) == '\u215b') {
            return this.emit(this.start + 1, TokenType.FRACTION, 1, 8);
        }
        if (this.unitSpecification.charAt(this.start) == '\u215c') {
            return this.emit(this.start + 1, TokenType.FRACTION, 3, 8);
        }
        if (this.unitSpecification.charAt(this.start) == '\u215d') {
            return this.emit(this.start + 1, TokenType.FRACTION, 5, 8);
        }
        if (this.unitSpecification.charAt(this.start) == '\u215e') {
            return this.emit(this.start + 1, TokenType.FRACTION, 7, 8);
        }
        Converter converter2 = converter = this.convertSuperscript(this.start) == ' ' ? this::noConvert : this::convertSuperscript;
        if (converter.convert(this.start) == '+') {
            sign = 1;
            numberStart = this.start + 1;
        } else if (converter.convert(this.start) == '-') {
            sign = -1;
            numberStart = this.start + 1;
        } else {
            sign = 1;
            numberStart = this.start;
        }
        int value = 0;
        for (current = numberStart; current < this.end && (c = converter.convert(current)) >= '0' && c <= '9'; ++current) {
            value = value * 10 + (c - 48);
        }
        if (current > numberStart) {
            return this.emit(current, TokenType.INTEGER, sign * value, 1);
        }
        throw this.generateException();
    }

    public OrekitException generateException() {
        return new OrekitException((Localizable)OrekitMessages.UNKNOWN_UNIT, this.unitSpecification);
    }

    private Token emit(int after, TokenType type, int numerator, int denominator) {
        CharSequence subString = this.unitSpecification.subSequence(this.start, after);
        this.start = after;
        this.nextToLast = this.last;
        this.last = new Token(subString, type, numerator, denominator == 1 ? null : new Fraction(numerator, denominator));
        return this.last;
    }

    private char convertSuperscript(int index) {
        switch (this.unitSpecification.charAt(index)) {
            case '\u2070': {
                return '0';
            }
            case '\u00b9': {
                return '1';
            }
            case '\u00b2': {
                return '2';
            }
            case '\u00b3': {
                return '3';
            }
            case '\u2074': {
                return '4';
            }
            case '\u2075': {
                return '5';
            }
            case '\u2076': {
                return '6';
            }
            case '\u2077': {
                return '7';
            }
            case '\u2078': {
                return '8';
            }
            case '\u2079': {
                return '9';
            }
            case '\u207a': {
                return '+';
            }
            case '\u207b': {
                return '-';
            }
        }
        return ' ';
    }

    private char noConvert(int index) {
        return this.unitSpecification.charAt(index);
    }

    private static interface Converter {
        public char convert(int var1);
    }
}

