/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.utils;

import java.util.Collections;
import java.util.NavigableSet;
import java.util.SortedSet;
import java.util.TreeSet;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.ChronologicalComparator;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.TimeStamped;

public class FieldTimeSpanMap<T, D extends CalculusFieldElement<D>> {
    private final NavigableSet<Transition<T, D>> data = new TreeSet<TimeStamped>(new ChronologicalComparator());
    private final Field<D> field;

    public FieldTimeSpanMap(T entry, Field<D> field_n) {
        this.field = field_n;
        this.data.add(new Transition(FieldAbsoluteDate.getArbitraryEpoch(this.field), entry, entry));
    }

    public void addValidBefore(T entry, FieldAbsoluteDate<D> latestValidityDate) {
        Transition single;
        if (this.data.size() == 1 && (single = (Transition)this.data.first()).getBefore() == single.getAfter()) {
            this.data.clear();
            this.data.add(new Transition(latestValidityDate, entry, single.getAfter()));
            return;
        }
        Transition previous = this.data.floor(new Transition(latestValidityDate, entry, null));
        if (previous == null) {
            this.data.add(new Transition(latestValidityDate, entry, ((Transition)this.data.first()).getBefore()));
        } else {
            this.data.remove(previous);
            this.data.add(new Transition(previous.date, previous.getBefore(), entry));
            this.data.add(new Transition(latestValidityDate, entry, previous.getAfter()));
        }
    }

    public void addValidAfter(T entry, FieldAbsoluteDate<D> earliestValidityDate) {
        Transition single;
        if (this.data.size() == 1 && (single = (Transition)this.data.first()).getBefore() == single.getAfter()) {
            this.data.clear();
            this.data.add(new Transition(earliestValidityDate, single.getBefore(), entry));
            return;
        }
        Transition next = this.data.ceiling(new Transition(earliestValidityDate, entry, null));
        if (next == null) {
            this.data.add(new Transition(earliestValidityDate, ((Transition)this.data.last()).getAfter(), entry));
        } else {
            this.data.remove(next);
            this.data.add(new Transition(earliestValidityDate, next.getBefore(), entry));
            this.data.add(new Transition(next.date, entry, next.getAfter()));
        }
    }

    public T get(FieldAbsoluteDate<D> date) {
        Transition previous = this.data.floor(new Transition(date, null, null));
        if (previous == null) {
            return (T)((Transition)this.data.first()).getBefore();
        }
        return (T)previous.getAfter();
    }

    public SortedSet<Transition<T, D>> getTransitions() {
        return Collections.unmodifiableSortedSet(this.data);
    }

    public static class Transition<S, D extends CalculusFieldElement<D>>
    implements TimeStamped {
        private final FieldAbsoluteDate<D> date;
        private final S before;
        private final S after;

        private Transition(FieldAbsoluteDate<D> date, S before, S after) {
            this.date = date;
            this.before = before;
            this.after = after;
        }

        public FieldAbsoluteDate<D> getAbsoluteDate() {
            return this.date;
        }

        @Override
        public AbsoluteDate getDate() {
            return this.date.toAbsoluteDate();
        }

        public S getBefore() {
            return this.before;
        }

        public S getAfter() {
            return this.after;
        }
    }
}

