/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.utils;

import java.util.Locale;
import org.hipparchus.util.RyuDouble;

public class AccurateFormatter {
    public static final Locale STANDARDIZED_LOCALE = Locale.US;
    private static final String DATE_FORMAT = "%04d-%02d-%02dT%02d:%02d:%s";
    private static final int LOW_EXP = -18;
    private static final double LOW_TRUNCATION = 1.0E-15;

    private AccurateFormatter() {
    }

    public static String format(double value) {
        return RyuDouble.doubleToString((double)value);
    }

    public static String format(int year, int month, int day, int hour, int minute, double seconds) {
        double truncated = seconds < 1.0E-15 ? 0.0 : seconds;
        String s = RyuDouble.doubleToString((double)truncated, (int)-18, (int)7);
        return String.format(STANDARDIZED_LOCALE, DATE_FORMAT, year, month, day, hour, minute, s.charAt(1) == '.' ? "0" + s : s);
    }
}

