/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.time;

import org.hipparchus.CalculusFieldElement;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.DateComponents;
import org.orekit.time.DateTimeComponents;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.TimeComponents;
import org.orekit.time.TimeScale;

public class SatelliteClockScale
implements TimeScale {
    private static final long serialVersionUID = 20210309L;
    private final String name;
    private final AbsoluteDate epoch;
    private final DateTimeComponents epochDT;
    private final double offsetAtEpoch;
    private final double countAtEpoch;
    private final double drift;
    private final double rate;

    public SatelliteClockScale(String name, AbsoluteDate epoch, TimeScale epochScale, double countAtEpoch, double drift) {
        this.name = name;
        this.epoch = epoch;
        this.epochDT = epoch.getComponents(epochScale);
        this.offsetAtEpoch = epochScale.offsetFromTAI(epoch) + countAtEpoch;
        this.countAtEpoch = countAtEpoch;
        this.drift = drift;
        this.rate = 1.0 + drift;
    }

    @Override
    public double offsetFromTAI(AbsoluteDate date) {
        return this.offsetAtEpoch + this.drift * date.durationFrom(this.epoch);
    }

    @Override
    public double offsetToTAI(DateComponents date, TimeComponents time) {
        double delta = 86400.0 * (double)(date.getJ2000Day() - this.epochDT.getDate().getJ2000Day()) + time.getSecondsInUTCDay() - this.epochDT.getTime().getSecondsInUTCDay();
        double timeSinceEpoch = (delta - this.countAtEpoch) / this.rate;
        return -(this.offsetAtEpoch + this.drift * timeSinceEpoch);
    }

    public AbsoluteDate dateAtCount(double count) {
        return this.epoch.shiftedBy((count - this.countAtEpoch) / this.rate);
    }

    public double countAtDate(AbsoluteDate date) {
        return this.countAtEpoch + this.rate * date.durationFrom(this.epoch);
    }

    @Override
    public <T extends CalculusFieldElement<T>> T offsetFromTAI(FieldAbsoluteDate<T> date) {
        return (T)((CalculusFieldElement)((CalculusFieldElement)date.durationFrom(this.epoch).multiply(this.drift)).add(this.offsetAtEpoch));
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getName();
    }
}

