/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.semianalytical.dsst.utilities;

import java.util.ArrayList;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.analysis.interpolation.FieldHermiteInterpolator;
import org.hipparchus.util.FastMath;
import org.orekit.time.FieldAbsoluteDate;

public class FieldShortPeriodicsInterpolatedCoefficient<T extends CalculusFieldElement<T>> {
    private ArrayList<T[]> values;
    private ArrayList<FieldAbsoluteDate<T>> abscissae;
    private int interpolationPoints;
    private int latestClosestNeighbor;

    public FieldShortPeriodicsInterpolatedCoefficient(int interpolationPoints) {
        this.interpolationPoints = interpolationPoints;
        this.abscissae = new ArrayList();
        this.values = new ArrayList();
        this.latestClosestNeighbor = 0;
    }

    public T[] value(FieldAbsoluteDate<T> date) {
        Field<T> field = date.getField();
        CalculusFieldElement zero = (CalculusFieldElement)field.getZero();
        int[] neighbors = this.getNeighborsIndices(date);
        FieldHermiteInterpolator interpolator = new FieldHermiteInterpolator();
        for (int i : neighbors) {
            interpolator.addSamplePoint(this.abscissae.get(i).durationFrom(date), (FieldElement[][])new CalculusFieldElement[][]{(CalculusFieldElement[])this.values.get(i)});
        }
        return (CalculusFieldElement[])interpolator.value((FieldElement)zero);
    }

    private int[] getNeighborsIndices(FieldAbsoluteDate<T> date) {
        int sizeofNeighborhood = FastMath.min((int)this.interpolationPoints, (int)this.abscissae.size());
        int[] neighborsIndices = new int[sizeofNeighborhood];
        if (this.interpolationPoints >= this.abscissae.size()) {
            for (int i = 0; i < sizeofNeighborhood; ++i) {
                neighborsIndices[i] = i;
            }
        } else {
            int inf = this.getClosestNeighbor(date);
            int sup = inf + 1;
            while (sup - inf < this.interpolationPoints) {
                if (inf == 0) {
                    ++sup;
                    continue;
                }
                if (sup >= this.abscissae.size()) {
                    --inf;
                    continue;
                }
                CalculusFieldElement lowerNeighborDistance = FastMath.abs(this.abscissae.get(inf - 1).durationFrom(date));
                CalculusFieldElement upperNeighborDistance = FastMath.abs(this.abscissae.get(sup).durationFrom(date));
                if (lowerNeighborDistance.getReal() <= upperNeighborDistance.getReal()) {
                    --inf;
                    continue;
                }
                ++sup;
            }
            for (int i = 0; i < this.interpolationPoints; ++i) {
                neighborsIndices[i] = inf + i;
            }
        }
        return neighborsIndices;
    }

    private int getClosestNeighbor(FieldAbsoluteDate<T> date) {
        int closestNeighbor = this.latestClosestNeighbor;
        if (date.compareTo(this.abscissae.get(0)) <= 0) {
            closestNeighbor = 0;
        } else if (date.compareTo(this.abscissae.get(this.abscissae.size() - 1)) >= 0) {
            closestNeighbor = this.abscissae.size() - 1;
        } else {
            int lowerBorder = this.latestClosestNeighbor;
            int upperBorder = this.latestClosestNeighbor;
            int searchDirection = date.compareTo(this.abscissae.get(this.latestClosestNeighbor));
            if (searchDirection > 0) {
                ++upperBorder;
                while (date.compareTo(this.abscissae.get(upperBorder)) > 0) {
                    ++upperBorder;
                    ++lowerBorder;
                }
            } else {
                --lowerBorder;
                while (date.compareTo(this.abscissae.get(lowerBorder)) < 0) {
                    --upperBorder;
                    --lowerBorder;
                }
            }
            CalculusFieldElement lowerDistance = FastMath.abs(date.durationFrom(this.abscissae.get(lowerBorder)));
            CalculusFieldElement upperDistance = FastMath.abs(date.durationFrom(this.abscissae.get(upperBorder)));
            closestNeighbor = lowerDistance.getReal() < upperDistance.getReal() ? lowerBorder : upperBorder;
        }
        this.latestClosestNeighbor = closestNeighbor;
        return closestNeighbor;
    }

    public void clearHistory() {
        this.abscissae.clear();
        this.values.clear();
    }

    public void addGridPoint(FieldAbsoluteDate<T> date, T[] value) {
        if (this.abscissae.isEmpty()) {
            this.abscissae.add(date);
            this.values.add(value);
        } else if (this.abscissae.contains(date)) {
            this.values.set(this.abscissae.indexOf(date), value);
        } else {
            int closestNeighbor = this.getClosestNeighbor(date);
            int index = date.compareTo(this.abscissae.get(closestNeighbor)) < 0 ? closestNeighbor : closestNeighbor + 1;
            this.abscissae.add(index, date);
            this.values.add(index, value);
        }
    }
}

