/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.semianalytical.dsst.utilities;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.FieldElement;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathUtils;
import org.orekit.frames.Frame;
import org.orekit.orbits.FieldOrbit;
import org.orekit.time.FieldAbsoluteDate;

public class FieldAuxiliaryElements<T extends CalculusFieldElement<T>> {
    private final FieldAbsoluteDate<T> date;
    private final Frame frame;
    private final T ecc;
    private final T n;
    private final T period;
    private final T sma;
    private final T k;
    private final T h;
    private final T q;
    private final T p;
    private final T lm;
    private final T lv;
    private final T le;
    private final int I;
    private final T B;
    private final T C;
    private final FieldVector3D<T> f;
    private final FieldVector3D<T> g;
    private final FieldVector3D<T> w;
    private final T alpha;
    private final T beta;
    private final T gamma;

    public FieldAuxiliaryElements(FieldOrbit<T> orbit, int retrogradeFactor) {
        CalculusFieldElement pi = (CalculusFieldElement)((CalculusFieldElement)orbit.getDate().getField().getZero()).getPi();
        this.date = orbit.getDate();
        this.frame = orbit.getFrame();
        this.ecc = orbit.getE();
        this.n = orbit.getKeplerianMeanMotion();
        this.period = orbit.getKeplerianPeriod();
        this.sma = orbit.getA();
        this.k = orbit.getEquinoctialEx();
        this.h = orbit.getEquinoctialEy();
        this.q = orbit.getHx();
        this.p = orbit.getHy();
        this.lm = MathUtils.normalizeAngle(orbit.getLM(), (CalculusFieldElement)pi);
        this.lv = MathUtils.normalizeAngle(orbit.getLv(), (CalculusFieldElement)pi);
        this.le = MathUtils.normalizeAngle(orbit.getLE(), (CalculusFieldElement)pi);
        this.I = retrogradeFactor;
        CalculusFieldElement k2 = (CalculusFieldElement)this.k.multiply(this.k);
        CalculusFieldElement h2 = (CalculusFieldElement)this.h.multiply(this.h);
        CalculusFieldElement q2 = (CalculusFieldElement)this.q.multiply(this.q);
        CalculusFieldElement p2 = (CalculusFieldElement)this.p.multiply(this.p);
        this.B = FastMath.sqrt((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)k2.add((FieldElement)h2)).negate()).add(1.0)));
        this.C = (CalculusFieldElement)((CalculusFieldElement)q2.add((FieldElement)p2)).add(1.0);
        CalculusFieldElement ooC = (CalculusFieldElement)this.C.reciprocal();
        CalculusFieldElement px2 = (CalculusFieldElement)this.p.multiply(2.0);
        CalculusFieldElement qx2 = (CalculusFieldElement)this.q.multiply(2.0);
        CalculusFieldElement pq2 = (CalculusFieldElement)px2.multiply(this.q);
        this.f = new FieldVector3D(ooC, new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)p2.negate()).add(1.0)).add((FieldElement)q2), pq2, (CalculusFieldElement)((CalculusFieldElement)px2.multiply(this.I)).negate()));
        this.g = new FieldVector3D(ooC, new FieldVector3D((CalculusFieldElement)pq2.multiply(this.I), (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)p2.add(1.0)).subtract((FieldElement)q2)).multiply(this.I), qx2));
        this.w = new FieldVector3D(ooC, new FieldVector3D(px2, (CalculusFieldElement)qx2.negate(), (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)p2.add((FieldElement)q2)).negate()).add(1.0)).multiply(this.I)));
        this.alpha = this.f.getZ();
        this.beta = this.g.getZ();
        this.gamma = this.w.getZ();
    }

    public FieldAbsoluteDate<T> getDate() {
        return this.date;
    }

    public Frame getFrame() {
        return this.frame;
    }

    public T getEcc() {
        return this.ecc;
    }

    public T getMeanMotion() {
        return this.n;
    }

    public T getKeplerianPeriod() {
        return this.period;
    }

    public T getSma() {
        return this.sma;
    }

    public T getK() {
        return this.k;
    }

    public T getH() {
        return this.h;
    }

    public T getQ() {
        return this.q;
    }

    public T getP() {
        return this.p;
    }

    public T getLM() {
        return this.lm;
    }

    public T getLv() {
        return this.lv;
    }

    public T getLe() {
        return this.le;
    }

    public int getRetrogradeFactor() {
        return this.I;
    }

    public T getB() {
        return this.B;
    }

    public T getC() {
        return this.C;
    }

    public FieldVector3D<T> getVectorF() {
        return this.f;
    }

    public FieldVector3D<T> getVectorG() {
        return this.g;
    }

    public FieldVector3D<T> getVectorW() {
        return this.w;
    }

    public T getAlpha() {
        return this.alpha;
    }

    public T getBeta() {
        return this.beta;
    }

    public T getGamma() {
        return this.gamma;
    }
}

