/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.semianalytical.dsst.forces;

import java.util.List;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;
import org.hipparchus.util.MathUtils;
import org.orekit.forces.drag.DragForce;
import org.orekit.forces.drag.DragSensitive;
import org.orekit.forces.drag.IsotropicDrag;
import org.orekit.models.earth.atmosphere.Atmosphere;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.events.FieldEventDetector;
import org.orekit.propagation.semianalytical.dsst.forces.AbstractGaussianContribution;
import org.orekit.propagation.semianalytical.dsst.utilities.AuxiliaryElements;
import org.orekit.propagation.semianalytical.dsst.utilities.FieldAuxiliaryElements;
import org.orekit.utils.ParameterDriver;

public class DSSTAtmosphericDrag
extends AbstractGaussianContribution {
    private static final double GAUSS_THRESHOLD = 6.0E-10;
    private static final double ATMOSPHERE_ALTITUDE_MAX = 1000000.0;
    private final DragForce drag;
    private final double rbar;

    public DSSTAtmosphericDrag(DragForce force, double mu) {
        super("DSST-drag-", 6.0E-10, force, mu);
        this.drag = force;
        this.rbar = 7378137.0;
    }

    public DSSTAtmosphericDrag(Atmosphere atmosphere, double cd, double area, double mu) {
        this(atmosphere, new IsotropicDrag(area, cd), mu);
    }

    public DSSTAtmosphericDrag(Atmosphere atmosphere, DragSensitive spacecraft, double mu) {
        this(new DragForce(atmosphere, spacecraft), mu);
    }

    public Atmosphere getAtmosphere() {
        return this.drag.getAtmosphere();
    }

    public double getRbar() {
        return this.rbar;
    }

    @Override
    public EventDetector[] getEventsDetectors() {
        return null;
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldEventDetector<T>[] getFieldEventsDetectors(Field<T> field) {
        return null;
    }

    @Override
    protected double[] getLLimits(SpacecraftState state, AuxiliaryElements auxiliaryElements) {
        double perigee = auxiliaryElements.getSma() * (1.0 - auxiliaryElements.getEcc());
        if (perigee > this.rbar) {
            return new double[2];
        }
        double apogee = auxiliaryElements.getSma() * (1.0 + auxiliaryElements.getEcc());
        if (apogee < this.rbar) {
            return new double[]{-Math.PI + MathUtils.normalizeAngle((double)state.getLv(), (double)0.0), Math.PI + MathUtils.normalizeAngle((double)state.getLv(), (double)0.0)};
        }
        double fb = FastMath.acos((double)((auxiliaryElements.getSma() * (1.0 - auxiliaryElements.getEcc() * auxiliaryElements.getEcc()) / this.rbar - 1.0) / auxiliaryElements.getEcc()));
        double wW = FastMath.atan2((double)auxiliaryElements.getH(), (double)auxiliaryElements.getK());
        return new double[]{wW - fb, wW + fb};
    }

    @Override
    protected <T extends CalculusFieldElement<T>> T[] getLLimits(FieldSpacecraftState<T> state, FieldAuxiliaryElements<T> auxiliaryElements) {
        Field<T> field = state.getDate().getField();
        CalculusFieldElement[] tab = (CalculusFieldElement[])MathArrays.buildArray(field, (int)2);
        CalculusFieldElement perigee = (CalculusFieldElement)auxiliaryElements.getSma().multiply(((CalculusFieldElement)auxiliaryElements.getEcc().negate()).add(1.0));
        if (perigee.getReal() > this.rbar) {
            return tab;
        }
        CalculusFieldElement apogee = (CalculusFieldElement)auxiliaryElements.getSma().multiply(auxiliaryElements.getEcc().add(1.0));
        if (apogee.getReal() < this.rbar) {
            CalculusFieldElement zero = (CalculusFieldElement)field.getZero();
            CalculusFieldElement pi = (CalculusFieldElement)zero.getPi();
            tab[0] = (CalculusFieldElement)MathUtils.normalizeAngle(state.getLv(), (CalculusFieldElement)zero).subtract((FieldElement)pi);
            tab[1] = (CalculusFieldElement)MathUtils.normalizeAngle(state.getLv(), (CalculusFieldElement)zero).add((FieldElement)pi);
            return tab;
        }
        CalculusFieldElement fb = FastMath.acos((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)auxiliaryElements.getSma().multiply(((CalculusFieldElement)((CalculusFieldElement)auxiliaryElements.getEcc().multiply(auxiliaryElements.getEcc())).negate()).add(1.0))).divide(this.rbar)).subtract(1.0)).divide(auxiliaryElements.getEcc())));
        CalculusFieldElement wW = FastMath.atan2(auxiliaryElements.getH(), auxiliaryElements.getK());
        tab[0] = (CalculusFieldElement)wW.subtract((FieldElement)fb);
        tab[1] = (CalculusFieldElement)wW.add((FieldElement)fb);
        return tab;
    }

    @Override
    protected List<ParameterDriver> getParametersDriversWithoutMu() {
        return this.drag.getParametersDrivers();
    }

    public DragSensitive getSpacecraft() {
        return this.drag.getSpacecraft();
    }

    public DragForce getDrag() {
        return this.drag;
    }
}

