/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.integration;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.analysis.differentiation.Gradient;
import org.hipparchus.geometry.euclidean.threed.FieldRotation;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;

public abstract class AbstractGradientConverter {
    private final int freeStateParameters;

    protected AbstractGradientConverter(int freeStateParameters) {
        this.freeStateParameters = freeStateParameters;
    }

    public int getFreeStateParameters() {
        return this.freeStateParameters;
    }

    protected Gradient extend(Gradient original, int freeParameters) {
        double[] originalDerivatives = original.getGradient();
        double[] extendedDerivatives = new double[freeParameters];
        System.arraycopy(originalDerivatives, 0, extendedDerivatives, 0, originalDerivatives.length);
        return new Gradient(original.getValue(), extendedDerivatives);
    }

    protected FieldVector3D<Gradient> extend(FieldVector3D<Gradient> original, int freeParameters) {
        return new FieldVector3D((CalculusFieldElement)this.extend((Gradient)original.getX(), freeParameters), (CalculusFieldElement)this.extend((Gradient)original.getY(), freeParameters), (CalculusFieldElement)this.extend((Gradient)original.getZ(), freeParameters));
    }

    protected FieldRotation<Gradient> extend(FieldRotation<Gradient> original, int freeParameters) {
        return new FieldRotation((CalculusFieldElement)this.extend((Gradient)original.getQ0(), freeParameters), (CalculusFieldElement)this.extend((Gradient)original.getQ1(), freeParameters), (CalculusFieldElement)this.extend((Gradient)original.getQ2(), freeParameters), (CalculusFieldElement)this.extend((Gradient)original.getQ3(), freeParameters), false);
    }
}

