/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events;

import java.util.function.Function;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.events.FieldAbstractDetector;
import org.orekit.propagation.events.handlers.FieldContinueOnEvent;
import org.orekit.propagation.events.handlers.FieldEventHandler;

public class FieldFunctionalDetector<T extends CalculusFieldElement<T>>
extends FieldAbstractDetector<FieldFunctionalDetector<T>, T> {
    private final Function<FieldSpacecraftState<T>, T> function;

    public FieldFunctionalDetector(Field<T> field) {
        this((CalculusFieldElement)((CalculusFieldElement)field.getZero()).add(600.0), (CalculusFieldElement)((CalculusFieldElement)field.getZero()).add(1.0E-6), 100, new FieldContinueOnEvent(), value -> (CalculusFieldElement)field.getOne());
    }

    private FieldFunctionalDetector(T maxCheck, T threshold, int maxIter, FieldEventHandler<? super FieldFunctionalDetector<T>, T> handler, Function<FieldSpacecraftState<T>, T> function) {
        super(maxCheck, threshold, maxIter, handler);
        this.function = function;
    }

    @Override
    public T g(FieldSpacecraftState<T> s) {
        return (T)((CalculusFieldElement)this.function.apply(s));
    }

    @Override
    protected FieldFunctionalDetector<T> create(T newMaxCheck, T newThreshold, int newMaxIter, FieldEventHandler<? super FieldFunctionalDetector<T>, T> newHandler) {
        return new FieldFunctionalDetector<T>(newMaxCheck, newThreshold, newMaxIter, newHandler, this.function);
    }

    public FieldFunctionalDetector<T> withFunction(Function<FieldSpacecraftState<T>, T> newGFunction) {
        return new FieldFunctionalDetector(this.getMaxCheckInterval(), this.getThreshold(), this.getMaxIterationCount(), this.getHandler(), newGFunction);
    }

    public Function<FieldSpacecraftState<T>, T> getFunction() {
        return this.function;
    }
}

