/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.analysis.UnivariateFunction;
import org.hipparchus.analysis.solvers.BracketedUnivariateSolver;
import org.hipparchus.analysis.solvers.BracketingNthOrderBrentSolver;
import org.hipparchus.exception.MathRuntimeException;
import org.hipparchus.ode.events.Action;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.Precision;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitInternalError;
import org.orekit.errors.OrekitMessages;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.events.FieldEventDetector;
import org.orekit.propagation.sampling.FieldOrekitStepInterpolator;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.TimeShiftable;

public class FieldEventState<D extends FieldEventDetector<T>, T extends CalculusFieldElement<T>> {
    private D detector;
    private FieldAbsoluteDate<T> lastT;
    private T lastG;
    private FieldAbsoluteDate<T> t0;
    private T g0;
    private boolean g0Positive;
    private boolean pendingEvent;
    private FieldAbsoluteDate<T> pendingEventTime;
    private FieldAbsoluteDate<T> stopTime;
    private FieldAbsoluteDate<T> afterEvent;
    private T afterG;
    private FieldAbsoluteDate<T> earliestTimeConsidered;
    private boolean forward;
    private boolean increasing;

    public FieldEventState(D detector) {
        this.detector = detector;
        Field field = detector.getMaxCheckInterval().getField();
        CalculusFieldElement nan = (CalculusFieldElement)((CalculusFieldElement)field.getZero()).add(Double.NaN);
        this.lastT = FieldAbsoluteDate.getPastInfinity(field);
        this.lastG = nan;
        this.t0 = null;
        this.g0 = nan;
        this.g0Positive = true;
        this.pendingEvent = false;
        this.pendingEventTime = null;
        this.stopTime = null;
        this.increasing = true;
        this.earliestTimeConsidered = null;
        this.afterEvent = null;
        this.afterG = nan;
    }

    public D getEventDetector() {
        return this.detector;
    }

    public void init(FieldSpacecraftState<T> s0, FieldAbsoluteDate<T> t) {
        this.detector.init(s0, t);
        Field field = this.detector.getMaxCheckInterval().getField();
        this.lastT = FieldAbsoluteDate.getPastInfinity(field);
        this.lastG = (CalculusFieldElement)((CalculusFieldElement)field.getZero()).add(Double.NaN);
    }

    private T g(FieldSpacecraftState<T> s) {
        if (!s.getDate().equals(this.lastT)) {
            this.lastT = s.getDate();
            this.lastG = this.detector.g(s);
        }
        return this.lastG;
    }

    public void reinitializeBegin(FieldOrekitStepInterpolator<T> interpolator) {
        this.forward = interpolator.isForward();
        FieldSpacecraftState<T> s0 = interpolator.getPreviousState();
        this.t0 = s0.getDate();
        this.g0 = this.g(s0);
        while (this.g0.getReal() == 0.0) {
            CalculusFieldElement dt = (CalculusFieldElement)this.detector.getThreshold().multiply(this.forward ? 0.5 : -0.5);
            FieldAbsoluteDate<CalculusFieldElement> startDate = this.t0.shiftedBy(dt);
            if (this.t0.equals(startDate)) {
                startDate = this.nextAfter(startDate);
            }
            this.t0 = startDate;
            this.g0 = this.g(interpolator.getInterpolatedState(this.t0));
        }
        this.increasing = this.g0Positive = this.g0.getReal() > 0.0;
    }

    public boolean evaluateStep(FieldOrekitStepInterpolator<T> interpolator) throws MathRuntimeException {
        this.forward = interpolator.isForward();
        FieldSpacecraftState<T> s1 = interpolator.getCurrentState();
        FieldAbsoluteDate<T> t1 = s1.getDate();
        T dt = t1.durationFrom(this.t0);
        if (FastMath.abs((double)dt.getReal()) < this.detector.getThreshold().getReal()) {
            return false;
        }
        int n = FastMath.max((int)1, (int)((int)FastMath.ceil((double)(FastMath.abs((double)dt.getReal()) / this.detector.getMaxCheckInterval().getReal()))));
        CalculusFieldElement h = (CalculusFieldElement)dt.divide((double)n);
        FieldAbsoluteDate<T> ta = this.t0;
        T ga = this.g0;
        for (int i = 0; i < n; ++i) {
            FieldAbsoluteDate<Object> tb = i == n - 1 ? t1 : this.t0.shiftedBy((CalculusFieldElement)h.multiply(i + 1));
            T gb = this.g(interpolator.getInterpolatedState(tb));
            if (gb.getReal() == 0.0 || this.g0Positive ^ gb.getReal() > 0.0) {
                if (!this.findRoot(interpolator, ta, ga, tb, gb)) continue;
                return true;
            }
            ta = tb;
            ga = gb;
        }
        this.pendingEvent = false;
        this.pendingEventTime = null;
        return false;
    }

    private boolean findRoot(FieldOrekitStepInterpolator<T> interpolator, FieldAbsoluteDate<T> ta, T ga, FieldAbsoluteDate<T> tb, T gb) {
        CalculusFieldElement zero = (CalculusFieldElement)ga.getField().getZero();
        this.check(ga.getReal() == 0.0 || gb.getReal() == 0.0 || ga.getReal() > 0.0 && gb.getReal() < 0.0 || ga.getReal() < 0.0 && gb.getReal() > 0.0);
        Object convergence = this.detector.getThreshold();
        int maxIterationCount = this.detector.getMaxIterationCount();
        BracketingNthOrderBrentSolver solver = new BracketingNthOrderBrentSolver(0.0, convergence.getReal(), 0.0, 5);
        TimeShiftable<FieldAbsoluteDate<T>> beforeRootT = null;
        Object beforeRootG = (CalculusFieldElement)zero.add(Double.NaN);
        TimeShiftable<FieldAbsoluteDate<T>> afterRootT = ta;
        Object afterRootG = zero;
        if (ta.equals(tb)) {
            beforeRootT = ta;
            beforeRootG = ga;
            afterRootT = this.shiftedBy((FieldAbsoluteDate<T>)beforeRootT, convergence);
            afterRootG = this.g(interpolator.getInterpolatedState((FieldAbsoluteDate<T>)afterRootT));
        } else if (ga.getReal() != 0.0 && gb.getReal() == 0.0) {
            beforeRootT = tb;
            beforeRootG = gb;
            afterRootT = this.shiftedBy((FieldAbsoluteDate<T>)beforeRootT, convergence);
            afterRootG = this.g(interpolator.getInterpolatedState((FieldAbsoluteDate<T>)afterRootT));
        } else if (ga.getReal() != 0.0) {
            T newGa = this.g(interpolator.getInterpolatedState(ta));
            if (ga.getReal() > 0.0 != newGa.getReal() > 0.0) {
                beforeRootT = ta;
                beforeRootG = newGa;
                afterRootT = this.minTime(this.shiftedBy((FieldAbsoluteDate<T>)beforeRootT, convergence), tb);
                afterRootG = this.g(interpolator.getInterpolatedState((FieldAbsoluteDate<T>)afterRootT));
            }
        }
        FieldAbsoluteDate<T> loopT = ta;
        Object loopG = ga;
        while ((afterRootG.getReal() == 0.0 || afterRootG.getReal() > 0.0 == this.g0Positive) && this.strictlyAfter((FieldAbsoluteDate<T>)afterRootT, tb)) {
            if (loopG.getReal() == 0.0) {
                beforeRootT = loopT;
                beforeRootG = loopG;
                afterRootT = this.minTime(this.shiftedBy((FieldAbsoluteDate<T>)beforeRootT, convergence), tb);
                afterRootG = this.g(interpolator.getInterpolatedState((FieldAbsoluteDate<T>)afterRootT));
            } else {
                BracketedUnivariateSolver.Interval interval;
                FieldAbsoluteDate<T> fT0 = loopT;
                UnivariateFunction f = dt -> this.g(interpolator.getInterpolatedState((FieldAbsoluteDate<T>)fT0.shiftedBy(dt))).getReal();
                T tbDouble = tb.durationFrom(fT0);
                if (this.forward) {
                    try {
                        interval = solver.solveInterval(maxIterationCount, f, 0.0, tbDouble.getReal());
                        beforeRootT = fT0.shiftedBy(interval.getLeftAbscissa());
                        beforeRootG = (CalculusFieldElement)zero.add(interval.getLeftValue());
                        afterRootT = fT0.shiftedBy(interval.getRightAbscissa());
                        afterRootG = (CalculusFieldElement)zero.add(interval.getRightValue());
                    }
                    catch (RuntimeException e) {
                        throw new OrekitException(e, OrekitMessages.FIND_ROOT, this.detector, loopT, loopG, tb, gb, this.lastT, this.lastG);
                    }
                }
                try {
                    interval = solver.solveInterval(maxIterationCount, f, tbDouble.getReal(), 0.0);
                    beforeRootT = fT0.shiftedBy(interval.getRightAbscissa());
                    beforeRootG = (CalculusFieldElement)zero.add(interval.getRightValue());
                    afterRootT = fT0.shiftedBy(interval.getLeftAbscissa());
                    afterRootG = (CalculusFieldElement)zero.add(interval.getLeftValue());
                }
                catch (RuntimeException e) {
                    throw new OrekitException(e, OrekitMessages.FIND_ROOT, this.detector, tb, gb, loopT, loopG, this.lastT, this.lastG);
                }
            }
            if (((FieldAbsoluteDate)beforeRootT).equals(afterRootT)) {
                afterRootT = this.nextAfter((FieldAbsoluteDate<T>)afterRootT);
                afterRootG = this.g(interpolator.getInterpolatedState((FieldAbsoluteDate<T>)afterRootT));
            }
            this.check(this.forward && afterRootT.compareTo((FieldAbsoluteDate<T>)beforeRootT) > 0 || !this.forward && afterRootT.compareTo((FieldAbsoluteDate<T>)beforeRootT) < 0);
            loopT = afterRootT;
            loopG = afterRootG;
        }
        if (afterRootG.getReal() == 0.0 || afterRootG.getReal() > 0.0 == this.g0Positive) {
            return false;
        }
        this.check(beforeRootT != null && !Double.isNaN(beforeRootG.getReal()));
        this.increasing = !this.g0Positive;
        this.pendingEventTime = beforeRootT;
        this.stopTime = beforeRootG.getReal() == 0.0 ? beforeRootT : afterRootT;
        this.pendingEvent = true;
        this.afterEvent = afterRootT;
        this.afterG = afterRootG;
        this.check(this.afterG.getReal() > 0.0 == this.increasing);
        this.check(this.increasing == gb.getReal() >= ga.getReal());
        return true;
    }

    private FieldAbsoluteDate<T> nextAfter(FieldAbsoluteDate<T> t) {
        return t.shiftedBy(this.forward ? Precision.EPSILON : -Precision.EPSILON);
    }

    public FieldAbsoluteDate<T> getEventDate() {
        return this.pendingEventTime;
    }

    public boolean tryAdvance(FieldSpacecraftState<T> state, FieldOrekitStepInterpolator<T> interpolator) {
        boolean meFirst;
        FieldAbsoluteDate<T> t = state.getDate();
        this.check(!this.pendingEvent || !this.strictlyAfter(this.pendingEventTime, t));
        if (this.strictlyAfter(t, this.earliestTimeConsidered)) {
            meFirst = false;
        } else {
            boolean positive;
            T g = this.g(state);
            boolean bl = positive = g.getReal() > 0.0;
            if (positive == this.g0Positive) {
                this.g0 = g;
                meFirst = false;
            } else {
                FieldAbsoluteDate<T> oldPendingEventTime = this.pendingEventTime;
                boolean foundRoot = this.findRoot(interpolator, this.t0, this.g0, t, g);
                boolean bl2 = meFirst = foundRoot && !this.pendingEventTime.equals(oldPendingEventTime);
            }
        }
        if (!meFirst) {
            this.t0 = t;
        }
        return meFirst;
    }

    public EventOccurrence<T> doEvent(FieldSpacecraftState<T> state) {
        this.check(this.pendingEvent);
        this.check(state.getDate().equals(this.pendingEventTime));
        Action action = this.detector.eventOccurred(state, this.increasing == this.forward);
        FieldSpacecraftState<T> newState = action == Action.RESET_STATE ? this.detector.resetState(state) : state;
        this.pendingEvent = false;
        this.pendingEventTime = null;
        this.earliestTimeConsidered = this.afterEvent;
        this.t0 = this.afterEvent;
        this.g0 = this.afterG;
        this.g0Positive = this.increasing;
        this.check(this.g0.getReal() == 0.0 || this.g0Positive == this.g0.getReal() > 0.0);
        return new EventOccurrence<T>(action, newState, this.stopTime);
    }

    private FieldAbsoluteDate<T> shiftedBy(FieldAbsoluteDate<T> t, T delta) {
        if (this.forward) {
            FieldAbsoluteDate<T> ret = t.shiftedBy((CalculusFieldElement)delta);
            if (ret.durationFrom(t).getReal() > delta.getReal()) {
                return ret.shiftedBy(-Precision.EPSILON);
            }
            return ret;
        }
        FieldAbsoluteDate<CalculusFieldElement> ret = t.shiftedBy((CalculusFieldElement)delta.negate());
        if (t.durationFrom(ret).getReal() > delta.getReal()) {
            return ret.shiftedBy(Precision.EPSILON);
        }
        return ret;
    }

    private FieldAbsoluteDate<T> minTime(FieldAbsoluteDate<T> a, FieldAbsoluteDate<T> b) {
        return this.forward ^ a.compareTo(b) > 0 ? a : b;
    }

    private boolean strictlyAfter(FieldAbsoluteDate<T> t1, FieldAbsoluteDate<T> t2) {
        if (t1 == null || t2 == null) {
            return false;
        }
        return this.forward ? t1.compareTo(t2) < 0 : t2.compareTo(t1) < 0;
    }

    private void check(boolean condition) throws MathRuntimeException {
        if (!condition) {
            throw new OrekitInternalError(null);
        }
    }

    public boolean getPendingEvent() {
        return this.pendingEvent;
    }

    public static class EventOccurrence<T extends CalculusFieldElement<T>> {
        private final Action action;
        private final FieldSpacecraftState<T> newState;
        private final FieldAbsoluteDate<T> stopDate;

        EventOccurrence(Action action, FieldSpacecraftState<T> newState, FieldAbsoluteDate<T> stopDate) {
            this.action = action;
            this.newState = newState;
            this.stopDate = stopDate;
        }

        public Action getAction() {
            return this.action;
        }

        public FieldSpacecraftState<T> getNewState() {
            return this.newState;
        }

        public FieldAbsoluteDate<T> getStopDate() {
            return this.stopDate;
        }
    }
}

