/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events;

import org.hipparchus.CalculusFieldElement;
import org.orekit.bodies.BodyShape;
import org.orekit.bodies.FieldGeodeticPoint;
import org.orekit.frames.Frame;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.events.FieldAbstractDetector;
import org.orekit.propagation.events.handlers.FieldEventHandler;
import org.orekit.propagation.events.handlers.FieldStopOnDecreasing;
import org.orekit.utils.TimeStampedFieldPVCoordinates;

public class FieldAltitudeDetector<T extends CalculusFieldElement<T>>
extends FieldAbstractDetector<FieldAltitudeDetector<T>, T> {
    private final T altitude;
    private final BodyShape bodyShape;

    public FieldAltitudeDetector(T altitude, BodyShape bodyShape) {
        this((CalculusFieldElement)((CalculusFieldElement)altitude.getField().getZero()).add(600.0), (CalculusFieldElement)((CalculusFieldElement)altitude.getField().getZero()).add(1.0E-6), (CalculusFieldElement)altitude, bodyShape);
    }

    public FieldAltitudeDetector(T maxCheck, T altitude, BodyShape bodyShape) {
        this((CalculusFieldElement)maxCheck, (CalculusFieldElement)((CalculusFieldElement)altitude.getField().getZero()).add(1.0E-6), (CalculusFieldElement)altitude, bodyShape);
    }

    public FieldAltitudeDetector(T maxCheck, T threshold, T altitude, BodyShape bodyShape) {
        this(maxCheck, threshold, 100, new FieldStopOnDecreasing(), altitude, bodyShape);
    }

    private FieldAltitudeDetector(T maxCheck, T threshold, int maxIter, FieldEventHandler<? super FieldAltitudeDetector<T>, T> handler, T altitude, BodyShape bodyShape) {
        super(maxCheck, threshold, maxIter, handler);
        this.altitude = altitude;
        this.bodyShape = bodyShape;
    }

    @Override
    protected FieldAltitudeDetector<T> create(T newMaxCheck, T newThreshold, int newMaxIter, FieldEventHandler<? super FieldAltitudeDetector<T>, T> newHandler) {
        return new FieldAltitudeDetector<T>(newMaxCheck, newThreshold, newMaxIter, newHandler, this.altitude, this.bodyShape);
    }

    public T getAltitude() {
        return this.altitude;
    }

    public BodyShape getBodyShape() {
        return this.bodyShape;
    }

    @Override
    public T g(FieldSpacecraftState<T> s) {
        Frame bodyFrame = this.bodyShape.getBodyFrame();
        TimeStampedFieldPVCoordinates<T> pvBody = s.getPVCoordinates(bodyFrame);
        FieldGeodeticPoint point = this.bodyShape.transform(pvBody.getPosition(), bodyFrame, s.getDate());
        return (T)((CalculusFieldElement)point.getAltitude().subtract(this.altitude));
    }
}

