/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.analytical.tle;

import org.hipparchus.exception.Localizable;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathUtils;
import org.hipparchus.util.SinCos;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.attitudes.Attitude;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.attitudes.InertialProvider;
import org.orekit.data.DataContext;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.Frame;
import org.orekit.frames.Frames;
import org.orekit.orbits.CartesianOrbit;
import org.orekit.orbits.Orbit;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.analytical.AbstractAnalyticalPropagator;
import org.orekit.propagation.analytical.tle.DeepSDP4;
import org.orekit.propagation.analytical.tle.SGP4;
import org.orekit.propagation.analytical.tle.TLE;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.TimeScale;
import org.orekit.utils.PVCoordinates;

public abstract class TLEPropagator
extends AbstractAnalyticalPropagator {
    protected TLE tle;
    protected final TimeScale utc;
    protected double xnode;
    protected double a;
    protected double e;
    protected double i;
    protected double omega;
    protected double xl;
    protected double a0dp;
    protected double xn0dp;
    protected double cosi0;
    protected double theta2;
    protected double sini0;
    protected double xmdot;
    protected double omgdot;
    protected double xnodot;
    protected double e0sq;
    protected double beta02;
    protected double beta0;
    protected double perige;
    protected double etasq;
    protected double eeta;
    protected double s4;
    protected double tsi;
    protected double eta;
    protected double coef;
    protected double coef1;
    protected double c1;
    protected double c2;
    protected double c4;
    protected double xnodcf;
    protected double t2cof;
    private final Frame teme;
    private final double mass;

    @DefaultDataContext
    protected TLEPropagator(TLE initialTLE, AttitudeProvider attitudeProvider, double mass) {
        this(initialTLE, attitudeProvider, mass, DataContext.getDefault().getFrames().getTEME());
    }

    protected TLEPropagator(TLE initialTLE, AttitudeProvider attitudeProvider, double mass, Frame teme) {
        super(attitudeProvider);
        this.setStartDate(initialTLE.getDate());
        this.tle = initialTLE;
        this.teme = teme;
        this.mass = mass;
        this.utc = initialTLE.getUtc();
        this.initializeCommons();
        this.sxpInitialize();
        Orbit orbit = this.propagateOrbit(initialTLE.getDate());
        Attitude attitude = attitudeProvider.getAttitude(orbit, orbit.getDate(), orbit.getFrame());
        super.resetInitialState(new SpacecraftState(orbit, attitude, mass));
    }

    @DefaultDataContext
    public static TLEPropagator selectExtrapolator(TLE tle) {
        return TLEPropagator.selectExtrapolator(tle, DataContext.getDefault().getFrames());
    }

    public static TLEPropagator selectExtrapolator(TLE tle, Frames frames) {
        return TLEPropagator.selectExtrapolator(tle, InertialProvider.of(frames.getTEME()), 1000.0, frames.getTEME());
    }

    @DefaultDataContext
    public static TLEPropagator selectExtrapolator(TLE tle, AttitudeProvider attitudeProvider, double mass) {
        return TLEPropagator.selectExtrapolator(tle, attitudeProvider, mass, DataContext.getDefault().getFrames().getTEME());
    }

    public static TLEPropagator selectExtrapolator(TLE tle, AttitudeProvider attitudeProvider, double mass, Frame teme) {
        double a1 = FastMath.pow((double)(0.07436691613317341 / (tle.getMeanMotion() * 60.0)), (double)0.6666666666666666);
        double cosi0 = FastMath.cos((double)tle.getI());
        double temp = 8.119620000000001E-4 * (3.0 * cosi0 * cosi0 - 1.0) * FastMath.pow((double)(1.0 - tle.getE() * tle.getE()), (double)-1.5);
        double delta1 = temp / (a1 * a1);
        double a0 = a1 * (1.0 - delta1 * (0.3333333333333333 + delta1 * (delta1 * 134.0 / 81.0 + 1.0)));
        double delta0 = temp / (a0 * a0);
        double xn0dp = tle.getMeanMotion() * 60.0 / (delta0 + 1.0);
        if (Math.PI * 2 / (xn0dp * 1440.0) >= 0.15625) {
            return new DeepSDP4(tle, attitudeProvider, mass, teme);
        }
        return new SGP4(tle, attitudeProvider, mass, teme);
    }

    public static double getMU() {
        return 3.9860079999999994E14;
    }

    public PVCoordinates getPVCoordinates(AbsoluteDate date) {
        this.sxpPropagate(date.durationFrom(this.tle.getDate()) / 60.0);
        return this.computePVCoordinates();
    }

    private void initializeCommons() {
        SinCos scI0 = FastMath.sinCos((double)this.tle.getI());
        double a1 = FastMath.pow((double)(0.07436691613317341 / (this.tle.getMeanMotion() * 60.0)), (double)0.6666666666666666);
        this.cosi0 = scI0.cos();
        this.theta2 = this.cosi0 * this.cosi0;
        double x3thm1 = 3.0 * this.theta2 - 1.0;
        this.e0sq = this.tle.getE() * this.tle.getE();
        this.beta02 = 1.0 - this.e0sq;
        this.beta0 = FastMath.sqrt((double)this.beta02);
        double tval = 8.119620000000001E-4 * x3thm1 / (this.beta0 * this.beta02);
        double delta1 = tval / (a1 * a1);
        double a0 = a1 * (1.0 - delta1 * (0.3333333333333333 + delta1 * (1.0 + 1.654320987654321 * delta1)));
        double delta0 = tval / (a0 * a0);
        this.xn0dp = this.tle.getMeanMotion() * 60.0 / (delta0 + 1.0);
        this.a0dp = a0 / (1.0 - delta0);
        this.s4 = 1.0122292801892716;
        double q0ms24 = 1.8802791590152705E-9;
        this.perige = (this.a0dp * (1.0 - this.tle.getE()) - 1.0) * 6378.135;
        if (this.perige < 156.0) {
            this.s4 = this.perige <= 98.0 ? 20.0 : this.perige - 78.0;
            double temp_val = (120.0 - this.s4) * 1.0 / 6378.135;
            double temp_val_squared = temp_val * temp_val;
            q0ms24 = temp_val_squared * temp_val_squared;
            this.s4 = this.s4 / 6378.135 + 1.0;
        }
        double pinv = 1.0 / (this.a0dp * this.beta02);
        double pinvsq = pinv * pinv;
        this.tsi = 1.0 / (this.a0dp - this.s4);
        this.eta = this.a0dp * this.tle.getE() * this.tsi;
        this.etasq = this.eta * this.eta;
        this.eeta = this.tle.getE() * this.eta;
        double psisq = FastMath.abs((double)(1.0 - this.etasq));
        double tsi_squared = this.tsi * this.tsi;
        this.coef = q0ms24 * tsi_squared * tsi_squared;
        this.coef1 = this.coef / FastMath.pow((double)psisq, (double)3.5);
        this.c2 = this.coef1 * this.xn0dp * (this.a0dp * (1.0 + 1.5 * this.etasq + this.eeta * (4.0 + this.etasq)) + 4.0598100000000003E-4 * this.tsi / psisq * x3thm1 * (8.0 + 3.0 * this.etasq * (8.0 + this.etasq)));
        this.c1 = this.tle.getBStar() * this.c2;
        this.sini0 = scI0.sin();
        double x1mth2 = 1.0 - this.theta2;
        this.c4 = 2.0 * this.xn0dp * this.coef1 * this.a0dp * this.beta02 * (this.eta * (2.0 + 0.5 * this.etasq) + this.tle.getE() * (0.5 + 2.0 * this.etasq) - 0.001082616 * this.tsi / (this.a0dp * psisq) * (-3.0 * x3thm1 * (1.0 - 2.0 * this.eeta + this.etasq * (1.5 - 0.5 * this.eeta)) + 0.75 * x1mth2 * (2.0 * this.etasq - this.eeta * (1.0 + this.etasq)) * FastMath.cos((double)(2.0 * this.tle.getPerigeeArgument()))));
        double theta4 = this.theta2 * this.theta2;
        double temp1 = 0.0016239240000000001 * pinvsq * this.xn0dp;
        double temp2 = temp1 * 5.41308E-4 * pinvsq;
        double temp3 = 7.762359374999998E-7 * pinvsq * pinvsq * this.xn0dp;
        this.xmdot = this.xn0dp + 0.5 * temp1 * this.beta0 * x3thm1 + 0.0625 * temp2 * this.beta0 * (13.0 - 78.0 * this.theta2 + 137.0 * theta4);
        double x1m5th = 1.0 - 5.0 * this.theta2;
        this.omgdot = -0.5 * temp1 * x1m5th + 0.0625 * temp2 * (7.0 - 114.0 * this.theta2 + 395.0 * theta4) + temp3 * (3.0 - 36.0 * this.theta2 + 49.0 * theta4);
        double xhdot1 = -temp1 * this.cosi0;
        this.xnodot = xhdot1 + (0.5 * temp2 * (4.0 - 19.0 * this.theta2) + 2.0 * temp3 * (3.0 - 7.0 * this.theta2)) * this.cosi0;
        this.xnodcf = 3.5 * this.beta02 * xhdot1 * this.c1;
        this.t2cof = 1.5 * this.c1;
    }

    private PVCoordinates computePVCoordinates() {
        double capu;
        SinCos scOmega = FastMath.sinCos((double)this.omega);
        double axn = this.e * scOmega.cos();
        double temp = 1.0 / (this.a * (1.0 - this.e * this.e));
        double xlcof = 5.86267430002882E-4 * this.sini0 * (3.0 + 5.0 * this.cosi0) / (1.0 + this.cosi0);
        double aycof = 0.001172534860005764 * this.sini0;
        double xll = temp * xlcof * axn;
        double aynl = temp * aycof;
        double xlt = this.xl + xll;
        double ayn = this.e * scOmega.sin() + aynl;
        double elsq = axn * axn + ayn * ayn;
        double epw = capu = MathUtils.normalizeAngle((double)(xlt - this.xnode), (double)Math.PI);
        double ecosE = 0.0;
        double esinE = 0.0;
        double sinEPW = 0.0;
        double cosEPW = 0.0;
        double cosi0Sq = this.cosi0 * this.cosi0;
        double x3thm1 = 3.0 * cosi0Sq - 1.0;
        double x1mth2 = 1.0 - cosi0Sq;
        double x7thm1 = 7.0 * cosi0Sq - 1.0;
        if (this.e > 0.999999) {
            throw new OrekitException((Localizable)OrekitMessages.TOO_LARGE_ECCENTRICITY_FOR_PROPAGATION_MODEL, this.e);
        }
        double newtonRaphsonEpsilon = 1.0E-12;
        for (int j = 0; j < 10; ++j) {
            boolean doSecondOrderNewtonRaphson = true;
            SinCos scEPW = FastMath.sinCos((double)epw);
            sinEPW = scEPW.sin();
            cosEPW = scEPW.cos();
            ecosE = axn * cosEPW + ayn * sinEPW;
            esinE = axn * sinEPW - ayn * cosEPW;
            double f = capu - epw + esinE;
            if (FastMath.abs((double)f) < 1.0E-12) break;
            double fdot = 1.0 - ecosE;
            double delta_epw = f / fdot;
            if (j == 0) {
                double maxNewtonRaphson = 1.25 * FastMath.abs((double)this.e);
                doSecondOrderNewtonRaphson = false;
                if (delta_epw > maxNewtonRaphson) {
                    delta_epw = maxNewtonRaphson;
                } else if (delta_epw < -maxNewtonRaphson) {
                    delta_epw = -maxNewtonRaphson;
                } else {
                    doSecondOrderNewtonRaphson = true;
                }
            }
            if (doSecondOrderNewtonRaphson) {
                delta_epw = f / (fdot + 0.5 * esinE * delta_epw);
            }
            epw += delta_epw;
        }
        temp = 1.0 - elsq;
        double pl = this.a * temp;
        double r = this.a * (1.0 - ecosE);
        double temp2 = this.a / r;
        double betal = FastMath.sqrt((double)temp);
        temp = esinE / (1.0 + betal);
        double cosu = temp2 * (cosEPW - axn + ayn * temp);
        double sinu = temp2 * (sinEPW - ayn - axn * temp);
        double u = FastMath.atan2((double)sinu, (double)cosu);
        double sin2u = 2.0 * sinu * cosu;
        double cos2u = 2.0 * cosu * cosu - 1.0;
        double temp1 = 5.41308E-4 / pl;
        temp2 = temp1 / pl;
        double rk = r * (1.0 - 1.5 * temp2 * betal * x3thm1) + 0.5 * temp1 * x1mth2 * cos2u;
        double uk = u - 0.25 * temp2 * x7thm1 * sin2u;
        double xnodek = this.xnode + 1.5 * temp2 * this.cosi0 * sin2u;
        double xinck = this.i + 1.5 * temp2 * this.cosi0 * this.sini0 * cos2u;
        SinCos scuk = FastMath.sinCos((double)uk);
        SinCos scik = FastMath.sinCos((double)xinck);
        SinCos scnok = FastMath.sinCos((double)xnodek);
        double sinuk = scuk.sin();
        double cosuk = scuk.cos();
        double sinik = scik.sin();
        double cosik = scik.cos();
        double sinnok = scnok.sin();
        double cosnok = scnok.cos();
        double xmx = -sinnok * cosik;
        double xmy = cosnok * cosik;
        double ux = xmx * sinuk + cosnok * cosuk;
        double uy = xmy * sinuk + sinnok * cosuk;
        double uz = sinik * sinuk;
        double cr = 1000.0 * rk * 6378.135;
        Vector3D pos = new Vector3D(cr * ux, cr * uy, cr * uz);
        double rdot = 0.07436691613317341 * FastMath.sqrt((double)this.a) * esinE / r;
        double rfdot = 0.07436691613317341 * FastMath.sqrt((double)pl) / r;
        double xn = 0.07436691613317341 / (this.a * FastMath.sqrt((double)this.a));
        double rdotk = rdot - xn * temp1 * x1mth2 * sin2u;
        double rfdotk = rfdot + xn * temp1 * (x1mth2 * cos2u + 1.5 * x3thm1);
        double vx = xmx * cosuk - cosnok * sinuk;
        double vy = xmy * cosuk - sinnok * sinuk;
        double vz = sinik * cosuk;
        double cv = 106302.25;
        Vector3D vel = new Vector3D(106302.25 * (rdotk * ux + rfdotk * vx), 106302.25 * (rdotk * uy + rfdotk * vy), 106302.25 * (rdotk * uz + rfdotk * vz));
        return new PVCoordinates(pos, vel);
    }

    protected abstract void sxpInitialize();

    protected abstract void sxpPropagate(double var1);

    @Override
    public void resetInitialState(SpacecraftState state) {
        TLE newTLE;
        super.resetInitialState(state);
        super.setStartDate(state.getDate());
        this.tle = newTLE = TLE.stateToTLE(state, this.tle, this.utc, this.teme);
        this.initializeCommons();
        this.sxpInitialize();
    }

    @Override
    protected void resetIntermediateState(SpacecraftState state, boolean forward) {
        throw new OrekitException((Localizable)OrekitMessages.NON_RESETABLE_STATE, new Object[0]);
    }

    @Override
    protected double getMass(AbsoluteDate date) {
        return this.mass;
    }

    @Override
    protected Orbit propagateOrbit(AbsoluteDate date) {
        return new CartesianOrbit(this.getPVCoordinates(date), this.teme, date, 3.9860079999999994E14);
    }

    public TLE getTLE() {
        return this.tle;
    }

    @Override
    public Frame getFrame() {
        return this.teme;
    }
}

