/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.analytical.tle;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.FieldElement;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.FieldSinCos;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.frames.Frame;
import org.orekit.propagation.analytical.tle.FieldTLE;
import org.orekit.propagation.analytical.tle.FieldTLEPropagator;
import org.orekit.time.DateTimeComponents;
import org.orekit.time.FieldAbsoluteDate;

abstract class FieldSDP4<T extends CalculusFieldElement<T>>
extends FieldTLEPropagator<T> {
    protected T omgadf;
    protected T xn;
    protected T xll;
    protected T em;
    protected T xinc;

    protected FieldSDP4(FieldTLE<T> initialTLE, AttitudeProvider attitudeProvider, T mass, Frame teme, T[] parameters) {
        super(initialTLE, attitudeProvider, mass, teme, parameters);
    }

    @Override
    protected void sxpInitialize(T[] parameters) {
        this.luniSolarTermsComputation();
    }

    @Override
    protected void sxpPropagate(T tSince, T[] parameters) {
        T bStar = parameters[0];
        this.omgadf = (CalculusFieldElement)this.tle.getPerigeeArgument().add(this.omgdot.multiply(tSince));
        CalculusFieldElement xnoddf = (CalculusFieldElement)this.tle.getRaan().add(this.xnodot.multiply(tSince));
        CalculusFieldElement tSinceSq = (CalculusFieldElement)tSince.multiply(tSince);
        this.xnode = (CalculusFieldElement)xnoddf.add(this.xnodcf.multiply((FieldElement)tSinceSq));
        this.xn = this.xn0dp;
        this.xll = (CalculusFieldElement)this.tle.getMeanAnomaly().add(this.xmdot.multiply(tSince));
        this.deepSecularEffects(tSince);
        CalculusFieldElement tempa = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.c1.multiply(tSince)).negate()).add(1.0);
        this.a = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.xn.reciprocal()).multiply(0.07436691613317341)).pow(0.6666666666666666)).multiply((FieldElement)tempa)).multiply((FieldElement)tempa);
        this.em = (CalculusFieldElement)this.em.subtract(((CalculusFieldElement)bStar.multiply((FieldElement)this.c4)).multiply(tSince));
        this.xll = (CalculusFieldElement)this.xll.add(((CalculusFieldElement)this.xn0dp.multiply((FieldElement)this.t2cof)).multiply((FieldElement)tSinceSq));
        this.deepPeriodicEffects(tSince);
        this.xl = (CalculusFieldElement)((CalculusFieldElement)this.xll.add(this.omgadf)).add((FieldElement)this.xnode);
        FieldSinCos scI0 = FastMath.sinCos(this.xinc);
        this.cosi0 = (CalculusFieldElement)scI0.cos();
        this.sini0 = (CalculusFieldElement)scI0.sin();
        this.e = this.em;
        this.i = this.xinc;
        this.omega = this.omgadf;
    }

    protected double thetaG(FieldAbsoluteDate<T> date) {
        double omega_E = 1.00273790934;
        double jd = date.getComponents(this.utc).offsetFrom(DateTimeComponents.JULIAN_EPOCH) / 86400.0;
        double UT = (jd + 0.5) % 1.0;
        double seconds_per_day = 86400.0;
        double jd_2000 = 2451545.0;
        double t_cen = (jd - UT - 2451545.0) / 36525.0;
        double GMST = 24110.54841 + t_cen * (8640184.812866 + t_cen * (0.093104 - t_cen * 6.2E-6));
        if ((GMST = (GMST + 86636.555366976 * UT) % 86400.0) < 0.0) {
            GMST += 86400.0;
        }
        return Math.PI * 2 * GMST / 86400.0;
    }

    protected abstract void luniSolarTermsComputation();

    protected abstract void deepSecularEffects(T var1);

    protected abstract void deepPeriodicEffects(T var1);
}

