/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.analytical.gnss.data;

import org.orekit.time.AbsoluteDate;

public class CommonGnssData {
    private int prn;
    private int week;
    private double time;
    private double sma;
    private double ecc;
    private double i0;
    private double om0;
    private double dom;
    private double aop;
    private double anom;
    private double af0;
    private double af1;
    private AbsoluteDate date;
    private final double angularVelocity;
    private final double cycleDuration;
    private final double mu;

    public CommonGnssData(double mu, double angularVelocity, int weekNumber) {
        this.mu = mu;
        this.angularVelocity = angularVelocity;
        this.cycleDuration = 604800.0 * (double)weekNumber;
    }

    public double getMu() {
        return this.mu;
    }

    public double getAngularVelocity() {
        return this.angularVelocity;
    }

    public double getCycleDuration() {
        return this.cycleDuration;
    }

    public int getPRN() {
        return this.prn;
    }

    public void setPRN(int number) {
        this.prn = number;
    }

    public int getWeek() {
        return this.week;
    }

    public void setWeek(int week) {
        this.week = week;
    }

    public double getSma() {
        return this.sma;
    }

    public void setSma(double sma) {
        this.sma = sma;
    }

    public double getTime() {
        return this.time;
    }

    public void setTime(double time) {
        this.time = time;
    }

    public double getE() {
        return this.ecc;
    }

    public void setE(double e) {
        this.ecc = e;
    }

    public double getI0() {
        return this.i0;
    }

    public void setI0(double i0) {
        this.i0 = i0;
    }

    public double getOmega0() {
        return this.om0;
    }

    public void setOmega0(double omega0) {
        this.om0 = omega0;
    }

    public double getOmegaDot() {
        return this.dom;
    }

    public void setOmegaDot(double omegaDot) {
        this.dom = omegaDot;
    }

    public double getPa() {
        return this.aop;
    }

    public void setPa(double omega) {
        this.aop = omega;
    }

    public double getM0() {
        return this.anom;
    }

    public void setM0(double m0) {
        this.anom = m0;
    }

    public double getAf0() {
        return this.af0;
    }

    public void setAf0(double af0) {
        this.af0 = af0;
    }

    public double getAf1() {
        return this.af1;
    }

    public void setAf1(double af1) {
        this.af1 = af1;
    }

    public AbsoluteDate getDate() {
        return this.date;
    }

    public void setDate(AbsoluteDate date) {
        this.date = date;
    }
}

