/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.analytical.gnss;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.analysis.differentiation.UnivariateDerivative2;
import org.hipparchus.exception.Localizable;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.FieldSinCos;
import org.hipparchus.util.MathArrays;
import org.hipparchus.util.MathUtils;
import org.hipparchus.util.Precision;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.data.DataContext;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.Frame;
import org.orekit.orbits.CartesianOrbit;
import org.orekit.orbits.Orbit;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.analytical.AbstractAnalyticalPropagator;
import org.orekit.propagation.analytical.gnss.data.GLONASSOrbitalElements;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.GLONASSDate;
import org.orekit.time.GLONASSScale;
import org.orekit.utils.PVCoordinates;

public class GLONASSAnalyticalPropagator
extends AbstractAnalyticalPropagator {
    private static final double SEVEN_THIRD = 2.3333333333333335;
    private static final double SEVEN_SIXTH = 1.1666666666666667;
    private static final double SEVEN_24TH = 0.2916666666666667;
    private static final double FN_72TH = 0.6805555555555556;
    private static final double GLONASS_AV = 7.292115E-5;
    private static final double GLONASS_MEAN_INCLINATION = 64.8;
    private static final double GLONASS_MEAN_DRACONIAN_PERIOD = 40544.0;
    private static final double GLONASS_J20 = 0.00108262575;
    private static final double GLONASS_EARTH_EQUATORIAL_RADIUS = 6378136.0;
    private static final double A;
    private static final double B;
    private final GLONASSOrbitalElements glonassOrbit;
    private final double mass;
    private final Frame eci;
    private final Frame ecef;
    private final DataContext dataContext;

    GLONASSAnalyticalPropagator(GLONASSOrbitalElements glonassOrbit, Frame eci, Frame ecef, AttitudeProvider provider, double mass, DataContext context) {
        super(provider);
        this.dataContext = context;
        this.glonassOrbit = glonassOrbit;
        this.setStartDate(glonassOrbit.getDate());
        this.mass = mass;
        this.eci = eci;
        this.ecef = ecef;
    }

    public PVCoordinates propagateInEcef(AbsoluteDate date) {
        UnivariateDerivative2 dTpr = this.getdTpr(date);
        UnivariateDerivative2 zero = dTpr.getField().getZero();
        UnivariateDerivative2 w = (UnivariateDerivative2)FastMath.floor((CalculusFieldElement)dTpr.divide(40544.0 + this.glonassOrbit.getDeltaT()));
        UnivariateDerivative2 i = zero.add(1.1309733552923245 + this.glonassOrbit.getDeltaI());
        UnivariateDerivative2 e = zero.add(this.glonassOrbit.getE());
        UnivariateDerivative2 tDR = w.multiply(2.0).add(1.0).multiply(this.glonassOrbit.getDeltaTDot()).add(this.glonassOrbit.getDeltaT()).add(40544.0);
        UnivariateDerivative2 n = tDR.divide(6.28318530717958).reciprocal();
        UnivariateDerivative2 sma = this.computeSma(tDR, i, e);
        UnivariateDerivative2 p = sma.multiply(e.multiply(e).negate().add(1.0));
        UnivariateDerivative2 aeop = p.divide(6378136.0).reciprocal();
        UnivariateDerivative2 aeop2 = aeop.multiply(aeop);
        UnivariateDerivative2 lambda = this.computeLambda(dTpr, n, aeop2, i);
        UnivariateDerivative2 pa = this.computePA(dTpr, n, aeop2, i);
        UnivariateDerivative2 tanPAo2 = (UnivariateDerivative2)FastMath.tan((CalculusFieldElement)pa.divide(2.0));
        UnivariateDerivative2 coef = tanPAo2.multiply((UnivariateDerivative2)FastMath.sqrt((CalculusFieldElement)e.negate().add(1.0).divide(e.add(1.0))));
        UnivariateDerivative2 e0 = ((UnivariateDerivative2)FastMath.atan((CalculusFieldElement)coef)).multiply(2.0).negate();
        UnivariateDerivative2 m1 = pa.add(e0).subtract(((UnivariateDerivative2)FastMath.sin((CalculusFieldElement)e0)).multiply(e));
        UnivariateDerivative2 correction = dTpr.subtract(w.multiply(40544.0 + this.glonassOrbit.getDeltaT())).subtract(w.multiply(w).multiply(this.glonassOrbit.getDeltaTDot()));
        UnivariateDerivative2 m = m1.add(n.multiply(correction));
        FieldSinCos scPa = FastMath.sinCos((CalculusFieldElement)pa);
        UnivariateDerivative2 h = e.multiply((UnivariateDerivative2)scPa.sin());
        UnivariateDerivative2 l = e.multiply((UnivariateDerivative2)scPa.cos());
        UnivariateDerivative2[] d1 = this.getParameterDifferentials(sma, i, h, l, m1);
        UnivariateDerivative2[] d2 = this.getParameterDifferentials(sma, i, h, l, m);
        UnivariateDerivative2 smaCorr = sma.add(d2[0]).subtract(d1[0]);
        UnivariateDerivative2 hCorr = h.add(d2[1]).subtract(d1[1]);
        UnivariateDerivative2 lCorr = l.add(d2[2]).subtract(d1[2]);
        UnivariateDerivative2 lambdaCorr = lambda.add(d2[3]).subtract(d1[3]);
        UnivariateDerivative2 iCorr = i.add(d2[4]).subtract(d1[4]);
        UnivariateDerivative2 mCorr = m.add(d2[5]).subtract(d1[5]);
        UnivariateDerivative2 eCorr = (UnivariateDerivative2)FastMath.sqrt((CalculusFieldElement)hCorr.multiply(hCorr).add(lCorr.multiply(lCorr)));
        UnivariateDerivative2 paCorr = eCorr.getValue() == 0.0 ? zero : (lCorr.getValue() == eCorr.getValue() ? zero.add(1.570796326794895) : (lCorr.getValue() == -eCorr.getValue() ? zero.add(-1.570796326794895) : (UnivariateDerivative2)FastMath.atan2((CalculusFieldElement)hCorr, (CalculusFieldElement)lCorr)));
        UnivariateDerivative2 mk = mCorr.subtract(paCorr);
        UnivariateDerivative2 ek = this.getEccentricAnomaly(mk, eCorr);
        UnivariateDerivative2 vk = this.getTrueAnomaly(ek, eCorr);
        UnivariateDerivative2 phik = vk.add(paCorr);
        UnivariateDerivative2 pCorr = smaCorr.multiply(eCorr.multiply(eCorr).negate().add(1.0));
        UnivariateDerivative2 rk = pCorr.divide(eCorr.multiply((UnivariateDerivative2)FastMath.cos((CalculusFieldElement)vk)).add(1.0));
        FieldSinCos scPhik = FastMath.sinCos((CalculusFieldElement)phik);
        UnivariateDerivative2 xk = ((UnivariateDerivative2)scPhik.cos()).multiply(rk);
        UnivariateDerivative2 yk = ((UnivariateDerivative2)scPhik.sin()).multiply(rk);
        FieldSinCos scL = FastMath.sinCos((CalculusFieldElement)lambdaCorr);
        FieldSinCos scI = FastMath.sinCos((CalculusFieldElement)iCorr);
        FieldVector3D positionwithDerivatives = new FieldVector3D((CalculusFieldElement)xk.multiply((UnivariateDerivative2)scL.cos()).subtract(yk.multiply((UnivariateDerivative2)scL.sin()).multiply((UnivariateDerivative2)scI.cos())), (CalculusFieldElement)xk.multiply((UnivariateDerivative2)scL.sin()).add(yk.multiply((UnivariateDerivative2)scL.cos()).multiply((UnivariateDerivative2)scI.cos())), (CalculusFieldElement)yk.multiply((UnivariateDerivative2)scI.sin()));
        return new PVCoordinates(new Vector3D(((UnivariateDerivative2)positionwithDerivatives.getX()).getValue(), ((UnivariateDerivative2)positionwithDerivatives.getY()).getValue(), ((UnivariateDerivative2)positionwithDerivatives.getZ()).getValue()), new Vector3D(((UnivariateDerivative2)positionwithDerivatives.getX()).getFirstDerivative(), ((UnivariateDerivative2)positionwithDerivatives.getY()).getFirstDerivative(), ((UnivariateDerivative2)positionwithDerivatives.getZ()).getFirstDerivative()), new Vector3D(((UnivariateDerivative2)positionwithDerivatives.getX()).getSecondDerivative(), ((UnivariateDerivative2)positionwithDerivatives.getY()).getSecondDerivative(), ((UnivariateDerivative2)positionwithDerivatives.getZ()).getSecondDerivative()));
    }

    private UnivariateDerivative2 getEccentricAnomaly(UnivariateDerivative2 mk, UnivariateDerivative2 e) {
        UnivariateDerivative2 ek;
        UnivariateDerivative2 reducedM = new UnivariateDerivative2(MathUtils.normalizeAngle((double)mk.getValue(), (double)0.0), mk.getFirstDerivative(), mk.getSecondDerivative());
        if (FastMath.abs((double)reducedM.getValue()) < 0.16666666666666666) {
            ek = FastMath.abs((double)reducedM.getValue()) < Precision.SAFE_MIN ? reducedM : reducedM.add(reducedM.multiply(6).cbrt().subtract(reducedM).multiply(e));
        } else if (reducedM.getValue() < 0.0) {
            UnivariateDerivative2 w = reducedM.add(Math.PI);
            ek = reducedM.add(w.multiply(-A).divide(w.subtract(B)).subtract(Math.PI).subtract(reducedM).multiply(e));
        } else {
            UnivariateDerivative2 minusW = reducedM.subtract(Math.PI);
            ek = reducedM.add(minusW.multiply(A).divide(minusW.add(B)).add(Math.PI).subtract(reducedM).multiply(e));
        }
        UnivariateDerivative2 e1 = e.negate().add(1.0);
        boolean noCancellationRisk = e1.getValue() + ek.getValue() * ek.getValue() / 6.0 >= 0.1;
        for (int j = 0; j < 2; ++j) {
            UnivariateDerivative2 fd;
            UnivariateDerivative2 f;
            UnivariateDerivative2 fdd = ek.sin().multiply(e);
            UnivariateDerivative2 fddd = ek.cos().multiply(e);
            if (noCancellationRisk) {
                f = ek.subtract(fdd).subtract(reducedM);
                fd = fddd.subtract(1.0).negate();
            } else {
                f = this.eMeSinE(ek, e).subtract(reducedM);
                UnivariateDerivative2 s = ek.multiply(0.5).sin();
                fd = s.multiply(s).multiply(e.multiply(2.0)).add(e1);
            }
            UnivariateDerivative2 dee = f.multiply(fd).divide(f.multiply(0.5).multiply(fdd).subtract(fd.multiply(fd)));
            UnivariateDerivative2 w = fd.add(dee.multiply(0.5).multiply(fdd.add(dee.multiply(fdd).divide(3.0))));
            fd = fd.add(dee.multiply(fdd.add(dee.multiply(0.5).multiply(fdd))));
            ek = ek.subtract(f.subtract(dee.multiply(fd.subtract(w))).divide(fd));
        }
        ek = ek.add(mk.getValue() - reducedM.getValue());
        return ek;
    }

    private UnivariateDerivative2 eMeSinE(UnivariateDerivative2 E, UnivariateDerivative2 ecc) {
        UnivariateDerivative2 x = E.sin().multiply(ecc.negate().add(1.0));
        UnivariateDerivative2 mE2 = E.negate().multiply(E);
        UnivariateDerivative2 term = E;
        UnivariateDerivative2 d = E.getField().getZero();
        UnivariateDerivative2 x0 = d.add(Double.NaN);
        while (!Double.valueOf(x.getValue()).equals(x0.getValue())) {
            d = d.add(2.0);
            term = term.multiply(mE2.divide(d.multiply(d.add(1.0))));
            x0 = x;
            x = x.subtract(term);
        }
        return x;
    }

    private UnivariateDerivative2 getTrueAnomaly(UnivariateDerivative2 ek, UnivariateDerivative2 ecc) {
        UnivariateDerivative2 svk = ek.sin().multiply((UnivariateDerivative2)FastMath.sqrt((CalculusFieldElement)ecc.multiply(ecc).negate().add(1.0)));
        UnivariateDerivative2 cvk = ek.cos().subtract(ecc);
        return svk.atan2(cvk);
    }

    private UnivariateDerivative2 getdTpr(AbsoluteDate date) {
        GLONASSScale glonass = this.dataContext.getTimeScales().getGLONASS();
        GLONASSDate tEnd = new GLONASSDate(date, glonass);
        GLONASSDate tSta = new GLONASSDate(this.glonassOrbit.getDate(), glonass);
        int n = tEnd.getDayNumber();
        int na = tSta.getDayNumber();
        int deltaN = na == 27 ? n - na - FastMath.round((float)((float)(n - na) / 1460.0f)) * 1460 : n - na - FastMath.round((float)((float)(n - na) / 1461.0f)) * 1461;
        UnivariateDerivative2 ti = new UnivariateDerivative2(tEnd.getSecInDay(), 1.0, 0.0);
        return ti.subtract(this.glonassOrbit.getTime()).add((double)(86400 * deltaN));
    }

    private UnivariateDerivative2 computeSma(UnivariateDerivative2 tDR, UnivariateDerivative2 i, UnivariateDerivative2 e) {
        UnivariateDerivative2 zero = tDR.getField().getZero();
        if (Double.isNaN(tDR.getValue()) || Double.isNaN(i.getValue()) || Double.isNaN(e.getValue())) {
            return zero.add(Double.NaN);
        }
        UnivariateDerivative2 sinI = (UnivariateDerivative2)FastMath.sin((CalculusFieldElement)i);
        UnivariateDerivative2 sin2I = sinI.multiply(sinI);
        UnivariateDerivative2 ome2 = e.multiply(e).negate().add(1.0);
        UnivariateDerivative2 ome2Pow3o2 = ((UnivariateDerivative2)FastMath.sqrt((CalculusFieldElement)ome2)).multiply(ome2);
        UnivariateDerivative2 pa = zero.add(this.glonassOrbit.getPa());
        UnivariateDerivative2 cosPA = (UnivariateDerivative2)FastMath.cos((CalculusFieldElement)pa);
        UnivariateDerivative2 opecosPA = e.multiply(cosPA).add(1.0);
        UnivariateDerivative2 opecosPAPow2 = opecosPA.multiply(opecosPA);
        UnivariateDerivative2 opecosPAPow3 = opecosPAPow2.multiply(opecosPA);
        UnivariateDerivative2 tOCK = tDR;
        UnivariateDerivative2 an = zero;
        UnivariateDerivative2 anp1 = zero;
        boolean isLastStep = false;
        while (!isLastStep) {
            UnivariateDerivative2 tOCKo2p = tOCK.divide(6.28318530717958);
            UnivariateDerivative2 tOCKo2pPow2 = tOCKo2p.multiply(tOCKo2p);
            anp1 = (UnivariateDerivative2)FastMath.cbrt((CalculusFieldElement)tOCKo2pPow2.multiply(3.986004418E14));
            UnivariateDerivative2 p = anp1.multiply(ome2);
            UnivariateDerivative2 aeop = p.divide(6378136.0).reciprocal();
            UnivariateDerivative2 aeop2 = aeop.multiply(aeop);
            UnivariateDerivative2 term1 = aeop2.multiply(0.00108262575).multiply(1.5);
            UnivariateDerivative2 term2 = sin2I.multiply(2.5).negate().add(2.0);
            UnivariateDerivative2 term3 = ome2Pow3o2.divide(opecosPAPow2);
            UnivariateDerivative2 term4 = opecosPAPow3.divide(ome2);
            tOCK = tDR.divide(term1.multiply(term2.multiply(term3).add(term4)).negate().add(1.0));
            if (FastMath.abs((double)anp1.subtract(an).getReal()) <= 0.01) {
                isLastStep = true;
            }
            an = anp1;
        }
        return an;
    }

    private UnivariateDerivative2 computeLambda(UnivariateDerivative2 dTpr, UnivariateDerivative2 n, UnivariateDerivative2 aeop2, UnivariateDerivative2 i) {
        UnivariateDerivative2 cosI = (UnivariateDerivative2)FastMath.cos((CalculusFieldElement)i);
        UnivariateDerivative2 precession = aeop2.multiply(n).multiply(cosI).multiply(0.0016239386250000002);
        return dTpr.multiply(precession.add(7.292115E-5)).negate().add(this.glonassOrbit.getLambda());
    }

    private UnivariateDerivative2 computePA(UnivariateDerivative2 dTpr, UnivariateDerivative2 n, UnivariateDerivative2 aeop2, UnivariateDerivative2 i) {
        UnivariateDerivative2 cosI = (UnivariateDerivative2)FastMath.cos((CalculusFieldElement)i);
        UnivariateDerivative2 cos2I = cosI.multiply(cosI);
        UnivariateDerivative2 precession = aeop2.multiply(n).multiply(cos2I.multiply(5.0).negate().add(1.0)).multiply(8.119693125000001E-4);
        return dTpr.multiply(precession).negate().add(this.glonassOrbit.getPa());
    }

    private UnivariateDerivative2[] getParameterDifferentials(UnivariateDerivative2 a, UnivariateDerivative2 i, UnivariateDerivative2 h, UnivariateDerivative2 l, UnivariateDerivative2 m) {
        UnivariateDerivative2 aeoa = a.divide(6378136.0).reciprocal();
        UnivariateDerivative2 aeoa2 = aeoa.multiply(aeoa);
        UnivariateDerivative2 b = aeoa2.multiply(0.0016239386250000002);
        FieldSinCos scI = FastMath.sinCos((CalculusFieldElement)i);
        FieldSinCos scLk = FastMath.sinCos((CalculusFieldElement)m);
        FieldSinCos sc2Lk = FieldSinCos.sum((FieldSinCos)scLk, (FieldSinCos)scLk);
        FieldSinCos sc3Lk = FieldSinCos.sum((FieldSinCos)scLk, (FieldSinCos)sc2Lk);
        FieldSinCos sc4Lk = FieldSinCos.sum((FieldSinCos)sc2Lk, (FieldSinCos)sc2Lk);
        UnivariateDerivative2 cosI = (UnivariateDerivative2)scI.cos();
        UnivariateDerivative2 sinI = (UnivariateDerivative2)scI.sin();
        UnivariateDerivative2 cosI2 = cosI.multiply(cosI);
        UnivariateDerivative2 sinI2 = sinI.multiply(sinI);
        UnivariateDerivative2 cosLk = (UnivariateDerivative2)scLk.cos();
        UnivariateDerivative2 sinLk = (UnivariateDerivative2)scLk.sin();
        UnivariateDerivative2 cos2Lk = (UnivariateDerivative2)sc2Lk.cos();
        UnivariateDerivative2 sin2Lk = (UnivariateDerivative2)sc2Lk.sin();
        UnivariateDerivative2 cos3Lk = (UnivariateDerivative2)sc3Lk.cos();
        UnivariateDerivative2 sin3Lk = (UnivariateDerivative2)sc3Lk.sin();
        UnivariateDerivative2 cos4Lk = (UnivariateDerivative2)sc4Lk.cos();
        UnivariateDerivative2 sin4Lk = (UnivariateDerivative2)sc4Lk.sin();
        UnivariateDerivative2 hCosLk = h.multiply(cosLk);
        UnivariateDerivative2 hSinLk = h.multiply(sinLk);
        UnivariateDerivative2 lCosLk = l.multiply(cosLk);
        UnivariateDerivative2 lSinLk = l.multiply(sinLk);
        UnivariateDerivative2 hCos2Lk = h.multiply(cos2Lk);
        UnivariateDerivative2 hSin2Lk = h.multiply(sin2Lk);
        UnivariateDerivative2 lCos2Lk = l.multiply(cos2Lk);
        UnivariateDerivative2 lSin2Lk = l.multiply(sin2Lk);
        UnivariateDerivative2 hCos3Lk = h.multiply(cos3Lk);
        UnivariateDerivative2 hSin3Lk = h.multiply(sin3Lk);
        UnivariateDerivative2 lCos3Lk = l.multiply(cos3Lk);
        UnivariateDerivative2 lSin3Lk = l.multiply(sin3Lk);
        UnivariateDerivative2 hCos4Lk = h.multiply(cos4Lk);
        UnivariateDerivative2 hSin4Lk = h.multiply(sin4Lk);
        UnivariateDerivative2 lCos4Lk = l.multiply(cos4Lk);
        UnivariateDerivative2 lSin4Lk = l.multiply(sin4Lk);
        UnivariateDerivative2 om3o2xSinI2 = sinI2.multiply(1.5).negate().add(1.0);
        UnivariateDerivative2 dakT1 = b.multiply(2.0).multiply(om3o2xSinI2).multiply(lCosLk.add(hSinLk));
        UnivariateDerivative2 dakT2 = b.multiply(sinI2).multiply(hSinLk.multiply(0.5).subtract(lCosLk.multiply(0.5)).add(cos2Lk).add(lCos3Lk.multiply(3.5)).add(hSin3Lk.multiply(3.5)));
        UnivariateDerivative2 dak = dakT1.add(dakT2);
        UnivariateDerivative2 dhkT1 = b.multiply(om3o2xSinI2).multiply(sinLk.add(lSin2Lk.multiply(1.5)).subtract(hCos2Lk.multiply(1.5)));
        UnivariateDerivative2 dhkT2 = b.multiply(sinI2).multiply(0.25).multiply(sinLk.subtract(sin3Lk.multiply(2.3333333333333335)).add(lSin2Lk.multiply(5.0)).subtract(lSin4Lk.multiply(8.5)).add(hCos4Lk.multiply(8.5)).add(hCos2Lk));
        UnivariateDerivative2 dhkT3 = lSin2Lk.multiply(cosI2).multiply(b).multiply(0.5).negate();
        UnivariateDerivative2 dhk = dhkT1.subtract(dhkT2).add(dhkT3);
        UnivariateDerivative2 dlkT1 = b.multiply(om3o2xSinI2).multiply(cosLk.add(lCos2Lk.multiply(1.5)).add(hSin2Lk.multiply(1.5)));
        UnivariateDerivative2 dlkT2 = b.multiply(sinI2).multiply(0.25).multiply(cosLk.negate().subtract(cos3Lk.multiply(2.3333333333333335)).subtract(hSin2Lk.multiply(5.0)).subtract(lCos4Lk.multiply(8.5)).subtract(hSin4Lk.multiply(8.5)).add(lCos2Lk));
        UnivariateDerivative2 dlkT3 = hSin2Lk.multiply(cosI2).multiply(b).multiply(0.5);
        UnivariateDerivative2 dlk = dlkT1.subtract(dlkT2).add(dlkT3);
        UnivariateDerivative2 dokT1 = b.negate().multiply(cosI);
        UnivariateDerivative2 dokT2 = lSinLk.multiply(3.5).subtract(hCosLk.multiply(2.5)).subtract(sin2Lk.multiply(0.5)).subtract(lSin3Lk.multiply(1.1666666666666667)).add(hCos3Lk.multiply(1.1666666666666667));
        UnivariateDerivative2 dok = dokT1.multiply(dokT2);
        UnivariateDerivative2 dik = b.multiply(sinI).multiply(cosI).multiply(0.5).multiply(lCosLk.negate().add(hSinLk).add(cos2Lk).add(lCos3Lk.multiply(2.3333333333333335)).add(hSin3Lk.multiply(2.3333333333333335)));
        UnivariateDerivative2 dLkT1 = b.multiply(2.0).multiply(om3o2xSinI2).multiply(lSinLk.multiply(1.75).subtract(hCosLk.multiply(1.75)));
        UnivariateDerivative2 dLkT2 = b.multiply(sinI2).multiply(3.0).multiply(hCosLk.multiply(0.2916666666666667).negate().subtract(lSinLk.multiply(0.2916666666666667)).subtract(hCos3Lk.multiply(0.6805555555555556)).add(lSin3Lk.multiply(0.6805555555555556)).add(sin2Lk.multiply(0.25)));
        UnivariateDerivative2 dLkT3 = b.multiply(cosI2).multiply(lSinLk.multiply(3.5).subtract(hCosLk.multiply(2.5)).subtract(sin2Lk.multiply(0.5)).subtract(lSin3Lk.multiply(1.1666666666666667)).add(hCos3Lk.multiply(1.1666666666666667)));
        UnivariateDerivative2 dLk = dLkT1.add(dLkT2).add(dLkT3);
        UnivariateDerivative2[] differentials = (UnivariateDerivative2[])MathArrays.buildArray((Field)a.getField(), (int)6);
        differentials[0] = dak.multiply(a);
        differentials[1] = dhk;
        differentials[2] = dlk;
        differentials[3] = dok;
        differentials[4] = dik;
        differentials[5] = dLk;
        return differentials;
    }

    @Override
    protected double getMass(AbsoluteDate date) {
        return this.mass;
    }

    public static double getMU() {
        return 3.986004418E14;
    }

    public GLONASSOrbitalElements getGLONASSOrbitalElements() {
        return this.glonassOrbit;
    }

    public Frame getECI() {
        return this.eci;
    }

    public Frame getECEF() {
        return this.ecef;
    }

    @Override
    public Frame getFrame() {
        return this.eci;
    }

    @Override
    public void resetInitialState(SpacecraftState state) {
        throw new OrekitException((Localizable)OrekitMessages.NON_RESETABLE_STATE, new Object[0]);
    }

    @Override
    protected void resetIntermediateState(SpacecraftState state, boolean forward) {
        throw new OrekitException((Localizable)OrekitMessages.NON_RESETABLE_STATE, new Object[0]);
    }

    @Override
    protected Orbit propagateOrbit(AbsoluteDate date) {
        PVCoordinates pvaInECEF = this.propagateInEcef(date);
        PVCoordinates pvaInECI = this.ecef.getTransformTo(this.eci, date).transformPVCoordinates(pvaInECEF);
        return new CartesianOrbit(pvaInECI, this.eci, date, 3.986004418E14);
    }

    static {
        double k1 = 11.42477796076938;
        double k2 = 2.141592653589793;
        double k3 = 17.84955592153876;
        A = 1.2043347651023166;
        B = 4.64788969626918;
    }
}

