/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.analytical;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.hipparchus.exception.Localizable;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.orbits.Orbit;
import org.orekit.propagation.Propagator;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.analytical.AbstractAnalyticalPropagator;
import org.orekit.time.AbsoluteDate;

public class AdapterPropagator
extends AbstractAnalyticalPropagator {
    private Propagator reference;
    private List<DifferentialEffect> effects;

    public AdapterPropagator(Propagator reference) {
        super(reference.getAttitudeProvider());
        this.reference = reference;
        this.effects = new ArrayList<DifferentialEffect>();
    }

    public void addEffect(DifferentialEffect effect) {
        this.effects.add(effect);
    }

    public Propagator getPropagator() {
        return this.reference;
    }

    public List<DifferentialEffect> getEffects() {
        return Collections.unmodifiableList(this.effects);
    }

    @Override
    public SpacecraftState getInitialState() {
        return this.reference.getInitialState();
    }

    @Override
    public void resetInitialState(SpacecraftState state) {
        this.reference.resetInitialState(state);
    }

    @Override
    protected void resetIntermediateState(SpacecraftState state, boolean forward) {
        if (!(this.reference instanceof AbstractAnalyticalPropagator)) {
            throw new OrekitException((Localizable)OrekitMessages.NON_RESETABLE_STATE, new Object[0]);
        }
        ((AbstractAnalyticalPropagator)this.reference).resetIntermediateState(state, forward);
    }

    @Override
    protected SpacecraftState basicPropagate(AbsoluteDate date) {
        SpacecraftState state = this.reference.propagate(date);
        Map<String, double[]> before = state.getAdditionalStates();
        for (DifferentialEffect differentialEffect : this.effects) {
            state = differentialEffect.apply(state);
        }
        for (Map.Entry entry : before.entrySet()) {
            if (state.hasAdditionalState((String)entry.getKey())) continue;
            state = state.addAdditionalState((String)entry.getKey(), (double[])entry.getValue());
        }
        return state;
    }

    @Override
    protected Orbit propagateOrbit(AbsoluteDate date) {
        return this.basicPropagate(date).getOrbit();
    }

    @Override
    protected double getMass(AbsoluteDate date) {
        return this.basicPropagate(date).getMass();
    }

    public static interface DifferentialEffect {
        public SpacecraftState apply(SpacecraftState var1);
    }
}

