/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth.troposphere;

import java.util.Collections;
import java.util.List;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.bodies.FieldGeodeticPoint;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.data.DataContext;
import org.orekit.models.earth.troposphere.DiscreteTroposphericModel;
import org.orekit.models.earth.troposphere.MappingFunction;
import org.orekit.models.earth.troposphere.TroposphericModelUtils;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.DateTimeComponents;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.TimeScale;
import org.orekit.utils.ParameterDriver;

public class ViennaOneModel
implements DiscreteTroposphericModel,
MappingFunction {
    private final double[] coefficientsA;
    private final double[] zenithDelay;
    private final TimeScale utc;

    @DefaultDataContext
    public ViennaOneModel(double[] coefficientA, double[] zenithDelay) {
        this(coefficientA, zenithDelay, DataContext.getDefault().getTimeScales().getUTC());
    }

    public ViennaOneModel(double[] coefficientA, double[] zenithDelay, TimeScale utc) {
        this.coefficientsA = (double[])coefficientA.clone();
        this.zenithDelay = (double[])zenithDelay.clone();
        this.utc = utc;
    }

    @Override
    public double pathDelay(double elevation, GeodeticPoint point, double[] parameters, AbsoluteDate date) {
        double[] delays = this.computeZenithDelay(point, parameters, date);
        double[] mappingFunction = this.mappingFactors(elevation, point, date);
        return delays[0] * mappingFunction[0] + delays[1] * mappingFunction[1];
    }

    @Override
    public <T extends CalculusFieldElement<T>> T pathDelay(T elevation, FieldGeodeticPoint<T> point, T[] parameters, FieldAbsoluteDate<T> date) {
        CalculusFieldElement[] delays = this.computeZenithDelay(point, (CalculusFieldElement[])parameters, date);
        CalculusFieldElement[] mappingFunction = this.mappingFactors(elevation, point, date);
        return (T)((CalculusFieldElement)((CalculusFieldElement)delays[0].multiply((FieldElement)mappingFunction[0])).add(delays[1].multiply((FieldElement)mappingFunction[1])));
    }

    public double[] computeZenithDelay(GeodeticPoint point, double[] parameters, AbsoluteDate date) {
        return (double[])this.zenithDelay.clone();
    }

    public <T extends CalculusFieldElement<T>> T[] computeZenithDelay(FieldGeodeticPoint<T> point, T[] parameters, FieldAbsoluteDate<T> date) {
        Field<T> field = date.getField();
        CalculusFieldElement zero = (CalculusFieldElement)field.getZero();
        CalculusFieldElement[] delays = (CalculusFieldElement[])MathArrays.buildArray(field, (int)2);
        delays[0] = (CalculusFieldElement)zero.add(this.zenithDelay[0]);
        delays[1] = (CalculusFieldElement)zero.add(this.zenithDelay[1]);
        return delays;
    }

    @Override
    public double[] mappingFactors(double elevation, GeodeticPoint point, AbsoluteDate date) {
        double psi;
        double c11h;
        double c10h;
        DateTimeComponents dtc = date.getComponents(this.utc);
        int dofyear = dtc.getDate().getDayOfYear();
        double bh = 0.0029;
        double c0h = 0.062;
        double latitude = point.getLatitude();
        if (FastMath.sin((double)latitude) > 0.0) {
            c10h = 0.001;
            c11h = 0.005;
            psi = 0.0;
        } else {
            c10h = 0.002;
            c11h = 0.007;
            psi = Math.PI;
        }
        double t0 = 28.0;
        if (latitude < 0.0) {
            t0 += 183.0;
        }
        double coef = ((double)dofyear - t0) / 365.0 * 2.0 * Math.PI + psi;
        double ch = 0.062 + ((FastMath.cos((double)coef) + 1.0) * (c11h / 2.0) + c10h) * (1.0 - FastMath.cos((double)latitude));
        double bw = 0.00146;
        double cw = 0.04391;
        double[] function = new double[]{TroposphericModelUtils.mappingFunction(this.coefficientsA[0], 0.0029, ch, elevation), TroposphericModelUtils.mappingFunction(this.coefficientsA[1], 0.00146, 0.04391, elevation)};
        double correction = TroposphericModelUtils.computeHeightCorrection(elevation, point.getAltitude());
        function[0] = function[0] + correction;
        return function;
    }

    @Override
    public <T extends CalculusFieldElement<T>> T[] mappingFactors(T elevation, FieldGeodeticPoint<T> point, FieldAbsoluteDate<T> date) {
        CalculusFieldElement psi;
        CalculusFieldElement c11h;
        CalculusFieldElement c10h;
        Field<T> field = date.getField();
        CalculusFieldElement zero = (CalculusFieldElement)field.getZero();
        DateTimeComponents dtc = date.getComponents(this.utc);
        int dofyear = dtc.getDate().getDayOfYear();
        CalculusFieldElement bh = (CalculusFieldElement)zero.add(0.0029);
        CalculusFieldElement c0h = (CalculusFieldElement)zero.add(0.062);
        T latitude = point.getLatitude();
        if (FastMath.sin((double)latitude.getReal()) > 0.0) {
            c10h = (CalculusFieldElement)zero.add(0.001);
            c11h = (CalculusFieldElement)zero.add(0.005);
            psi = zero;
        } else {
            c10h = (CalculusFieldElement)zero.add(0.002);
            c11h = (CalculusFieldElement)zero.add(0.007);
            psi = (CalculusFieldElement)zero.getPi();
        }
        double t0 = 28.0;
        if (latitude.getReal() < 0.0) {
            t0 += 183.0;
        }
        CalculusFieldElement coef = (CalculusFieldElement)psi.add(((CalculusFieldElement)((CalculusFieldElement)zero.getPi()).multiply(2.0)).multiply(((double)dofyear - t0) / 365.0));
        CalculusFieldElement ch = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)c11h.divide(2.0)).multiply(FastMath.cos((CalculusFieldElement)coef).add(1.0))).add((FieldElement)c10h)).multiply(((CalculusFieldElement)FastMath.cos(latitude).negate()).add(1.0))).add((FieldElement)c0h);
        CalculusFieldElement bw = (CalculusFieldElement)zero.add(0.00146);
        CalculusFieldElement cw = (CalculusFieldElement)zero.add(0.04391);
        CalculusFieldElement[] function = (CalculusFieldElement[])MathArrays.buildArray(field, (int)2);
        function[0] = TroposphericModelUtils.mappingFunction((CalculusFieldElement)zero.add(this.coefficientsA[0]), bh, ch, elevation);
        function[1] = TroposphericModelUtils.mappingFunction((CalculusFieldElement)zero.add(this.coefficientsA[1]), bw, cw, elevation);
        T correction = TroposphericModelUtils.computeHeightCorrection(elevation, point.getAltitude(), field);
        function[0] = (CalculusFieldElement)function[0].add(correction);
        return function;
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return Collections.emptyList();
    }
}

