/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth.ionosphere;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.FieldElement;
import org.hipparchus.util.FastMath;
import org.orekit.models.earth.ionosphere.IonosphericMappingFunction;

public class SingleLayerModelMappingFunction
implements IonosphericMappingFunction {
    private static final double DEFAULT_HEIGHT = 450000.0;
    private static final double RE = 6371000.0;
    private final double hIon;

    public SingleLayerModelMappingFunction() {
        this(450000.0);
    }

    public SingleLayerModelMappingFunction(double hIon) {
        this.hIon = hIon;
    }

    @Override
    public double mappingFactor(double elevation) {
        double z = FastMath.abs((double)(1.5707963267948966 - elevation));
        double ratio = 6371000.0 / (6371000.0 + this.hIon);
        double coef = FastMath.sin((double)z) * ratio;
        return 1.0 / FastMath.sqrt((double)(1.0 - coef * coef));
    }

    @Override
    public <T extends CalculusFieldElement<T>> T mappingFactor(T elevation) {
        CalculusFieldElement z = FastMath.abs((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)elevation.negate()).add(((CalculusFieldElement)elevation.getPi()).multiply(0.5))));
        double ratio = 6371000.0 / (6371000.0 + this.hIon);
        CalculusFieldElement coef = (CalculusFieldElement)FastMath.sin((CalculusFieldElement)z).multiply(ratio);
        return (T)((CalculusFieldElement)FastMath.sqrt((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)coef.multiply((FieldElement)coef)).negate()).add(1.0))).reciprocal());
    }
}

