/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.orekit.data.DataLoader;
import org.orekit.models.earth.GeoMagneticField;

public class GeoMagneticModelLoader
implements DataLoader {
    private List<GeoMagneticField> models = new LinkedList<GeoMagneticField>();

    public Collection<GeoMagneticField> getModels() {
        return this.models;
    }

    @Override
    public boolean stillAcceptsData() {
        return this.models == null || this.models.isEmpty();
    }

    @Override
    public void loadData(InputStream input, String name) throws IOException, ParseException {
        GeoMagneticField model;
        StreamTokenizer str = new StreamTokenizer(new InputStreamReader(input, StandardCharsets.UTF_8));
        while ((model = this.readModel(str)) != null) {
            this.models.add(model);
        }
    }

    private GeoMagneticField readModel(StreamTokenizer stream) throws IOException {
        int ttype = stream.nextToken();
        if (ttype == -1) {
            return null;
        }
        if (ttype == -3) {
            return this.readCombinedFormat(stream);
        }
        return this.readOriginalWMMFormat(stream);
    }

    private GeoMagneticField readCombinedFormat(StreamTokenizer stream) throws IOException {
        int m;
        int n;
        String modelName = stream.sval;
        stream.nextToken();
        double epoch = stream.nval;
        stream.nextToken();
        int nMax = (int)stream.nval;
        stream.nextToken();
        int nMaxSecVar = (int)stream.nval;
        stream.nextToken();
        stream.nextToken();
        double startYear = stream.nval;
        stream.nextToken();
        double endYear = stream.nval;
        GeoMagneticField model = new GeoMagneticField(modelName, epoch, nMax, nMaxSecVar, startYear, endYear);
        stream.nextToken();
        double altmin = stream.nval;
        stream.nextToken();
        double altmax = stream.nval;
        stream.nextToken();
        stream.nextToken();
        boolean done = false;
        do {
            stream.nextToken();
            n = (int)stream.nval;
            stream.nextToken();
            m = (int)stream.nval;
            stream.nextToken();
            double gnm = stream.nval;
            stream.nextToken();
            double hnm = stream.nval;
            stream.nextToken();
            double dgnm = stream.nval;
            stream.nextToken();
            double dhnm = stream.nval;
            model.setMainFieldCoefficients(n, m, gnm, hnm);
            if (n <= nMaxSecVar && m <= nMaxSecVar) {
                model.setSecularVariationCoefficients(n, m, dgnm, dhnm);
            }
            stream.nextToken();
            stream.nextToken();
        } while (!(done = n == nMax && m == nMax));
        return model;
    }

    private GeoMagneticField readOriginalWMMFormat(StreamTokenizer stream) throws IOException {
        int m;
        int n;
        int nMax = 12;
        int nMaxSecVar = 12;
        stream.whitespaceChars(47, 47);
        double epoch = stream.nval;
        stream.nextToken();
        String modelName = stream.sval;
        stream.nextToken();
        double month = stream.nval;
        stream.nextToken();
        double day = stream.nval;
        stream.nextToken();
        double year = stream.nval;
        double startYear = GeoMagneticField.getDecimalYear((int)day, (int)month, (int)year);
        GeoMagneticField model = new GeoMagneticField(modelName, epoch, 12, 12, startYear, epoch + 5.0);
        boolean done = false;
        do {
            stream.nextToken();
            n = (int)stream.nval;
            stream.nextToken();
            m = (int)stream.nval;
            stream.nextToken();
            double gnm = stream.nval;
            stream.nextToken();
            double hnm = stream.nval;
            stream.nextToken();
            double dgnm = stream.nval;
            stream.nextToken();
            double dhnm = stream.nval;
            model.setMainFieldCoefficients(n, m, gnm, hnm);
            if (n > 12 || m > 12) continue;
            model.setSecularVariationCoefficients(n, m, dgnm, dhnm);
        } while (!(done = n == 12 && m == 12));
        stream.nextToken();
        stream.nextToken();
        return model;
    }
}

