/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.gnss.navigation;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.InputMismatchException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.hipparchus.exception.Localizable;
import org.hipparchus.util.FastMath;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.data.DataContext;
import org.orekit.data.DataSource;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.gnss.SatelliteSystem;
import org.orekit.gnss.TimeSystem;
import org.orekit.gnss.navigation.RinexNavigation;
import org.orekit.propagation.analytical.gnss.data.BeidouNavigationMessage;
import org.orekit.propagation.analytical.gnss.data.GLONASSNavigationMessage;
import org.orekit.propagation.analytical.gnss.data.GPSNavigationMessage;
import org.orekit.propagation.analytical.gnss.data.GalileoNavigationMessage;
import org.orekit.propagation.analytical.gnss.data.IRNSSNavigationMessage;
import org.orekit.propagation.analytical.gnss.data.QZSSNavigationMessage;
import org.orekit.propagation.analytical.gnss.data.SBASNavigationMessage;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.DateComponents;
import org.orekit.time.GNSSDate;
import org.orekit.time.TimeComponents;
import org.orekit.time.TimeScale;
import org.orekit.time.TimeScales;

public class RinexNavigationParser {
    private static final List<Double> HANDLED_VERSIONS = Arrays.asList(3.01, 3.02, 3.03, 3.04, 3.05);
    private static final String FILE_TYPE = "N";
    private static final Double SEC_TO_MILLI = 1000.0;
    private static final Double KM_TO_M = 1000.0;
    private final TimeScales timeScales;

    @DefaultDataContext
    public RinexNavigationParser() {
        this(DataContext.getDefault().getTimeScales());
    }

    public RinexNavigationParser(TimeScales timeScales) {
        this.timeScales = timeScales;
    }

    public RinexNavigation parse(DataSource source) throws IOException {
        ParseInfo pi = new ParseInfo();
        int lineNumber = 0;
        Stream<LineParser> candidateParsers = Stream.of(LineParser.HEADER_VERSION);
        try (Reader reader = source.getOpener().openReaderOnce();
             BufferedReader br = new BufferedReader(reader);){
            String line = br.readLine();
            while (line != null) {
                ++lineNumber;
                String l = line;
                Optional<LineParser> selected = candidateParsers.filter(p -> p.canHandle(l)).findFirst();
                if (selected.isPresent()) {
                    try {
                        selected.get().parse(line, pi);
                    }
                    catch (NumberFormatException | StringIndexOutOfBoundsException | InputMismatchException e) {
                        throw new OrekitException(e, OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, lineNumber, source.getName(), line);
                    }
                } else {
                    throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, lineNumber, source.getName(), line);
                }
                candidateParsers = selected.get().allowedNext();
                line = br.readLine();
            }
        }
        return pi.file;
    }

    private static double parseDouble(String line, int startIndex, int size) {
        return Double.parseDouble(line.substring(startIndex, startIndex + size).replace('D', 'E').trim());
    }

    private static int parseInt(String line, int startIndex, int size) {
        return Integer.parseInt(line.substring(startIndex, startIndex + size).trim());
    }

    private static String parseString(String line, int startIndex, int size) {
        return line.substring(startIndex, startIndex + size).trim();
    }

    private static enum SatelliteSystemLineParser {
        GPS("G"){

            @Override
            public void parseFirstLine(String line, ParseInfo pi) {
                pi.gpsNav.setPRN(RinexNavigationParser.parseInt(line, 1, 2));
                int gpsTocYear = RinexNavigationParser.parseInt(line, 4, 4);
                int gpsTocMonth = RinexNavigationParser.parseInt(line, 9, 2);
                int gpsTocDay = RinexNavigationParser.parseInt(line, 12, 2);
                int gpsTocHours = RinexNavigationParser.parseInt(line, 15, 2);
                int gpsTocMin = RinexNavigationParser.parseInt(line, 18, 2);
                int gpsTocSec = RinexNavigationParser.parseInt(line, 21, 2);
                pi.gpsNav.setEpochToc(new AbsoluteDate(gpsTocYear, gpsTocMonth, gpsTocDay, gpsTocHours, gpsTocMin, (double)gpsTocSec, (TimeScale)pi.timeScales.getGPS()));
                pi.gpsNav.setAf0(RinexNavigationParser.parseDouble(line, 23, 19));
                pi.gpsNav.setAf1(RinexNavigationParser.parseDouble(line, 42, 19));
                pi.gpsNav.setAf2(RinexNavigationParser.parseDouble(line, 61, 19));
            }

            @Override
            public void parseFirstBroadcastOrbit(String line, ParseInfo pi) {
                pi.gpsNav.setIODE(RinexNavigationParser.parseDouble(line, 4, 19));
                pi.gpsNav.setCrs(RinexNavigationParser.parseDouble(line, 23, 19));
                pi.gpsNav.setDeltaN(RinexNavigationParser.parseDouble(line, 42, 19));
                pi.gpsNav.setM0(RinexNavigationParser.parseDouble(line, 61, 19));
            }

            @Override
            public void parseSecondBroadcastOrbit(String line, ParseInfo pi) {
                pi.gpsNav.setCuc(RinexNavigationParser.parseDouble(line, 4, 19));
                pi.gpsNav.setE(RinexNavigationParser.parseDouble(line, 23, 19));
                pi.gpsNav.setCus(RinexNavigationParser.parseDouble(line, 42, 19));
                pi.gpsNav.setSqrtA(RinexNavigationParser.parseDouble(line, 61, 19));
            }

            @Override
            public void parseThirdBroadcastOrbit(String line, ParseInfo pi) {
                pi.gpsNav.setTime(RinexNavigationParser.parseDouble(line, 4, 19));
                pi.gpsNav.setCic(RinexNavigationParser.parseDouble(line, 23, 19));
                pi.gpsNav.setOmega0(RinexNavigationParser.parseDouble(line, 42, 19));
                pi.gpsNav.setCis(RinexNavigationParser.parseDouble(line, 61, 19));
            }

            @Override
            public void parseFourthBroadcastOrbit(String line, ParseInfo pi) {
                pi.gpsNav.setI0(RinexNavigationParser.parseDouble(line, 4, 19));
                pi.gpsNav.setCrc(RinexNavigationParser.parseDouble(line, 23, 19));
                pi.gpsNav.setPa(RinexNavigationParser.parseDouble(line, 42, 19));
                pi.gpsNav.setOmegaDot(RinexNavigationParser.parseDouble(line, 61, 19));
            }

            @Override
            public void parseFifthBroadcastOrbit(String line, ParseInfo pi) {
                pi.gpsNav.setIDot(RinexNavigationParser.parseDouble(line, 4, 19));
                pi.gpsNav.setWeek((int)RinexNavigationParser.parseDouble(line, 42, 19));
                pi.gpsNav.setDate(new GNSSDate(pi.gpsNav.getWeek(), SEC_TO_MILLI * pi.gpsNav.getTime(), SatelliteSystem.GPS, pi.timeScales).getDate());
            }

            @Override
            public void parseSixthBroadcastOrbit(String line, ParseInfo pi) {
                pi.gpsNav.setSvAccuracy(RinexNavigationParser.parseDouble(line, 4, 19));
                pi.gpsNav.setSvHealth(RinexNavigationParser.parseDouble(line, 23, 19));
                pi.gpsNav.setTGD(RinexNavigationParser.parseDouble(line, 42, 19));
                pi.gpsNav.setIODC(RinexNavigationParser.parseDouble(line, 61, 19));
            }

            @Override
            public void parseSeventhBroadcastOrbit(String line, ParseInfo pi) {
                pi.file.addGPSNavigationMessage(pi.gpsNav);
                pi.gpsNav = new GPSNavigationMessage();
            }
        }
        ,
        GALILEO("E"){

            @Override
            public void parseFirstLine(String line, ParseInfo pi) {
                pi.galileoNav.setPRN(RinexNavigationParser.parseInt(line, 1, 2));
                int galileoTocYear = RinexNavigationParser.parseInt(line, 4, 4);
                int galileoTocMonth = RinexNavigationParser.parseInt(line, 9, 2);
                int galileoTocDay = RinexNavigationParser.parseInt(line, 12, 2);
                int galileoTocHours = RinexNavigationParser.parseInt(line, 15, 2);
                int galileoTocMin = RinexNavigationParser.parseInt(line, 18, 2);
                int galileoTocSec = RinexNavigationParser.parseInt(line, 21, 2);
                pi.galileoNav.setEpochToc(new AbsoluteDate(galileoTocYear, galileoTocMonth, galileoTocDay, galileoTocHours, galileoTocMin, (double)galileoTocSec, (TimeScale)pi.timeScales.getGST()));
                pi.galileoNav.setAf0(RinexNavigationParser.parseDouble(line, 23, 19));
                pi.galileoNav.setAf1(RinexNavigationParser.parseDouble(line, 42, 19));
                pi.galileoNav.setAf2(RinexNavigationParser.parseDouble(line, 61, 19));
            }

            @Override
            public void parseFirstBroadcastOrbit(String line, ParseInfo pi) {
                pi.galileoNav.setIODNav(RinexNavigationParser.parseDouble(line, 4, 19));
                pi.galileoNav.setCrs(RinexNavigationParser.parseDouble(line, 23, 19));
                pi.galileoNav.setDeltaN(RinexNavigationParser.parseDouble(line, 42, 19));
                pi.galileoNav.setM0(RinexNavigationParser.parseDouble(line, 61, 19));
            }

            @Override
            public void parseSecondBroadcastOrbit(String line, ParseInfo pi) {
                pi.galileoNav.setCuc(RinexNavigationParser.parseDouble(line, 4, 19));
                pi.galileoNav.setE(RinexNavigationParser.parseDouble(line, 23, 19));
                pi.galileoNav.setCus(RinexNavigationParser.parseDouble(line, 42, 19));
                pi.galileoNav.setSqrtA(RinexNavigationParser.parseDouble(line, 61, 19));
            }

            @Override
            public void parseThirdBroadcastOrbit(String line, ParseInfo pi) {
                pi.galileoNav.setTime(RinexNavigationParser.parseDouble(line, 4, 19));
                pi.galileoNav.setCic(RinexNavigationParser.parseDouble(line, 23, 19));
                pi.galileoNav.setOmega0(RinexNavigationParser.parseDouble(line, 42, 19));
                pi.galileoNav.setCis(RinexNavigationParser.parseDouble(line, 61, 19));
            }

            @Override
            public void parseFourthBroadcastOrbit(String line, ParseInfo pi) {
                pi.galileoNav.setI0(RinexNavigationParser.parseDouble(line, 4, 19));
                pi.galileoNav.setCrc(RinexNavigationParser.parseDouble(line, 23, 19));
                pi.galileoNav.setPa(RinexNavigationParser.parseDouble(line, 42, 19));
                pi.galileoNav.setOmegaDot(RinexNavigationParser.parseDouble(line, 61, 19));
            }

            @Override
            public void parseFifthBroadcastOrbit(String line, ParseInfo pi) {
                pi.galileoNav.setIDot(RinexNavigationParser.parseDouble(line, 4, 19));
                pi.galileoNav.setWeek((int)RinexNavigationParser.parseDouble(line, 42, 19));
                pi.galileoNav.setDate(new GNSSDate(pi.galileoNav.getWeek(), SEC_TO_MILLI * pi.galileoNav.getTime(), SatelliteSystem.GALILEO, pi.timeScales).getDate());
            }

            @Override
            public void parseSixthBroadcastOrbit(String line, ParseInfo pi) {
                pi.galileoNav.setSisa(RinexNavigationParser.parseDouble(line, 4, 19));
                pi.galileoNav.setSvHealth(RinexNavigationParser.parseDouble(line, 23, 19));
                pi.galileoNav.setBGDE1E5a(RinexNavigationParser.parseDouble(line, 42, 19));
                pi.galileoNav.setBGDE5bE1(RinexNavigationParser.parseDouble(line, 61, 19));
            }

            @Override
            public void parseSeventhBroadcastOrbit(String line, ParseInfo pi) {
                pi.file.addGalileoNavigationMessage(pi.galileoNav);
                pi.galileoNav = new GalileoNavigationMessage();
            }
        }
        ,
        BEIDOU("C"){

            @Override
            public void parseFirstLine(String line, ParseInfo pi) {
                pi.beidouNav.setPRN(RinexNavigationParser.parseInt(line, 1, 2));
                int beidouTocYear = RinexNavigationParser.parseInt(line, 4, 4);
                int beidouTocMonth = RinexNavigationParser.parseInt(line, 9, 2);
                int beidouTocDay = RinexNavigationParser.parseInt(line, 12, 2);
                int beidouTocHours = RinexNavigationParser.parseInt(line, 15, 2);
                int beidouTocMin = RinexNavigationParser.parseInt(line, 18, 2);
                int beidouTocSec = RinexNavigationParser.parseInt(line, 21, 2);
                pi.beidouNav.setEpochToc(new AbsoluteDate(beidouTocYear, beidouTocMonth, beidouTocDay, beidouTocHours, beidouTocMin, (double)beidouTocSec, (TimeScale)pi.timeScales.getBDT()));
                pi.beidouNav.setAf0(RinexNavigationParser.parseDouble(line, 23, 19));
                pi.beidouNav.setAf1(RinexNavigationParser.parseDouble(line, 42, 19));
                pi.beidouNav.setAf2(RinexNavigationParser.parseDouble(line, 61, 19));
            }

            @Override
            public void parseFirstBroadcastOrbit(String line, ParseInfo pi) {
                pi.beidouNav.setAODE(RinexNavigationParser.parseDouble(line, 4, 19));
                pi.beidouNav.setCrs(RinexNavigationParser.parseDouble(line, 23, 19));
                pi.beidouNav.setDeltaN(RinexNavigationParser.parseDouble(line, 42, 19));
                pi.beidouNav.setM0(RinexNavigationParser.parseDouble(line, 61, 19));
            }

            @Override
            public void parseSecondBroadcastOrbit(String line, ParseInfo pi) {
                pi.beidouNav.setCuc(RinexNavigationParser.parseDouble(line, 4, 19));
                pi.beidouNav.setE(RinexNavigationParser.parseDouble(line, 23, 19));
                pi.beidouNav.setCus(RinexNavigationParser.parseDouble(line, 42, 19));
                pi.beidouNav.setSqrtA(RinexNavigationParser.parseDouble(line, 61, 19));
            }

            @Override
            public void parseThirdBroadcastOrbit(String line, ParseInfo pi) {
                pi.beidouNav.setTime(RinexNavigationParser.parseDouble(line, 4, 19));
                pi.beidouNav.setCic(RinexNavigationParser.parseDouble(line, 23, 19));
                pi.beidouNav.setOmega0(RinexNavigationParser.parseDouble(line, 42, 19));
                pi.beidouNav.setCis(RinexNavigationParser.parseDouble(line, 61, 19));
            }

            @Override
            public void parseFourthBroadcastOrbit(String line, ParseInfo pi) {
                pi.beidouNav.setI0(RinexNavigationParser.parseDouble(line, 4, 19));
                pi.beidouNav.setCrc(RinexNavigationParser.parseDouble(line, 23, 19));
                pi.beidouNav.setPa(RinexNavigationParser.parseDouble(line, 42, 19));
                pi.beidouNav.setOmegaDot(RinexNavigationParser.parseDouble(line, 61, 19));
            }

            @Override
            public void parseFifthBroadcastOrbit(String line, ParseInfo pi) {
                pi.beidouNav.setIDot(RinexNavigationParser.parseDouble(line, 4, 19));
                pi.beidouNav.setWeek((int)RinexNavigationParser.parseDouble(line, 42, 19));
                pi.beidouNav.setDate(new GNSSDate(pi.beidouNav.getWeek(), SEC_TO_MILLI * pi.beidouNav.getTime(), SatelliteSystem.BEIDOU, pi.timeScales).getDate());
            }

            @Override
            public void parseSixthBroadcastOrbit(String line, ParseInfo pi) {
                pi.beidouNav.setSvAccuracy(RinexNavigationParser.parseDouble(line, 4, 19));
                pi.beidouNav.setTGD1(RinexNavigationParser.parseDouble(line, 42, 19));
                pi.beidouNav.setTGD2(RinexNavigationParser.parseDouble(line, 61, 19));
            }

            @Override
            public void parseSeventhBroadcastOrbit(String line, ParseInfo pi) {
                pi.beidouNav.setAODC(RinexNavigationParser.parseDouble(line, 23, 19));
                pi.file.addBeidouNavigationMessage(pi.beidouNav);
                pi.beidouNav = new BeidouNavigationMessage();
            }
        }
        ,
        QZSS("J"){

            @Override
            public void parseFirstLine(String line, ParseInfo pi) {
                pi.qzssNav.setPRN(RinexNavigationParser.parseInt(line, 1, 2));
                int qzssTocYear = RinexNavigationParser.parseInt(line, 4, 4);
                int qzssTocMonth = RinexNavigationParser.parseInt(line, 9, 2);
                int qzssTocDay = RinexNavigationParser.parseInt(line, 12, 2);
                int qzssTocHours = RinexNavigationParser.parseInt(line, 15, 2);
                int qzssTocMin = RinexNavigationParser.parseInt(line, 18, 2);
                int qzssTocSec = RinexNavigationParser.parseInt(line, 21, 2);
                pi.qzssNav.setEpochToc(new AbsoluteDate(qzssTocYear, qzssTocMonth, qzssTocDay, qzssTocHours, qzssTocMin, (double)qzssTocSec, (TimeScale)pi.timeScales.getQZSS()));
                pi.qzssNav.setAf0(RinexNavigationParser.parseDouble(line, 23, 19));
                pi.qzssNav.setAf1(RinexNavigationParser.parseDouble(line, 42, 19));
                pi.qzssNav.setAf2(RinexNavigationParser.parseDouble(line, 61, 19));
            }

            @Override
            public void parseFirstBroadcastOrbit(String line, ParseInfo pi) {
                pi.qzssNav.setIODE(RinexNavigationParser.parseDouble(line, 4, 19));
                pi.qzssNav.setCrs(RinexNavigationParser.parseDouble(line, 23, 19));
                pi.qzssNav.setDeltaN(RinexNavigationParser.parseDouble(line, 42, 19));
                pi.qzssNav.setM0(RinexNavigationParser.parseDouble(line, 61, 19));
            }

            @Override
            public void parseSecondBroadcastOrbit(String line, ParseInfo pi) {
                pi.qzssNav.setCuc(RinexNavigationParser.parseDouble(line, 4, 19));
                pi.qzssNav.setE(RinexNavigationParser.parseDouble(line, 23, 19));
                pi.qzssNav.setCus(RinexNavigationParser.parseDouble(line, 42, 19));
                pi.qzssNav.setSqrtA(RinexNavigationParser.parseDouble(line, 61, 19));
            }

            @Override
            public void parseThirdBroadcastOrbit(String line, ParseInfo pi) {
                pi.qzssNav.setTime(RinexNavigationParser.parseDouble(line, 4, 19));
                pi.qzssNav.setCic(RinexNavigationParser.parseDouble(line, 23, 19));
                pi.qzssNav.setOmega0(RinexNavigationParser.parseDouble(line, 42, 19));
                pi.qzssNav.setCis(RinexNavigationParser.parseDouble(line, 61, 19));
            }

            @Override
            public void parseFourthBroadcastOrbit(String line, ParseInfo pi) {
                pi.qzssNav.setI0(RinexNavigationParser.parseDouble(line, 4, 19));
                pi.qzssNav.setCrc(RinexNavigationParser.parseDouble(line, 23, 19));
                pi.qzssNav.setPa(RinexNavigationParser.parseDouble(line, 42, 19));
                pi.qzssNav.setOmegaDot(RinexNavigationParser.parseDouble(line, 61, 19));
            }

            @Override
            public void parseFifthBroadcastOrbit(String line, ParseInfo pi) {
                pi.qzssNav.setIDot(RinexNavigationParser.parseDouble(line, 4, 19));
                pi.qzssNav.setWeek((int)RinexNavigationParser.parseDouble(line, 42, 19));
                pi.qzssNav.setDate(new GNSSDate(pi.qzssNav.getWeek(), SEC_TO_MILLI * pi.qzssNav.getTime(), SatelliteSystem.QZSS, pi.timeScales).getDate());
            }

            @Override
            public void parseSixthBroadcastOrbit(String line, ParseInfo pi) {
                pi.qzssNav.setSvAccuracy(RinexNavigationParser.parseDouble(line, 4, 19));
                pi.qzssNav.setSvHealth(RinexNavigationParser.parseDouble(line, 23, 19));
                pi.qzssNav.setTGD(RinexNavigationParser.parseDouble(line, 42, 19));
                pi.qzssNav.setIODC(RinexNavigationParser.parseDouble(line, 61, 19));
            }

            @Override
            public void parseSeventhBroadcastOrbit(String line, ParseInfo pi) {
                pi.file.addQZSSNavigationMessage(pi.qzssNav);
                pi.qzssNav = new QZSSNavigationMessage();
            }
        }
        ,
        IRNSS("I"){

            @Override
            public void parseFirstLine(String line, ParseInfo pi) {
                pi.irnssNav.setPRN(RinexNavigationParser.parseInt(line, 1, 2));
                int irnssTocYear = RinexNavigationParser.parseInt(line, 4, 4);
                int irnssTocMonth = RinexNavigationParser.parseInt(line, 9, 2);
                int irnssTocDay = RinexNavigationParser.parseInt(line, 12, 2);
                int irnssTocHours = RinexNavigationParser.parseInt(line, 15, 2);
                int irnssTocMin = RinexNavigationParser.parseInt(line, 18, 2);
                int irnssTocSec = RinexNavigationParser.parseInt(line, 21, 2);
                pi.irnssNav.setEpochToc(new AbsoluteDate(irnssTocYear, irnssTocMonth, irnssTocDay, irnssTocHours, irnssTocMin, (double)irnssTocSec, (TimeScale)pi.timeScales.getIRNSS()));
                pi.irnssNav.setAf0(RinexNavigationParser.parseDouble(line, 23, 19));
                pi.irnssNav.setAf1(RinexNavigationParser.parseDouble(line, 42, 19));
                pi.irnssNav.setAf2(RinexNavigationParser.parseDouble(line, 61, 19));
            }

            @Override
            public void parseFirstBroadcastOrbit(String line, ParseInfo pi) {
                pi.irnssNav.setIODEC(RinexNavigationParser.parseDouble(line, 4, 19));
                pi.irnssNav.setCrs(RinexNavigationParser.parseDouble(line, 23, 19));
                pi.irnssNav.setDeltaN(RinexNavigationParser.parseDouble(line, 42, 19));
                pi.irnssNav.setM0(RinexNavigationParser.parseDouble(line, 61, 19));
            }

            @Override
            public void parseSecondBroadcastOrbit(String line, ParseInfo pi) {
                pi.irnssNav.setCuc(RinexNavigationParser.parseDouble(line, 4, 19));
                pi.irnssNav.setE(RinexNavigationParser.parseDouble(line, 23, 19));
                pi.irnssNav.setCus(RinexNavigationParser.parseDouble(line, 42, 19));
                pi.irnssNav.setSqrtA(RinexNavigationParser.parseDouble(line, 61, 19));
            }

            @Override
            public void parseThirdBroadcastOrbit(String line, ParseInfo pi) {
                pi.irnssNav.setTime(RinexNavigationParser.parseDouble(line, 4, 19));
                pi.irnssNav.setCic(RinexNavigationParser.parseDouble(line, 23, 19));
                pi.irnssNav.setOmega0(RinexNavigationParser.parseDouble(line, 42, 19));
                pi.irnssNav.setCis(RinexNavigationParser.parseDouble(line, 61, 19));
            }

            @Override
            public void parseFourthBroadcastOrbit(String line, ParseInfo pi) {
                pi.irnssNav.setI0(RinexNavigationParser.parseDouble(line, 4, 19));
                pi.irnssNav.setCrc(RinexNavigationParser.parseDouble(line, 23, 19));
                pi.irnssNav.setPa(RinexNavigationParser.parseDouble(line, 42, 19));
                pi.irnssNav.setOmegaDot(RinexNavigationParser.parseDouble(line, 61, 19));
            }

            @Override
            public void parseFifthBroadcastOrbit(String line, ParseInfo pi) {
                pi.irnssNav.setIDot(RinexNavigationParser.parseDouble(line, 4, 19));
                pi.irnssNav.setWeek((int)RinexNavigationParser.parseDouble(line, 42, 19));
                pi.irnssNav.setDate(new GNSSDate(pi.irnssNav.getWeek(), SEC_TO_MILLI * pi.irnssNav.getTime(), SatelliteSystem.IRNSS, pi.timeScales).getDate());
            }

            @Override
            public void parseSixthBroadcastOrbit(String line, ParseInfo pi) {
                pi.irnssNav.setURA(RinexNavigationParser.parseDouble(line, 4, 19));
                pi.irnssNav.setSvHealth(RinexNavigationParser.parseDouble(line, 23, 19));
                pi.irnssNav.setTGD(RinexNavigationParser.parseDouble(line, 42, 19));
            }

            @Override
            public void parseSeventhBroadcastOrbit(String line, ParseInfo pi) {
                pi.file.addIRNSSNavigationMessage(pi.irnssNav);
                pi.irnssNav = new IRNSSNavigationMessage();
            }
        }
        ,
        GLONASS("R"){

            @Override
            public void parseFirstLine(String line, ParseInfo pi) {
                pi.glonassNav.setPRN(RinexNavigationParser.parseInt(line, 1, 2));
                int glonassTocYear = RinexNavigationParser.parseInt(line, 4, 4);
                int glonassTocMonth = RinexNavigationParser.parseInt(line, 9, 2);
                int glonassTocDay = RinexNavigationParser.parseInt(line, 12, 2);
                int glonassTocHours = RinexNavigationParser.parseInt(line, 15, 2);
                int glonassTocMin = RinexNavigationParser.parseInt(line, 18, 2);
                int glonassTocSec = RinexNavigationParser.parseInt(line, 21, 2);
                AbsoluteDate date = new AbsoluteDate(glonassTocYear, glonassTocMonth, glonassTocDay, glonassTocHours, glonassTocMin, (double)glonassTocSec, (TimeScale)pi.timeScales.getUTC());
                GNSSDate gpsEpoch = new GNSSDate(date, SatelliteSystem.GPS, pi.timeScales);
                double secInWeek = FastMath.floor((double)((0.001 * gpsEpoch.getMilliInWeek() + 450.0) / 900.0)) * 900.0;
                AbsoluteDate rounded = new GNSSDate(gpsEpoch.getWeekNumber(), SEC_TO_MILLI * secInWeek, SatelliteSystem.GPS, pi.timeScales).getDate();
                pi.glonassNav.setEpochToc(rounded);
                pi.glonassNav.setTauN(-RinexNavigationParser.parseDouble(line, 23, 19));
                pi.glonassNav.setGammaN(RinexNavigationParser.parseDouble(line, 42, 19));
                pi.glonassNav.setDate(rounded);
                pi.glonassNav.setTime(SatelliteSystemLineParser.fmod(RinexNavigationParser.parseDouble(line, 61, 19), 86400.0));
            }

            @Override
            public void parseFirstBroadcastOrbit(String line, ParseInfo pi) {
                pi.glonassNav.setX(RinexNavigationParser.parseDouble(line, 4, 19) * KM_TO_M);
                pi.glonassNav.setXDot(RinexNavigationParser.parseDouble(line, 23, 19) * KM_TO_M);
                pi.glonassNav.setXDotDot(RinexNavigationParser.parseDouble(line, 42, 19) * KM_TO_M);
                pi.glonassNav.setHealth(RinexNavigationParser.parseDouble(line, 61, 19));
            }

            @Override
            public void parseSecondBroadcastOrbit(String line, ParseInfo pi) {
                pi.glonassNav.setY(RinexNavigationParser.parseDouble(line, 4, 19) * KM_TO_M);
                pi.glonassNav.setYDot(RinexNavigationParser.parseDouble(line, 23, 19) * KM_TO_M);
                pi.glonassNav.setYDotDot(RinexNavigationParser.parseDouble(line, 42, 19) * KM_TO_M);
                pi.glonassNav.setFrequencyNumber(RinexNavigationParser.parseDouble(line, 61, 19));
            }

            @Override
            public void parseThirdBroadcastOrbit(String line, ParseInfo pi) {
                pi.glonassNav.setZ(RinexNavigationParser.parseDouble(line, 4, 19) * KM_TO_M);
                pi.glonassNav.setZDot(RinexNavigationParser.parseDouble(line, 23, 19) * KM_TO_M);
                pi.glonassNav.setZDotDot(RinexNavigationParser.parseDouble(line, 42, 19) * KM_TO_M);
                pi.file.addGlonassNavigationMessage(pi.glonassNav);
                pi.glonassNav = new GLONASSNavigationMessage();
            }

            @Override
            public void parseFourthBroadcastOrbit(String line, ParseInfo pi) {
            }

            @Override
            public void parseFifthBroadcastOrbit(String line, ParseInfo pi) {
            }

            @Override
            public void parseSixthBroadcastOrbit(String line, ParseInfo pi) {
            }

            @Override
            public void parseSeventhBroadcastOrbit(String line, ParseInfo pi) {
            }
        }
        ,
        SBAS("S"){

            @Override
            public void parseFirstLine(String line, ParseInfo pi) {
                pi.sbasNav.setPRN(RinexNavigationParser.parseInt(line, 1, 2));
                int sbasTocYear = RinexNavigationParser.parseInt(line, 4, 4);
                int sbasTocMonth = RinexNavigationParser.parseInt(line, 9, 2);
                int sbasTocDay = RinexNavigationParser.parseInt(line, 12, 2);
                int sbasTocHours = RinexNavigationParser.parseInt(line, 15, 2);
                int sbasTocMin = RinexNavigationParser.parseInt(line, 18, 2);
                int sbasTocSec = RinexNavigationParser.parseInt(line, 21, 2);
                TimeScale timeScale = (int)pi.version * 100 == 301 ? pi.timeScales.getUTC() : pi.timeScales.getGPS();
                AbsoluteDate refEpoch = new AbsoluteDate(sbasTocYear, sbasTocMonth, sbasTocDay, sbasTocHours, sbasTocMin, (double)sbasTocSec, timeScale);
                pi.sbasNav.setEpochToc(refEpoch);
                pi.sbasNav.setAGf0(RinexNavigationParser.parseDouble(line, 23, 19));
                pi.sbasNav.setAGf1(RinexNavigationParser.parseDouble(line, 42, 19));
                pi.sbasNav.setTime(RinexNavigationParser.parseDouble(line, 61, 19));
                pi.sbasNav.setDate(refEpoch);
            }

            @Override
            public void parseFirstBroadcastOrbit(String line, ParseInfo pi) {
                pi.sbasNav.setX(RinexNavigationParser.parseDouble(line, 4, 19) * KM_TO_M);
                pi.sbasNav.setXDot(RinexNavigationParser.parseDouble(line, 23, 19) * KM_TO_M);
                pi.sbasNav.setXDotDot(RinexNavigationParser.parseDouble(line, 42, 19) * KM_TO_M);
                pi.sbasNav.setHealth(RinexNavigationParser.parseDouble(line, 61, 19));
            }

            @Override
            public void parseSecondBroadcastOrbit(String line, ParseInfo pi) {
                pi.sbasNav.setY(RinexNavigationParser.parseDouble(line, 4, 19) * KM_TO_M);
                pi.sbasNav.setYDot(RinexNavigationParser.parseDouble(line, 23, 19) * KM_TO_M);
                pi.sbasNav.setYDotDot(RinexNavigationParser.parseDouble(line, 42, 19) * KM_TO_M);
                pi.sbasNav.setURA(RinexNavigationParser.parseDouble(line, 61, 19));
            }

            @Override
            public void parseThirdBroadcastOrbit(String line, ParseInfo pi) {
                pi.sbasNav.setZ(RinexNavigationParser.parseDouble(line, 4, 19) * KM_TO_M);
                pi.sbasNav.setZDot(RinexNavigationParser.parseDouble(line, 23, 19) * KM_TO_M);
                pi.sbasNav.setZDotDot(RinexNavigationParser.parseDouble(line, 42, 19) * KM_TO_M);
                pi.sbasNav.setIODN(RinexNavigationParser.parseDouble(line, 61, 19));
                pi.file.addSBASNavigationMessage(pi.sbasNav);
                pi.sbasNav = new SBASNavigationMessage();
            }

            @Override
            public void parseFourthBroadcastOrbit(String line, ParseInfo pi) {
            }

            @Override
            public void parseFifthBroadcastOrbit(String line, ParseInfo pi) {
            }

            @Override
            public void parseSixthBroadcastOrbit(String line, ParseInfo pi) {
            }

            @Override
            public void parseSeventhBroadcastOrbit(String line, ParseInfo pi) {
            }
        };

        private static final Map<String, SatelliteSystemLineParser> KEYS_MAP;
        private String key;

        private SatelliteSystemLineParser(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }

        public static SatelliteSystemLineParser getSatelliteSystemLineParser(String s) {
            return KEYS_MAP.get(s);
        }

        public abstract void parseFirstLine(String var1, ParseInfo var2);

        public abstract void parseFirstBroadcastOrbit(String var1, ParseInfo var2);

        public abstract void parseSecondBroadcastOrbit(String var1, ParseInfo var2);

        public abstract void parseThirdBroadcastOrbit(String var1, ParseInfo var2);

        public abstract void parseFourthBroadcastOrbit(String var1, ParseInfo var2);

        public abstract void parseFifthBroadcastOrbit(String var1, ParseInfo var2);

        public abstract void parseSixthBroadcastOrbit(String var1, ParseInfo var2);

        public abstract void parseSeventhBroadcastOrbit(String var1, ParseInfo var2);

        private static double fmod(double a, double b) {
            double x = (int)(a / b);
            return a - x * b;
        }

        static {
            KEYS_MAP = new HashMap<String, SatelliteSystemLineParser>();
            for (SatelliteSystemLineParser satelliteSystem : SatelliteSystemLineParser.values()) {
                KEYS_MAP.put(satelliteSystem.getKey(), satelliteSystem);
            }
        }
    }

    private static enum LineParser {
        HEADER_VERSION("^.+RINEX VERSION / TYPE( )*$"){

            @Override
            public void parse(String line, ParseInfo pi) {
                pi.version = RinexNavigationParser.parseDouble(line, 0, 9);
                if (!HANDLED_VERSIONS.contains(pi.version)) {
                    throw new OrekitException((Localizable)OrekitMessages.NAVIGATION_FILE_UNSUPPORTED_VERSION, pi.version);
                }
                pi.file.setFormatVersion(pi.version);
                pi.file.setFileType(RinexNavigationParser.FILE_TYPE);
                SatelliteSystem system = SatelliteSystem.parseSatelliteSystem(RinexNavigationParser.parseString(line, 40, 1));
                pi.file.setSatelliteSystem(system);
            }

            @Override
            public Stream<LineParser> allowedNext() {
                return Stream.of(HEADER_PROGRAM);
            }
        }
        ,
        HEADER_PROGRAM("^.+PGM / RUN BY / DATE( )*$"){

            @Override
            public void parse(String line, ParseInfo pi) {
                String programName = RinexNavigationParser.parseString(line, 0, 20);
                pi.file.setProgramName(programName);
                String agencyName = RinexNavigationParser.parseString(line, 20, 20);
                pi.file.setAgencyName(agencyName);
                String date = RinexNavigationParser.parseString(line, 40, 8);
                String time = RinexNavigationParser.parseString(line, 49, 6);
                String timeZone = RinexNavigationParser.parseString(line, 56, 4);
                pi.file.setCreationDateString(date);
                pi.file.setCreationTimeString(time);
                pi.file.setCreationTimeZoneString(timeZone);
                DateComponents dateComponents = new DateComponents(RinexNavigationParser.parseInt(date, 0, 4), RinexNavigationParser.parseInt(date, 4, 2), RinexNavigationParser.parseInt(date, 6, 2));
                TimeComponents timeComponents = new TimeComponents(RinexNavigationParser.parseInt(time, 0, 2), RinexNavigationParser.parseInt(time, 2, 2), RinexNavigationParser.parseInt(time, 4, 2));
                pi.file.setCreationDate(new AbsoluteDate(dateComponents, timeComponents, TimeSystem.parseTimeSystem(timeZone).getTimeScale(pi.timeScales)));
            }

            @Override
            public Stream<LineParser> allowedNext() {
                return Stream.of(HEADER_COMMENT, HEADER_IONOSPHERIC, HEADER_TIME, HEADER_LEAP_SECONDS, HEADER_END);
            }
        }
        ,
        HEADER_COMMENT("^.+COMMENT( )*$"){

            @Override
            public void parse(String line, ParseInfo pi) {
                pi.file.addComment(RinexNavigationParser.parseString(line, 0, 60));
            }

            @Override
            public Stream<LineParser> allowedNext() {
                return Stream.of(HEADER_COMMENT, HEADER_IONOSPHERIC, HEADER_TIME, HEADER_LEAP_SECONDS, HEADER_END);
            }
        }
        ,
        HEADER_IONOSPHERIC("^.+IONOSPHERIC CORR( )*$"){

            @Override
            public void parse(String line, ParseInfo pi) {
                String ionoType = RinexNavigationParser.parseString(line, 0, 3);
                pi.file.setIonosphericCorrectionType(ionoType);
                double[] parameters = new double[]{RinexNavigationParser.parseDouble(line, 5, 12), RinexNavigationParser.parseDouble(line, 17, 12), RinexNavigationParser.parseDouble(line, 29, 12), RinexNavigationParser.parseDouble(line, 41, 12)};
                if ("GAL".equals(ionoType)) {
                    pi.file.setNeQuickAlpha(parameters);
                } else if (pi.isIonosphereAlphaInitialized) {
                    pi.file.setKlobucharBeta(parameters);
                } else {
                    pi.file.setKlobucharAlpha(parameters);
                    pi.isIonosphereAlphaInitialized = true;
                }
            }

            @Override
            public Stream<LineParser> allowedNext() {
                return Stream.of(HEADER_COMMENT, HEADER_IONOSPHERIC, HEADER_TIME, HEADER_LEAP_SECONDS, HEADER_END);
            }
        }
        ,
        HEADER_TIME("^.+TIME SYSTEM CORR( )*$"){

            @Override
            public void parse(String line, ParseInfo pi) {
                String type = RinexNavigationParser.parseString(line, 0, 4);
                double a0 = RinexNavigationParser.parseDouble(line, 5, 17);
                double a1 = RinexNavigationParser.parseDouble(line, 22, 16);
                int refTime = RinexNavigationParser.parseInt(line, 38, 7);
                int refWeek = RinexNavigationParser.parseInt(line, 46, 5);
                RinexNavigation.TimeSystemCorrection tsc = new RinexNavigation.TimeSystemCorrection(type, a0, a1, refTime, refWeek);
                pi.file.addTimeSystemCorrections(tsc);
            }

            @Override
            public Stream<LineParser> allowedNext() {
                return Stream.of(HEADER_COMMENT, HEADER_TIME, HEADER_LEAP_SECONDS, HEADER_END);
            }
        }
        ,
        HEADER_LEAP_SECONDS("^.+LEAP SECONDS( )*$"){

            @Override
            public void parse(String line, ParseInfo pi) {
                pi.file.setNumberOfLeapSeconds(RinexNavigationParser.parseInt(line, 0, 6));
            }

            @Override
            public Stream<LineParser> allowedNext() {
                return Stream.of(HEADER_COMMENT, HEADER_IONOSPHERIC, HEADER_TIME, HEADER_END);
            }
        }
        ,
        HEADER_END("^.+END OF HEADER( )*$"){

            @Override
            public void parse(String line, ParseInfo pi) {
            }

            @Override
            public Stream<LineParser> allowedNext() {
                return Stream.of(NAVIGATION_MESSAGE_FIRST);
            }
        }
        ,
        NAVIGATION_MESSAGE_FIRST("(^G|^R|^E|^C|^I|^J|^S).+$"){

            @Override
            public void parse(String line, ParseInfo pi) {
                pi.lineNumber = 0;
                String key = RinexNavigationParser.parseString(line, 0, 1);
                pi.systemLineParser = SatelliteSystemLineParser.getSatelliteSystemLineParser(key);
                pi.systemLineParser.parseFirstLine(line, pi);
            }

            @Override
            public Stream<LineParser> allowedNext() {
                return Stream.of(NAVIGATION_BROADCAST_ORBIT);
            }
        }
        ,
        NAVIGATION_BROADCAST_ORBIT("^    .+"){

            @Override
            public void parse(String line, ParseInfo pi) {
                pi.lineNumber++;
                if (pi.lineNumber == 1) {
                    pi.systemLineParser.parseFirstBroadcastOrbit(line, pi);
                } else if (pi.lineNumber == 2) {
                    pi.systemLineParser.parseSecondBroadcastOrbit(line, pi);
                } else if (pi.lineNumber == 3) {
                    pi.systemLineParser.parseThirdBroadcastOrbit(line, pi);
                } else if (pi.lineNumber == 4) {
                    pi.systemLineParser.parseFourthBroadcastOrbit(line, pi);
                } else if (pi.lineNumber == 5) {
                    pi.systemLineParser.parseFifthBroadcastOrbit(line, pi);
                } else if (pi.lineNumber == 6) {
                    pi.systemLineParser.parseSixthBroadcastOrbit(line, pi);
                } else {
                    pi.systemLineParser.parseSeventhBroadcastOrbit(line, pi);
                }
            }

            @Override
            public Stream<LineParser> allowedNext() {
                return Stream.of(NAVIGATION_MESSAGE_FIRST, NAVIGATION_BROADCAST_ORBIT);
            }
        };

        private final Pattern pattern;

        private LineParser(String lineRegexp) {
            this.pattern = Pattern.compile(lineRegexp);
        }

        public abstract void parse(String var1, ParseInfo var2);

        public abstract Stream<LineParser> allowedNext();

        public boolean canHandle(String line) {
            return this.pattern.matcher(line).matches();
        }
    }

    private class ParseInfo {
        private final TimeScales timeScales;
        private RinexNavigation file;
        private double version;
        private boolean isIonosphereAlphaInitialized;
        private SatelliteSystemLineParser systemLineParser;
        private int lineNumber;
        private GPSNavigationMessage gpsNav;
        private GalileoNavigationMessage galileoNav;
        private BeidouNavigationMessage beidouNav;
        private QZSSNavigationMessage qzssNav;
        private IRNSSNavigationMessage irnssNav;
        private GLONASSNavigationMessage glonassNav;
        private SBASNavigationMessage sbasNav;

        ParseInfo() {
            this.timeScales = RinexNavigationParser.this.timeScales;
            this.version = 1.0;
            this.isIonosphereAlphaInitialized = false;
            this.file = new RinexNavigation();
            this.systemLineParser = SatelliteSystemLineParser.GPS;
            this.lineNumber = 0;
            this.gpsNav = new GPSNavigationMessage();
            this.galileoNav = new GalileoNavigationMessage();
            this.beidouNav = new BeidouNavigationMessage();
            this.qzssNav = new QZSSNavigationMessage();
            this.irnssNav = new IRNSSNavigationMessage();
            this.glonassNav = new GLONASSNavigationMessage();
            this.sbasNav = new SBASNavigationMessage();
        }
    }
}

