/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.gnss.metric.parser;

import java.util.List;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.gnss.metric.messages.ParsedMessage;
import org.orekit.gnss.metric.parser.EncodedMessage;
import org.orekit.gnss.metric.parser.MessageType;

public abstract class MessagesParser {
    private final List<Integer> messages;

    public MessagesParser(List<Integer> messages) {
        this.messages = messages;
    }

    public ParsedMessage parse(EncodedMessage message, boolean ignoreUnknownMessageTypes) {
        try {
            String messageNumberString = this.parseMessageNumber(message);
            int messageNumberInt = Integer.parseInt(messageNumberString);
            MessageType messageType = this.getMessageType(messageNumberString);
            if (this.messages.contains(0)) {
                return messageType.parse(message, messageNumberInt);
            }
            return this.messages.contains(messageNumberInt) ? messageType.parse(message, messageNumberInt) : null;
        }
        catch (OrekitException oe) {
            if (ignoreUnknownMessageTypes && oe.getSpecifier() == OrekitMessages.UNKNOWN_ENCODED_MESSAGE_NUMBER) {
                return null;
            }
            throw oe;
        }
    }

    protected abstract String parseMessageNumber(EncodedMessage var1);

    protected abstract MessageType getMessageType(String var1);
}

