/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.gnss.metric.ntrip;

import java.util.ArrayList;
import java.util.List;
import org.orekit.gnss.metric.ntrip.CasterRecord;
import org.orekit.gnss.metric.ntrip.DataStreamRecord;
import org.orekit.gnss.metric.ntrip.NetworkRecord;

public class SourceTable {
    private final String ntripFlags;
    private final List<CasterRecord> casters;
    private final List<NetworkRecord> networks;
    private final List<DataStreamRecord> dataStreams;

    SourceTable(String ntripFlags) {
        this.ntripFlags = ntripFlags;
        this.casters = new ArrayList<CasterRecord>();
        this.networks = new ArrayList<NetworkRecord>();
        this.dataStreams = new ArrayList<DataStreamRecord>();
    }

    void addCasterRecord(CasterRecord caster) {
        this.casters.add(caster);
    }

    void addNetworkRecord(NetworkRecord network) {
        this.networks.add(network);
    }

    void addDataStreamRecord(DataStreamRecord dataStream) {
        this.dataStreams.add(dataStream);
    }

    public String getNtripFlags() {
        return this.ntripFlags;
    }

    public List<CasterRecord> getCasters() {
        return this.casters;
    }

    public List<NetworkRecord> getNetworks() {
        return this.networks;
    }

    public List<DataStreamRecord> getDataStreams() {
        return this.dataStreams;
    }
}

