/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.gnss.attitude;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathUtils;
import org.orekit.frames.Frame;
import org.orekit.gnss.attitude.AbstractGNSSAttitudeProvider;
import org.orekit.gnss.attitude.GNSSAttitudeContext;
import org.orekit.gnss.attitude.GNSSFieldAttitudeContext;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.TimeShiftable;
import org.orekit.utils.ExtendedPVCoordinatesProvider;
import org.orekit.utils.TimeStampedAngularCoordinates;
import org.orekit.utils.TimeStampedFieldAngularCoordinates;

public class BeidouMeo
extends AbstractGNSSAttitudeProvider {
    private static final double BETA_YS_ON = FastMath.toRadians((double)4.1);
    private static final double BETA_ON_YS = FastMath.toRadians((double)3.9);

    public BeidouMeo(AbsoluteDate validityStart, AbsoluteDate validityEnd, ExtendedPVCoordinatesProvider sun, Frame inertialFrame) {
        super(validityStart, validityEnd, sun, inertialFrame);
    }

    @Override
    protected TimeStampedAngularCoordinates correctedYaw(GNSSAttitudeContext context) {
        boolean absBetaDecreasing;
        double beta = context.beta(context.getDate());
        double approxPeriod = Math.PI * 2 / context.getMuRate();
        double betaVariation = beta - context.beta(context.getDate().shiftedBy(-approxPeriod));
        double delta = context.getOrbitAngleSinceMidnight();
        if (FastMath.abs((double)beta) <= BETA_YS_ON - FastMath.abs((double)betaVariation)) {
            return context.orbitNormalYaw();
        }
        if (FastMath.abs((double)beta) > BETA_ON_YS + FastMath.abs((double)betaVariation)) {
            return context.nominalYaw(context.getDate());
        }
        boolean bl = absBetaDecreasing = beta * betaVariation <= 0.0;
        if (absBetaDecreasing) {
            if (FastMath.abs((double)beta) >= BETA_YS_ON) {
                return context.nominalYaw(context.getDate());
            }
        } else if (FastMath.abs((double)beta) <= BETA_ON_YS) {
            return context.orbitNormalYaw();
        }
        double angleSinceQuadrature = MathUtils.normalizeAngle((double)(delta - 1.5707963267948966), (double)Math.PI);
        double timeSinceQuadrature = angleSinceQuadrature / context.getMuRate();
        AbsoluteDate quadratureDate = context.getDate().shiftedBy(-timeSinceQuadrature);
        double betaQuadrature = context.beta(quadratureDate);
        if (absBetaDecreasing ? FastMath.abs((double)betaQuadrature) <= BETA_YS_ON : FastMath.abs((double)betaQuadrature) <= BETA_ON_YS) {
            return context.orbitNormalYaw();
        }
        return context.nominalYaw(context.getDate());
    }

    @Override
    protected <T extends CalculusFieldElement<T>> TimeStampedFieldAngularCoordinates<T> correctedYaw(GNSSFieldAttitudeContext<T> context) {
        boolean absBetaDecreasing;
        double beta = context.beta(context.getDate()).getReal();
        double approxPeriod = Math.PI * 2 / context.getMuRate().getReal();
        double betaVariation = beta - context.beta((FieldAbsoluteDate<T>)context.getDate().shiftedBy(-approxPeriod)).getReal();
        double delta = context.getOrbitAngleSinceMidnight().getReal();
        if (FastMath.abs((double)beta) <= BETA_YS_ON - FastMath.abs((double)betaVariation)) {
            return context.orbitNormalYaw();
        }
        if (FastMath.abs((double)beta) > BETA_ON_YS + FastMath.abs((double)betaVariation)) {
            return context.nominalYaw(context.getDate());
        }
        boolean bl = absBetaDecreasing = beta * betaVariation <= 0.0;
        if (absBetaDecreasing) {
            if (FastMath.abs((double)beta) >= BETA_YS_ON) {
                return context.nominalYaw(context.getDate());
            }
        } else if (FastMath.abs((double)beta) <= BETA_ON_YS) {
            return context.orbitNormalYaw();
        }
        double angleSinceQuadrature = MathUtils.normalizeAngle((double)(delta - 1.5707963267948966), (double)Math.PI);
        double timeSinceQuadrature = angleSinceQuadrature / context.getMuRate().getReal();
        TimeShiftable quadratureDate = context.getDate().shiftedBy(-timeSinceQuadrature);
        double betaQuadrature = context.beta((FieldAbsoluteDate<T>)quadratureDate).getReal();
        if (absBetaDecreasing ? FastMath.abs((double)betaQuadrature) <= BETA_YS_ON : FastMath.abs((double)betaQuadrature) <= BETA_ON_YS) {
            return context.orbitNormalYaw();
        }
        return context.nominalYaw(context.getDate());
    }
}

