/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.gnss;

import java.util.HashMap;
import java.util.Map;
import org.orekit.gnss.Frequency;
import org.orekit.gnss.MeasurementType;
import org.orekit.gnss.SatelliteSystem;
import org.orekit.gnss.SignalCode;

public enum ObservationType {
    C1(MeasurementType.PSEUDO_RANGE, SignalCode.C, Frequency.G01, Frequency.R01, Frequency.E01, Frequency.S01),
    C2(MeasurementType.PSEUDO_RANGE, SignalCode.C, Frequency.G02, Frequency.R02, Frequency.B02),
    C5(MeasurementType.PSEUDO_RANGE, SignalCode.C, Frequency.G05, Frequency.E05, Frequency.S05),
    C6(MeasurementType.PSEUDO_RANGE, SignalCode.C, Frequency.E06, Frequency.B03),
    C7(MeasurementType.PSEUDO_RANGE, SignalCode.C, Frequency.E07, Frequency.B02),
    C8(MeasurementType.PSEUDO_RANGE, SignalCode.C, Frequency.E08),
    P1(MeasurementType.PSEUDO_RANGE, SignalCode.P, Frequency.G01, Frequency.R01),
    P2(MeasurementType.PSEUDO_RANGE, SignalCode.P, Frequency.G02, Frequency.R02),
    L1(MeasurementType.CARRIER_PHASE, SignalCode.P, Frequency.G01, Frequency.R01, Frequency.E01, Frequency.S01),
    L2(MeasurementType.CARRIER_PHASE, SignalCode.P, Frequency.G02, Frequency.R02, Frequency.B02),
    L5(MeasurementType.CARRIER_PHASE, SignalCode.P, Frequency.G05, Frequency.E05, Frequency.S05),
    L6(MeasurementType.CARRIER_PHASE, SignalCode.P, Frequency.E06, Frequency.C07),
    L7(MeasurementType.CARRIER_PHASE, SignalCode.P, Frequency.E07, Frequency.B02),
    L8(MeasurementType.CARRIER_PHASE, SignalCode.P, Frequency.E08),
    LA(MeasurementType.CARRIER_PHASE, SignalCode.C, Frequency.G01, Frequency.R01),
    LB(MeasurementType.CARRIER_PHASE, SignalCode.L, Frequency.G01),
    LC(MeasurementType.CARRIER_PHASE, SignalCode.L, Frequency.G02),
    LD(MeasurementType.CARRIER_PHASE, SignalCode.C, Frequency.R02),
    D1(MeasurementType.DOPPLER, SignalCode.P, Frequency.G01, Frequency.R01, Frequency.E01, Frequency.S01),
    D2(MeasurementType.DOPPLER, SignalCode.P, Frequency.G02, Frequency.R02, Frequency.B02),
    D5(MeasurementType.DOPPLER, SignalCode.P, Frequency.G05, Frequency.E05, Frequency.S05),
    D6(MeasurementType.DOPPLER, SignalCode.P, Frequency.E06, Frequency.C07),
    D7(MeasurementType.DOPPLER, SignalCode.P, Frequency.E07, Frequency.B02),
    D8(MeasurementType.DOPPLER, SignalCode.P, Frequency.E08),
    S1(MeasurementType.SIGNAL_STRENGTH, SignalCode.P, Frequency.G01, Frequency.R01, Frequency.E01, Frequency.S01),
    S2(MeasurementType.SIGNAL_STRENGTH, SignalCode.P, Frequency.G02, Frequency.R02, Frequency.B02),
    S5(MeasurementType.SIGNAL_STRENGTH, SignalCode.P, Frequency.G05, Frequency.E05, Frequency.S05),
    S6(MeasurementType.SIGNAL_STRENGTH, SignalCode.P, Frequency.E06, Frequency.C07),
    S7(MeasurementType.SIGNAL_STRENGTH, SignalCode.P, Frequency.E07, Frequency.B02),
    S8(MeasurementType.SIGNAL_STRENGTH, SignalCode.P, Frequency.E08),
    C1A(MeasurementType.PSEUDO_RANGE, SignalCode.A, Frequency.E01),
    C1B(MeasurementType.PSEUDO_RANGE, SignalCode.B, Frequency.E01),
    C1C(MeasurementType.PSEUDO_RANGE, SignalCode.C, Frequency.G01, Frequency.R01, Frequency.E01, Frequency.S01, Frequency.J01),
    C1I(MeasurementType.PSEUDO_RANGE, SignalCode.I, Frequency.B01),
    C1L(MeasurementType.PSEUDO_RANGE, SignalCode.L, Frequency.G01, Frequency.J01),
    C1M(MeasurementType.PSEUDO_RANGE, SignalCode.M, Frequency.G01),
    C1P(MeasurementType.PSEUDO_RANGE, SignalCode.P, Frequency.G01, Frequency.R01),
    C1Q(MeasurementType.PSEUDO_RANGE, SignalCode.Q, Frequency.B01),
    C1S(MeasurementType.PSEUDO_RANGE, SignalCode.S, Frequency.G01, Frequency.J01),
    C1W(MeasurementType.PSEUDO_RANGE, SignalCode.W, Frequency.G01),
    C1X(MeasurementType.PSEUDO_RANGE, SignalCode.X, Frequency.G01, Frequency.E01, Frequency.J01),
    C1Y(MeasurementType.PSEUDO_RANGE, SignalCode.Y, Frequency.G01),
    C1Z(MeasurementType.PSEUDO_RANGE, SignalCode.Z, Frequency.E01, Frequency.J01),
    C2C(MeasurementType.PSEUDO_RANGE, SignalCode.C, Frequency.G02, Frequency.R02),
    C2D(MeasurementType.PSEUDO_RANGE, SignalCode.D, Frequency.G02),
    C2I(MeasurementType.PSEUDO_RANGE, SignalCode.I, Frequency.B01),
    C2L(MeasurementType.PSEUDO_RANGE, SignalCode.L, Frequency.G02, Frequency.J02),
    C2M(MeasurementType.PSEUDO_RANGE, SignalCode.M, Frequency.G02),
    C2P(MeasurementType.PSEUDO_RANGE, SignalCode.P, Frequency.G02, Frequency.R02),
    C2Q(MeasurementType.PSEUDO_RANGE, SignalCode.Q, Frequency.B01),
    C2S(MeasurementType.PSEUDO_RANGE, SignalCode.S, Frequency.G02, Frequency.J02),
    C2W(MeasurementType.PSEUDO_RANGE, SignalCode.W, Frequency.G02),
    C2X(MeasurementType.PSEUDO_RANGE, SignalCode.X, Frequency.G02, Frequency.J02),
    C2Y(MeasurementType.PSEUDO_RANGE, SignalCode.Y, Frequency.G02),
    C3I(MeasurementType.PSEUDO_RANGE, SignalCode.I, Frequency.R03),
    C3Q(MeasurementType.PSEUDO_RANGE, SignalCode.Q, Frequency.R03),
    C3X(MeasurementType.PSEUDO_RANGE, SignalCode.X, Frequency.R03),
    C4A(MeasurementType.PSEUDO_RANGE, SignalCode.A, Frequency.R04),
    C4B(MeasurementType.PSEUDO_RANGE, SignalCode.B, Frequency.R04),
    C4X(MeasurementType.PSEUDO_RANGE, SignalCode.X, Frequency.R04),
    C5A(MeasurementType.PSEUDO_RANGE, SignalCode.A, Frequency.I05),
    C5B(MeasurementType.PSEUDO_RANGE, SignalCode.B, Frequency.I05),
    C5C(MeasurementType.PSEUDO_RANGE, SignalCode.C, Frequency.I05),
    C5D(MeasurementType.PSEUDO_RANGE, SignalCode.D, Frequency.J05),
    C5I(MeasurementType.PSEUDO_RANGE, SignalCode.I, Frequency.G05, Frequency.E05, Frequency.S05, Frequency.J05),
    C5P(MeasurementType.PSEUDO_RANGE, SignalCode.P, Frequency.J05),
    C5Q(MeasurementType.PSEUDO_RANGE, SignalCode.Q, Frequency.G05, Frequency.E05, Frequency.S05, Frequency.J05),
    C5X(MeasurementType.PSEUDO_RANGE, SignalCode.X, Frequency.G05, Frequency.E05, Frequency.S05, Frequency.J05, Frequency.I05),
    C5Z(MeasurementType.PSEUDO_RANGE, SignalCode.Z, Frequency.J05),
    C6A(MeasurementType.PSEUDO_RANGE, SignalCode.A, Frequency.E06, Frequency.R06),
    C6B(MeasurementType.PSEUDO_RANGE, SignalCode.B, Frequency.E06, Frequency.R06),
    C6C(MeasurementType.PSEUDO_RANGE, SignalCode.C, Frequency.E06),
    C6E(MeasurementType.PSEUDO_RANGE, SignalCode.E, Frequency.J06),
    C6I(MeasurementType.PSEUDO_RANGE, SignalCode.I, Frequency.B03),
    C6Q(MeasurementType.PSEUDO_RANGE, SignalCode.Q, Frequency.B03),
    C6L(MeasurementType.PSEUDO_RANGE, SignalCode.L, Frequency.J06),
    C6S(MeasurementType.PSEUDO_RANGE, SignalCode.S, Frequency.J06),
    C6X(MeasurementType.PSEUDO_RANGE, SignalCode.X, Frequency.E06, Frequency.J06, Frequency.B03, Frequency.R06),
    C6Z(MeasurementType.PSEUDO_RANGE, SignalCode.Z, Frequency.E06, Frequency.J06),
    C7I(MeasurementType.PSEUDO_RANGE, SignalCode.I, Frequency.E07, Frequency.B02),
    C7Q(MeasurementType.PSEUDO_RANGE, SignalCode.Q, Frequency.E07, Frequency.B02),
    C7X(MeasurementType.PSEUDO_RANGE, SignalCode.X, Frequency.E07, Frequency.B02),
    C8I(MeasurementType.PSEUDO_RANGE, SignalCode.I, Frequency.E08),
    C8Q(MeasurementType.PSEUDO_RANGE, SignalCode.Q, Frequency.E08),
    C8X(MeasurementType.PSEUDO_RANGE, SignalCode.X, Frequency.E08),
    C9A(MeasurementType.PSEUDO_RANGE, SignalCode.A, Frequency.I09),
    C9B(MeasurementType.PSEUDO_RANGE, SignalCode.B, Frequency.I09),
    C9C(MeasurementType.PSEUDO_RANGE, SignalCode.C, Frequency.I09),
    C9X(MeasurementType.PSEUDO_RANGE, SignalCode.X, Frequency.I09),
    C0(MeasurementType.PSEUDO_RANGE, SignalCode.CODELESS, new Frequency[0]),
    CA(MeasurementType.PSEUDO_RANGE, SignalCode.C, Frequency.G01, Frequency.R01),
    CB(MeasurementType.PSEUDO_RANGE, SignalCode.L, Frequency.G01),
    CC(MeasurementType.PSEUDO_RANGE, SignalCode.L, Frequency.G02),
    CD(MeasurementType.PSEUDO_RANGE, SignalCode.C, Frequency.R02),
    D1A(MeasurementType.DOPPLER, SignalCode.A, Frequency.E01),
    D1B(MeasurementType.DOPPLER, SignalCode.B, Frequency.E01),
    D1C(MeasurementType.DOPPLER, SignalCode.C, Frequency.G01, Frequency.R01, Frequency.E01, Frequency.S01, Frequency.J01),
    D1I(MeasurementType.DOPPLER, SignalCode.I, Frequency.B01),
    D1L(MeasurementType.DOPPLER, SignalCode.L, Frequency.G01, Frequency.J01),
    D1M(MeasurementType.DOPPLER, SignalCode.M, Frequency.G02),
    D1N(MeasurementType.DOPPLER, SignalCode.CODELESS, Frequency.G01),
    D1P(MeasurementType.DOPPLER, SignalCode.P, Frequency.G02, Frequency.R02),
    D1S(MeasurementType.DOPPLER, SignalCode.S, Frequency.G01, Frequency.J01),
    D1W(MeasurementType.DOPPLER, SignalCode.W, Frequency.G01),
    D1X(MeasurementType.DOPPLER, SignalCode.X, Frequency.G01, Frequency.E01, Frequency.J01),
    D1Y(MeasurementType.DOPPLER, SignalCode.Y, Frequency.G01),
    D1Z(MeasurementType.DOPPLER, SignalCode.Z, Frequency.E01, Frequency.J01),
    D2C(MeasurementType.DOPPLER, SignalCode.C, Frequency.G02, Frequency.R02),
    D2D(MeasurementType.DOPPLER, SignalCode.D, Frequency.G02),
    D2I(MeasurementType.DOPPLER, SignalCode.I, Frequency.B01),
    D2L(MeasurementType.DOPPLER, SignalCode.L, Frequency.G02, Frequency.J02),
    D2M(MeasurementType.DOPPLER, SignalCode.M, Frequency.G02),
    D2N(MeasurementType.DOPPLER, SignalCode.CODELESS, Frequency.G02),
    D2P(MeasurementType.DOPPLER, SignalCode.P, Frequency.G02, Frequency.R02),
    D2Q(MeasurementType.DOPPLER, SignalCode.Q, Frequency.B01),
    D2S(MeasurementType.DOPPLER, SignalCode.S, Frequency.G02, Frequency.J02),
    D2W(MeasurementType.DOPPLER, SignalCode.W, Frequency.G02),
    D2X(MeasurementType.DOPPLER, SignalCode.X, Frequency.G02, Frequency.J02),
    D2Y(MeasurementType.DOPPLER, SignalCode.Y, Frequency.G02),
    D3I(MeasurementType.DOPPLER, SignalCode.I, Frequency.R03),
    D3Q(MeasurementType.DOPPLER, SignalCode.Q, Frequency.R03),
    D3X(MeasurementType.DOPPLER, SignalCode.X, Frequency.R03),
    D4A(MeasurementType.DOPPLER, SignalCode.A, Frequency.R04),
    D4B(MeasurementType.DOPPLER, SignalCode.B, Frequency.R04),
    D4X(MeasurementType.DOPPLER, SignalCode.X, Frequency.R04),
    D5A(MeasurementType.DOPPLER, SignalCode.A, Frequency.I05),
    D5B(MeasurementType.DOPPLER, SignalCode.B, Frequency.I05),
    D5C(MeasurementType.DOPPLER, SignalCode.C, Frequency.I05),
    D5D(MeasurementType.DOPPLER, SignalCode.D, Frequency.J05),
    D5I(MeasurementType.DOPPLER, SignalCode.I, Frequency.G05, Frequency.E05, Frequency.S05, Frequency.J05),
    D5P(MeasurementType.DOPPLER, SignalCode.P, Frequency.J05),
    D5Q(MeasurementType.DOPPLER, SignalCode.Q, Frequency.G05, Frequency.E05, Frequency.S05, Frequency.J05),
    D5X(MeasurementType.DOPPLER, SignalCode.X, Frequency.G05, Frequency.E05, Frequency.S05, Frequency.J05, Frequency.I05),
    D5Z(MeasurementType.DOPPLER, SignalCode.Z, Frequency.J05),
    D6A(MeasurementType.DOPPLER, SignalCode.A, Frequency.E06, Frequency.R06),
    D6B(MeasurementType.DOPPLER, SignalCode.B, Frequency.E06, Frequency.R06),
    D6C(MeasurementType.DOPPLER, SignalCode.C, Frequency.E06),
    D6E(MeasurementType.DOPPLER, SignalCode.E, Frequency.J06),
    D6I(MeasurementType.DOPPLER, SignalCode.I, Frequency.B03),
    D6Q(MeasurementType.DOPPLER, SignalCode.Q, Frequency.B03),
    D6L(MeasurementType.DOPPLER, SignalCode.L, Frequency.J06),
    D6S(MeasurementType.DOPPLER, SignalCode.S, Frequency.J06),
    D6X(MeasurementType.DOPPLER, SignalCode.X, Frequency.E06, Frequency.J06, Frequency.B03, Frequency.R06),
    D6Z(MeasurementType.DOPPLER, SignalCode.Z, Frequency.E06, Frequency.J06),
    D7I(MeasurementType.DOPPLER, SignalCode.I, Frequency.E07, Frequency.B02),
    D7Q(MeasurementType.DOPPLER, SignalCode.Q, Frequency.E07, Frequency.B02),
    D7X(MeasurementType.DOPPLER, SignalCode.X, Frequency.E07, Frequency.B02),
    D8I(MeasurementType.DOPPLER, SignalCode.I, Frequency.E08),
    D8Q(MeasurementType.DOPPLER, SignalCode.Q, Frequency.E08),
    D8X(MeasurementType.DOPPLER, SignalCode.X, Frequency.E08),
    D9A(MeasurementType.DOPPLER, SignalCode.A, Frequency.I09),
    D9B(MeasurementType.DOPPLER, SignalCode.B, Frequency.I09),
    D9C(MeasurementType.DOPPLER, SignalCode.C, Frequency.I09),
    D9X(MeasurementType.DOPPLER, SignalCode.X, Frequency.I09),
    D0(MeasurementType.DOPPLER, SignalCode.CODELESS, new Frequency[0]),
    DA(MeasurementType.DOPPLER, SignalCode.C, Frequency.G01, Frequency.R01),
    DB(MeasurementType.DOPPLER, SignalCode.L, Frequency.G01),
    DC(MeasurementType.DOPPLER, SignalCode.L, Frequency.G02),
    DD(MeasurementType.DOPPLER, SignalCode.C, Frequency.R02),
    L1A(MeasurementType.CARRIER_PHASE, SignalCode.A, Frequency.E01),
    L1B(MeasurementType.CARRIER_PHASE, SignalCode.B, Frequency.E01),
    L1C(MeasurementType.CARRIER_PHASE, SignalCode.C, Frequency.G01, Frequency.R01, Frequency.E01, Frequency.S01, Frequency.J01),
    L1I(MeasurementType.CARRIER_PHASE, SignalCode.I, Frequency.B01),
    L1L(MeasurementType.CARRIER_PHASE, SignalCode.L, Frequency.G01, Frequency.J01),
    L1M(MeasurementType.CARRIER_PHASE, SignalCode.M, Frequency.G02),
    L1N(MeasurementType.CARRIER_PHASE, SignalCode.CODELESS, Frequency.G01),
    L1P(MeasurementType.CARRIER_PHASE, SignalCode.P, Frequency.G02, Frequency.R02),
    L1S(MeasurementType.CARRIER_PHASE, SignalCode.S, Frequency.G01, Frequency.J01),
    L1W(MeasurementType.CARRIER_PHASE, SignalCode.W, Frequency.G01),
    L1X(MeasurementType.CARRIER_PHASE, SignalCode.X, Frequency.G01, Frequency.E01, Frequency.J01),
    L1Y(MeasurementType.CARRIER_PHASE, SignalCode.Y, Frequency.G01),
    L1Z(MeasurementType.CARRIER_PHASE, SignalCode.Z, Frequency.E01, Frequency.J01),
    L2C(MeasurementType.CARRIER_PHASE, SignalCode.C, Frequency.G02, Frequency.R02),
    L2D(MeasurementType.CARRIER_PHASE, SignalCode.D, Frequency.G02),
    L2I(MeasurementType.CARRIER_PHASE, SignalCode.I, Frequency.B01),
    L2L(MeasurementType.CARRIER_PHASE, SignalCode.L, Frequency.G02, Frequency.J02),
    L2M(MeasurementType.CARRIER_PHASE, SignalCode.M, Frequency.G02),
    L2N(MeasurementType.CARRIER_PHASE, SignalCode.CODELESS, Frequency.G02),
    L2P(MeasurementType.CARRIER_PHASE, SignalCode.P, Frequency.G02, Frequency.R02),
    L2Q(MeasurementType.CARRIER_PHASE, SignalCode.Q, Frequency.B01),
    L2S(MeasurementType.CARRIER_PHASE, SignalCode.S, Frequency.G02, Frequency.J02),
    L2W(MeasurementType.CARRIER_PHASE, SignalCode.W, Frequency.G02),
    L2X(MeasurementType.CARRIER_PHASE, SignalCode.X, Frequency.G02, Frequency.J02),
    L2Y(MeasurementType.CARRIER_PHASE, SignalCode.Y, Frequency.G02),
    L3I(MeasurementType.CARRIER_PHASE, SignalCode.I, Frequency.R03),
    L3Q(MeasurementType.CARRIER_PHASE, SignalCode.Q, Frequency.R03),
    L3X(MeasurementType.CARRIER_PHASE, SignalCode.X, Frequency.R03),
    L4A(MeasurementType.CARRIER_PHASE, SignalCode.A, Frequency.R04),
    L4B(MeasurementType.CARRIER_PHASE, SignalCode.B, Frequency.R04),
    L4X(MeasurementType.CARRIER_PHASE, SignalCode.X, Frequency.R04),
    L5A(MeasurementType.CARRIER_PHASE, SignalCode.A, Frequency.I05),
    L5B(MeasurementType.CARRIER_PHASE, SignalCode.B, Frequency.I05),
    L5C(MeasurementType.CARRIER_PHASE, SignalCode.C, Frequency.I05),
    L5D(MeasurementType.CARRIER_PHASE, SignalCode.D, Frequency.J05),
    L5I(MeasurementType.CARRIER_PHASE, SignalCode.I, Frequency.G05, Frequency.E05, Frequency.S05, Frequency.J05),
    L5P(MeasurementType.CARRIER_PHASE, SignalCode.P, Frequency.J05),
    L5Q(MeasurementType.CARRIER_PHASE, SignalCode.Q, Frequency.G05, Frequency.E05, Frequency.S05, Frequency.J05),
    L5X(MeasurementType.CARRIER_PHASE, SignalCode.X, Frequency.G05, Frequency.E05, Frequency.S05, Frequency.J05, Frequency.I05),
    L5Z(MeasurementType.CARRIER_PHASE, SignalCode.Z, Frequency.J05),
    L6A(MeasurementType.CARRIER_PHASE, SignalCode.A, Frequency.E06, Frequency.R06),
    L6B(MeasurementType.CARRIER_PHASE, SignalCode.B, Frequency.E06, Frequency.R06),
    L6C(MeasurementType.CARRIER_PHASE, SignalCode.C, Frequency.E06),
    L6E(MeasurementType.CARRIER_PHASE, SignalCode.E, Frequency.J06),
    L6I(MeasurementType.CARRIER_PHASE, SignalCode.I, Frequency.B03),
    L6Q(MeasurementType.CARRIER_PHASE, SignalCode.Q, Frequency.B03),
    L6L(MeasurementType.CARRIER_PHASE, SignalCode.L, Frequency.J06),
    L6S(MeasurementType.CARRIER_PHASE, SignalCode.S, Frequency.J06),
    L6X(MeasurementType.CARRIER_PHASE, SignalCode.X, Frequency.E06, Frequency.J06, Frequency.B03, Frequency.R06),
    L6Z(MeasurementType.CARRIER_PHASE, SignalCode.Z, Frequency.E06, Frequency.J06),
    L7I(MeasurementType.CARRIER_PHASE, SignalCode.I, Frequency.E07, Frequency.B02),
    L7Q(MeasurementType.CARRIER_PHASE, SignalCode.Q, Frequency.E07, Frequency.B02),
    L7X(MeasurementType.CARRIER_PHASE, SignalCode.X, Frequency.E07, Frequency.B02),
    L8I(MeasurementType.CARRIER_PHASE, SignalCode.I, Frequency.E08),
    L8Q(MeasurementType.CARRIER_PHASE, SignalCode.Q, Frequency.E08),
    L8X(MeasurementType.CARRIER_PHASE, SignalCode.X, Frequency.E08),
    L9A(MeasurementType.CARRIER_PHASE, SignalCode.A, Frequency.I09),
    L9B(MeasurementType.CARRIER_PHASE, SignalCode.B, Frequency.I09),
    L9C(MeasurementType.CARRIER_PHASE, SignalCode.C, Frequency.I09),
    L9X(MeasurementType.CARRIER_PHASE, SignalCode.X, Frequency.I09),
    L0(MeasurementType.CARRIER_PHASE, SignalCode.CODELESS, new Frequency[0]),
    S1A(MeasurementType.SIGNAL_STRENGTH, SignalCode.A, Frequency.E01),
    S1B(MeasurementType.SIGNAL_STRENGTH, SignalCode.B, Frequency.E01),
    S1C(MeasurementType.SIGNAL_STRENGTH, SignalCode.C, Frequency.G01, Frequency.R01, Frequency.E01, Frequency.S01, Frequency.J01),
    S1I(MeasurementType.SIGNAL_STRENGTH, SignalCode.I, Frequency.B01),
    S1L(MeasurementType.SIGNAL_STRENGTH, SignalCode.L, Frequency.G01, Frequency.J01),
    S1M(MeasurementType.SIGNAL_STRENGTH, SignalCode.M, Frequency.G02),
    S1N(MeasurementType.SIGNAL_STRENGTH, SignalCode.CODELESS, Frequency.G01),
    S1P(MeasurementType.SIGNAL_STRENGTH, SignalCode.P, Frequency.G02, Frequency.R02),
    S1S(MeasurementType.SIGNAL_STRENGTH, SignalCode.S, Frequency.G01, Frequency.J01),
    S1W(MeasurementType.SIGNAL_STRENGTH, SignalCode.W, Frequency.G01),
    S1X(MeasurementType.SIGNAL_STRENGTH, SignalCode.X, Frequency.G01, Frequency.E01, Frequency.J01),
    S1Y(MeasurementType.SIGNAL_STRENGTH, SignalCode.Y, Frequency.G01),
    S1Z(MeasurementType.SIGNAL_STRENGTH, SignalCode.Z, Frequency.E01, Frequency.J01),
    S2C(MeasurementType.SIGNAL_STRENGTH, SignalCode.C, Frequency.G02, Frequency.R02),
    S2D(MeasurementType.SIGNAL_STRENGTH, SignalCode.D, Frequency.G02),
    S2I(MeasurementType.SIGNAL_STRENGTH, SignalCode.I, Frequency.B01),
    S2L(MeasurementType.SIGNAL_STRENGTH, SignalCode.L, Frequency.G02, Frequency.J02),
    S2M(MeasurementType.SIGNAL_STRENGTH, SignalCode.M, Frequency.G02),
    S2N(MeasurementType.SIGNAL_STRENGTH, SignalCode.CODELESS, Frequency.G02),
    S2P(MeasurementType.SIGNAL_STRENGTH, SignalCode.P, Frequency.G02, Frequency.R02),
    S2Q(MeasurementType.SIGNAL_STRENGTH, SignalCode.Q, Frequency.B01),
    S2S(MeasurementType.SIGNAL_STRENGTH, SignalCode.S, Frequency.G02, Frequency.J02),
    S2W(MeasurementType.SIGNAL_STRENGTH, SignalCode.W, Frequency.G02),
    S2X(MeasurementType.SIGNAL_STRENGTH, SignalCode.X, Frequency.G02, Frequency.J02),
    S2Y(MeasurementType.SIGNAL_STRENGTH, SignalCode.Y, Frequency.G02),
    S3I(MeasurementType.SIGNAL_STRENGTH, SignalCode.I, Frequency.R03),
    S3Q(MeasurementType.SIGNAL_STRENGTH, SignalCode.Q, Frequency.R03),
    S3X(MeasurementType.SIGNAL_STRENGTH, SignalCode.X, Frequency.R03),
    S4A(MeasurementType.SIGNAL_STRENGTH, SignalCode.A, Frequency.R04),
    S4B(MeasurementType.SIGNAL_STRENGTH, SignalCode.B, Frequency.R04),
    S4X(MeasurementType.SIGNAL_STRENGTH, SignalCode.X, Frequency.R04),
    S5A(MeasurementType.SIGNAL_STRENGTH, SignalCode.A, Frequency.I05),
    S5B(MeasurementType.SIGNAL_STRENGTH, SignalCode.B, Frequency.I05),
    S5C(MeasurementType.SIGNAL_STRENGTH, SignalCode.C, Frequency.I05),
    S5D(MeasurementType.SIGNAL_STRENGTH, SignalCode.D, Frequency.J05),
    S5I(MeasurementType.SIGNAL_STRENGTH, SignalCode.I, Frequency.G05, Frequency.E05, Frequency.S05, Frequency.J05),
    S5P(MeasurementType.SIGNAL_STRENGTH, SignalCode.P, Frequency.J05),
    S5Q(MeasurementType.SIGNAL_STRENGTH, SignalCode.Q, Frequency.G05, Frequency.E05, Frequency.S05, Frequency.J05),
    S5X(MeasurementType.SIGNAL_STRENGTH, SignalCode.X, Frequency.G05, Frequency.E05, Frequency.S05, Frequency.J05, Frequency.I05),
    S5Z(MeasurementType.SIGNAL_STRENGTH, SignalCode.Z, Frequency.J05),
    S6A(MeasurementType.SIGNAL_STRENGTH, SignalCode.A, Frequency.E06, Frequency.R06),
    S6B(MeasurementType.SIGNAL_STRENGTH, SignalCode.B, Frequency.E06, Frequency.R06),
    S6C(MeasurementType.SIGNAL_STRENGTH, SignalCode.C, Frequency.E06),
    S6E(MeasurementType.SIGNAL_STRENGTH, SignalCode.E, Frequency.J06),
    S6I(MeasurementType.SIGNAL_STRENGTH, SignalCode.I, Frequency.B03),
    S6Q(MeasurementType.SIGNAL_STRENGTH, SignalCode.Q, Frequency.B03),
    S6L(MeasurementType.SIGNAL_STRENGTH, SignalCode.L, Frequency.J06),
    S6S(MeasurementType.SIGNAL_STRENGTH, SignalCode.S, Frequency.J06),
    S6X(MeasurementType.SIGNAL_STRENGTH, SignalCode.X, Frequency.E06, Frequency.J06, Frequency.B03, Frequency.R06),
    S6Z(MeasurementType.SIGNAL_STRENGTH, SignalCode.Z, Frequency.E06, Frequency.J06),
    S7I(MeasurementType.SIGNAL_STRENGTH, SignalCode.I, Frequency.E07, Frequency.B02),
    S7Q(MeasurementType.SIGNAL_STRENGTH, SignalCode.Q, Frequency.E07, Frequency.B02),
    S7X(MeasurementType.SIGNAL_STRENGTH, SignalCode.X, Frequency.E07, Frequency.B02),
    S8I(MeasurementType.SIGNAL_STRENGTH, SignalCode.I, Frequency.E08),
    S8Q(MeasurementType.SIGNAL_STRENGTH, SignalCode.Q, Frequency.E08),
    S8X(MeasurementType.SIGNAL_STRENGTH, SignalCode.X, Frequency.E08),
    S9A(MeasurementType.SIGNAL_STRENGTH, SignalCode.A, Frequency.I09),
    S9B(MeasurementType.SIGNAL_STRENGTH, SignalCode.B, Frequency.I09),
    S9C(MeasurementType.SIGNAL_STRENGTH, SignalCode.C, Frequency.I09),
    S9X(MeasurementType.SIGNAL_STRENGTH, SignalCode.X, Frequency.I09),
    S0(MeasurementType.SIGNAL_STRENGTH, SignalCode.CODELESS, new Frequency[0]),
    SA(MeasurementType.SIGNAL_STRENGTH, SignalCode.C, Frequency.G01, Frequency.R01),
    SB(MeasurementType.SIGNAL_STRENGTH, SignalCode.L, Frequency.G01),
    SC(MeasurementType.SIGNAL_STRENGTH, SignalCode.L, Frequency.G02),
    SD(MeasurementType.SIGNAL_STRENGTH, SignalCode.C, Frequency.R02);

    private final MeasurementType type;
    private final SignalCode code;
    private final Map<SatelliteSystem, Frequency> frequencies;

    private ObservationType(MeasurementType type, SignalCode code, Frequency ... frequencies) {
        this.type = type;
        this.code = code;
        this.frequencies = new HashMap<SatelliteSystem, Frequency>(frequencies.length);
        for (Frequency f : frequencies) {
            this.frequencies.put(f.getSatelliteSystem(), f);
        }
    }

    public MeasurementType getMeasurementType() {
        return this.type;
    }

    public SignalCode getSignalCode() {
        return this.code;
    }

    public Frequency getFrequency(SatelliteSystem system) {
        return this.frequencies.get((Object)system);
    }
}

