/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.frames;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.util.FastMath;
import org.orekit.frames.FieldTransform;
import org.orekit.frames.FieldTransformGenerator;
import org.orekit.frames.InterpolatingTransformProvider;
import org.orekit.frames.Transform;
import org.orekit.frames.TransformGenerator;
import org.orekit.frames.TransformProvider;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.AngularDerivativesFilter;
import org.orekit.utils.CartesianDerivativesFilter;
import org.orekit.utils.GenericTimeStampedCache;

public class ShiftingTransformProvider
implements TransformProvider {
    private static final long serialVersionUID = 20150601L;
    private final InterpolatingTransformProvider interpolatingProvider;
    private final transient GenericTimeStampedCache<Transform> cache;
    private final transient Map<Field<? extends CalculusFieldElement<?>>, Object> fieldCaches;

    public ShiftingTransformProvider(TransformProvider rawProvider, CartesianDerivativesFilter cFilter, AngularDerivativesFilter aFilter, int gridPoints, double step, int maxSlots, double maxSpan, double newSlotInterval) {
        this(new InterpolatingTransformProvider(rawProvider, cFilter, aFilter, gridPoints, step, maxSlots, maxSpan, newSlotInterval), maxSlots, maxSpan, newSlotInterval);
    }

    private ShiftingTransformProvider(InterpolatingTransformProvider interpolatingProvider, int maxSlots, double maxSpan, double newSlotInterval) {
        this.interpolatingProvider = interpolatingProvider;
        this.cache = new GenericTimeStampedCache<Transform>(2, maxSlots, maxSpan, newSlotInterval, new TransformGenerator(2, interpolatingProvider, interpolatingProvider.getStep()));
        this.fieldCaches = new HashMap();
    }

    public TransformProvider getRawProvider() {
        return this.interpolatingProvider.getRawProvider();
    }

    public int getGridPoints() {
        return this.interpolatingProvider.getGridPoints();
    }

    public double getStep() {
        return this.interpolatingProvider.getStep();
    }

    @Override
    public Transform getTransform(AbsoluteDate date) {
        Transform closest = this.cache.getNeighbors(date).reduce((t0, t1) -> FastMath.abs((double)date.durationFrom(t0.getDate())) < FastMath.abs((double)date.durationFrom(t1.getDate())) ? t0 : t1).get();
        return closest.shiftedBy(date.durationFrom(closest.getDate()));
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldTransform<T> getTransform(FieldAbsoluteDate<T> date) {
        GenericTimeStampedCache<T> fieldCache = (GenericTimeStampedCache<T>)this.fieldCaches.get(date.getField());
        if (fieldCache == null) {
            fieldCache = new GenericTimeStampedCache<T>(this.cache.getNeighborsSize(), this.cache.getMaxSlots(), this.cache.getMaxSpan(), this.cache.getNewSlotQuantumGap(), new FieldTransformGenerator<T>(date.getField(), this.cache.getNeighborsSize(), this.interpolatingProvider, this.interpolatingProvider.getStep()));
            this.fieldCaches.put(date.getField(), fieldCache);
        }
        FieldTransform closest = (FieldTransform)fieldCache.getNeighbors(date.toAbsoluteDate()).reduce((t0, t1) -> ((CalculusFieldElement)date.durationFrom(t0.getDate()).abs()).getReal() < ((CalculusFieldElement)date.durationFrom(t1.getDate()).abs()).getReal() ? t0 : t1).get();
        return closest.shiftedBy(date.durationFrom(closest.getDate()));
    }

    private Object writeReplace() {
        return new DTO(this.interpolatingProvider, this.cache.getMaxSlots(), this.cache.getMaxSpan(), this.cache.getNewSlotQuantumGap());
    }

    private static class DTO
    implements Serializable {
        private static final long serialVersionUID = 20150601L;
        private final InterpolatingTransformProvider interpolatingProvider;
        private final int maxSlots;
        private final double maxSpan;
        private final double newSlotInterval;

        private DTO(InterpolatingTransformProvider interpolatingProvider, int maxSlots, double maxSpan, double newSlotInterval) {
            this.interpolatingProvider = interpolatingProvider;
            this.maxSlots = maxSlots;
            this.maxSpan = maxSpan;
            this.newSlotInterval = newSlotInterval;
        }

        private Object readResolve() {
            return new ShiftingTransformProvider(this.interpolatingProvider, this.maxSlots, this.maxSpan, this.newSlotInterval);
        }
    }
}

