/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.frames;

import org.hipparchus.CalculusFieldElement;
import org.orekit.frames.FieldTransform;
import org.orekit.frames.Frame;
import org.orekit.frames.LOFType;
import org.orekit.frames.Transform;
import org.orekit.frames.TransformProvider;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.PVCoordinatesProvider;

public class LocalOrbitalFrame
extends Frame {
    private static final long serialVersionUID = -4469440345574964950L;

    public LocalOrbitalFrame(Frame parent, LOFType type, PVCoordinatesProvider provider, String name) throws IllegalArgumentException {
        super(parent, new LocalProvider(type, provider, parent, name), name, false);
    }

    private static class LocalProvider
    implements TransformProvider {
        private static final long serialVersionUID = 20170421L;
        private final LOFType type;
        private final PVCoordinatesProvider provider;
        private final Frame reference;
        private final String name;

        LocalProvider(LOFType type, PVCoordinatesProvider provider, Frame reference, String name) {
            this.type = type;
            this.provider = provider;
            this.reference = reference;
            this.name = name;
        }

        @Override
        public Transform getTransform(AbsoluteDate date) {
            return this.type.transformFromInertial(date, this.provider.getPVCoordinates(date, this.reference));
        }

        @Override
        public <T extends CalculusFieldElement<T>> FieldTransform<T> getTransform(FieldAbsoluteDate<T> date) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("FieldTransforms are not supported for a LocalOrbitalFrame: " + this.name + ". Please contact orekit-developers@orekit.org if you would like to add this feature.");
        }
    }
}

