/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.frames;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.exception.Localizable;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.data.DataContext;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.FieldTransform;
import org.orekit.frames.HelmertTransformation;
import org.orekit.frames.Transform;
import org.orekit.frames.TransformProvider;
import org.orekit.frames.TransformProviderUtils;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.TimeScale;

public enum ITRFVersion {
    ITRF_2014(2014),
    ITRF_2008(2008),
    ITRF_2005(2005),
    ITRF_2000(2000),
    ITRF_1997(1997),
    ITRF_1996(1996),
    ITRF_1994(1994),
    ITRF_1993(1993),
    ITRF_1992(1992),
    ITRF_1991(1991),
    ITRF_1990(1990),
    ITRF_1989(1989),
    ITRF_1988(1988);

    private static final Pattern PATTERN;
    private final int year;
    private final String name;

    private ITRFVersion(int year) {
        this.year = year;
        this.name = "ITRF-" + year;
    }

    public int getYear() {
        return this.year;
    }

    public String getName() {
        return this.name;
    }

    public static ITRFVersion getITRFVersion(int year) {
        int fixedYear = year > 87 && year < 100 ? year + 1900 : year;
        for (ITRFVersion version : ITRFVersion.values()) {
            if (version.getYear() != fixedYear) continue;
            return version;
        }
        throw new OrekitException((Localizable)OrekitMessages.NO_SUCH_ITRF_FRAME, year);
    }

    public static ITRFVersion getITRFVersion(String name) {
        Matcher matcher = PATTERN.matcher(name);
        if (matcher.matches()) {
            try {
                return ITRFVersion.getITRFVersion(Integer.parseInt(matcher.group(1)));
            }
            catch (OrekitException oe) {
                throw new OrekitException((Localizable)OrekitMessages.NO_SUCH_ITRF_FRAME, name);
            }
        }
        throw new OrekitException((Localizable)OrekitMessages.NO_SUCH_ITRF_FRAME, name);
    }

    @DefaultDataContext
    public static Converter getConverter(ITRFVersion origin, ITRFVersion destination) {
        return ITRFVersion.getConverter(origin, destination, DataContext.getDefault().getTimeScales().getTT());
    }

    public static Converter getConverter(ITRFVersion origin, ITRFVersion destination, TimeScale tt) {
        TransformProvider provider = null;
        if (origin == destination) {
            provider = TransformProviderUtils.IDENTITY_PROVIDER;
        }
        if (provider == null) {
            provider = ITRFVersion.getDirectTransformProvider(origin, destination, tt);
        }
        if (provider == null) {
            provider = TransformProviderUtils.getCombinedProvider(ITRFVersion.getDirectTransformProvider(origin, ITRF_2014, tt), ITRFVersion.getDirectTransformProvider(ITRF_2014, destination, tt));
        }
        return new Converter(origin, destination, provider);
    }

    private static TransformProvider getDirectTransformProvider(ITRFVersion origin, ITRFVersion destination, TimeScale tt) {
        for (HelmertTransformation.Predefined predefined : HelmertTransformation.Predefined.values()) {
            if (predefined.getOrigin() == origin && predefined.getDestination() == destination) {
                return predefined.getTransformation(tt);
            }
            if (predefined.getOrigin() != destination || predefined.getDestination() != origin) continue;
            return TransformProviderUtils.getReversedProvider(predefined.getTransformation(tt));
        }
        return null;
    }

    static {
        PATTERN = Pattern.compile("[Ii][Tt][Rr][Ff][-_ ]?([0-9]{2,4})");
    }

    public static class Converter
    implements TransformProvider {
        private static final long serialVersionUID = 20180330L;
        private final ITRFVersion origin;
        private final ITRFVersion destination;
        private final TransformProvider provider;

        Converter(ITRFVersion origin, ITRFVersion destination, TransformProvider provider) {
            this.origin = origin;
            this.destination = destination;
            this.provider = provider;
        }

        public ITRFVersion getOrigin() {
            return this.origin;
        }

        public ITRFVersion getDestination() {
            return this.destination;
        }

        @Override
        public Transform getTransform(AbsoluteDate date) {
            return this.provider.getTransform(date);
        }

        @Override
        public <T extends CalculusFieldElement<T>> FieldTransform<T> getTransform(FieldAbsoluteDate<T> date) {
            return this.provider.getTransform(date);
        }
    }
}

