/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.gravity.potential;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.hipparchus.analysis.interpolation.HermiteInterpolator;
import org.orekit.errors.OrekitException;
import org.orekit.errors.TimeStampedCacheException;
import org.orekit.forces.gravity.potential.NormalizedSphericalHarmonicsProvider;
import org.orekit.forces.gravity.potential.TideSystem;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.TimeStamped;
import org.orekit.utils.GenericTimeStampedCache;
import org.orekit.utils.TimeStampedCache;
import org.orekit.utils.TimeStampedGenerator;

public class CachedNormalizedSphericalHarmonicsProvider
implements NormalizedSphericalHarmonicsProvider {
    private final NormalizedSphericalHarmonicsProvider rawProvider;
    private final int size;
    private final TimeStampedCache<TimeStampedSphericalHarmonics> cache;

    public CachedNormalizedSphericalHarmonicsProvider(NormalizedSphericalHarmonicsProvider rawProvider, double step, int nbPoints, int maxSlots, double maxSpan, double newSlotInterval) {
        this.rawProvider = rawProvider;
        int k = rawProvider.getMaxDegree() + 1;
        this.size = k * (k + 1) / 2;
        this.cache = new GenericTimeStampedCache<TimeStampedSphericalHarmonics>(nbPoints, maxSlots, maxSpan, newSlotInterval, new Generator(step));
    }

    @Override
    public int getMaxDegree() {
        return this.rawProvider.getMaxDegree();
    }

    @Override
    public int getMaxOrder() {
        return this.rawProvider.getMaxOrder();
    }

    @Override
    public double getMu() {
        return this.rawProvider.getMu();
    }

    @Override
    public double getAe() {
        return this.rawProvider.getAe();
    }

    @Override
    public AbsoluteDate getReferenceDate() {
        return this.rawProvider.getReferenceDate();
    }

    @Override
    public double getOffset(AbsoluteDate date) {
        return this.rawProvider.getOffset(date);
    }

    @Override
    public TideSystem getTideSystem() {
        return this.rawProvider.getTideSystem();
    }

    @Override
    public NormalizedSphericalHarmonicsProvider.NormalizedSphericalHarmonics onDate(AbsoluteDate date) {
        return TimeStampedSphericalHarmonics.interpolate(date, this.cache.getNeighbors(date));
    }

    private static class TimeStampedSphericalHarmonics
    implements TimeStamped,
    NormalizedSphericalHarmonicsProvider.NormalizedSphericalHarmonics {
        private final AbsoluteDate date;
        private final int size;
        private final double[] cnmsnm;

        private TimeStampedSphericalHarmonics(AbsoluteDate date, double[] cnmsnm) {
            this.date = date;
            this.cnmsnm = (double[])cnmsnm.clone();
            this.size = cnmsnm.length / 2;
        }

        @Override
        public AbsoluteDate getDate() {
            return this.date;
        }

        @Override
        public double getNormalizedCnm(int n, int m) {
            return this.cnmsnm[n * (n + 1) / 2 + m];
        }

        @Override
        public double getNormalizedSnm(int n, int m) {
            return this.cnmsnm[n * (n + 1) / 2 + m + this.size];
        }

        public static TimeStampedSphericalHarmonics interpolate(AbsoluteDate date, Stream<TimeStampedSphericalHarmonics> sample) {
            HermiteInterpolator interpolator = new HermiteInterpolator();
            sample.forEach(tssh -> interpolator.addSamplePoint(tssh.date.durationFrom(date), (double[][])new double[][]{tssh.cnmsnm}));
            return new TimeStampedSphericalHarmonics(date, interpolator.value(0.0));
        }
    }

    private class Generator
    implements TimeStampedGenerator<TimeStampedSphericalHarmonics> {
        private final double step;

        Generator(double step) {
            this.step = step;
        }

        @Override
        public List<TimeStampedSphericalHarmonics> generate(AbsoluteDate existingDate, AbsoluteDate date) {
            try {
                ArrayList<TimeStampedSphericalHarmonics> generated = new ArrayList<TimeStampedSphericalHarmonics>();
                double[] cnmsnm = new double[2 * CachedNormalizedSphericalHarmonicsProvider.this.size];
                if (existingDate == null) {
                    for (int i = 0; i < CachedNormalizedSphericalHarmonicsProvider.this.cache.getNeighborsSize(); ++i) {
                        AbsoluteDate t = date.shiftedBy((double)(i - CachedNormalizedSphericalHarmonicsProvider.this.cache.getNeighborsSize() / 2) * this.step);
                        this.fillArray(CachedNormalizedSphericalHarmonicsProvider.this.rawProvider.onDate(t), cnmsnm);
                        generated.add(new TimeStampedSphericalHarmonics(t, cnmsnm));
                    }
                } else {
                    AbsoluteDate t = existingDate;
                    if (date.compareTo(t) > 0) {
                        do {
                            t = t.shiftedBy(this.step);
                            this.fillArray(CachedNormalizedSphericalHarmonicsProvider.this.rawProvider.onDate(t), cnmsnm);
                            generated.add(new TimeStampedSphericalHarmonics(t, cnmsnm));
                        } while (t.compareTo(date) <= 0);
                    } else {
                        do {
                            t = t.shiftedBy(-this.step);
                            this.fillArray(CachedNormalizedSphericalHarmonicsProvider.this.rawProvider.onDate(t), cnmsnm);
                            generated.add(new TimeStampedSphericalHarmonics(t, cnmsnm));
                        } while (t.compareTo(date) >= 0);
                        Collections.reverse(generated);
                    }
                }
                return generated;
            }
            catch (OrekitException oe) {
                throw new TimeStampedCacheException(oe);
            }
        }

        private void fillArray(NormalizedSphericalHarmonicsProvider.NormalizedSphericalHarmonics raw, double[] cnmsnm) {
            int m;
            int n;
            int index = 0;
            for (n = 0; n <= CachedNormalizedSphericalHarmonicsProvider.this.rawProvider.getMaxDegree(); ++n) {
                for (m = 0; m <= n; ++m) {
                    cnmsnm[index++] = raw.getNormalizedCnm(n, m);
                }
            }
            for (n = 0; n <= CachedNormalizedSphericalHarmonicsProvider.this.rawProvider.getMaxDegree(); ++n) {
                for (m = 0; m <= n; ++m) {
                    cnmsnm[index++] = raw.getNormalizedSnm(n, m);
                }
            }
        }
    }
}

