/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.empirical;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.util.FastMath;
import org.orekit.forces.empirical.AccelerationModel;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.ParameterDriver;

public class PolynomialAccelerationModel
implements AccelerationModel {
    private static final double ACCELERATION_SCALE = FastMath.scalb((double)1.0, (int)-20);
    private final List<ParameterDriver> drivers;
    private AbsoluteDate referenceDate;

    public PolynomialAccelerationModel(String prefix, AbsoluteDate referenceDate, int degree) {
        this.referenceDate = referenceDate;
        this.drivers = new ArrayList<ParameterDriver>();
        for (int i = 0; i < degree + 1; ++i) {
            this.drivers.add(new ParameterDriver(prefix + "[" + i + "]", 0.0, ACCELERATION_SCALE, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY));
        }
    }

    @Override
    public void init(SpacecraftState initialState, AbsoluteDate target) {
        if (this.referenceDate == null) {
            this.referenceDate = initialState.getDate();
        }
    }

    @Override
    public double signedAmplitude(SpacecraftState state, double[] parameters) {
        double dt = state.getDate().durationFrom(this.referenceDate);
        double amplitude = 0.0;
        for (int i = parameters.length - 1; i >= 0; --i) {
            amplitude += amplitude * dt + parameters[i];
        }
        return amplitude;
    }

    @Override
    public <T extends CalculusFieldElement<T>> T signedAmplitude(FieldSpacecraftState<T> state, T[] parameters) {
        T dt = state.getDate().durationFrom(this.referenceDate);
        CalculusFieldElement amplitude = (CalculusFieldElement)dt.getField().getZero();
        for (int i = parameters.length - 1; i >= 0; --i) {
            amplitude = (CalculusFieldElement)amplitude.add(((CalculusFieldElement)amplitude.multiply(dt)).add(parameters[i]));
        }
        return (T)amplitude;
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return Collections.unmodifiableList(this.drivers);
    }
}

