/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.utils.parsing;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.orekit.data.DataSource;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitInternalError;
import org.orekit.files.ccsds.utils.FileFormat;
import org.orekit.files.ccsds.utils.lexical.LexicalAnalyzerSelector;
import org.orekit.files.ccsds.utils.lexical.MessageParser;
import org.orekit.files.ccsds.utils.lexical.MessageVersionXmlTokenBuilder;
import org.orekit.files.ccsds.utils.lexical.ParseToken;
import org.orekit.files.ccsds.utils.lexical.XmlTokenBuilder;
import org.orekit.files.ccsds.utils.parsing.ErrorState;
import org.orekit.files.ccsds.utils.parsing.ProcessingState;

public abstract class AbstractMessageParser<T>
implements MessageParser<T> {
    private static final int MAX_LOOP = 100;
    private final String root;
    private final String formatVersionKey;
    private ProcessingState next;
    private ProcessingState current;
    private ProcessingState fallback;
    private FileFormat format;
    private boolean endTagSeen;

    protected AbstractMessageParser(String root, String formatVersionKey) {
        this.root = root;
        this.formatVersionKey = formatVersionKey;
        this.current = null;
        this.setFallback(new ErrorState());
    }

    public void setFallback(ProcessingState fallback) {
        this.fallback = fallback;
    }

    protected void reset(FileFormat fileFormat, ProcessingState initialState) {
        this.format = fileFormat;
        this.current = initialState;
        this.endTagSeen = false;
        this.anticipateNext(this.fallback);
    }

    public void setEndTagSeen(boolean endTagSeen) {
        this.endTagSeen = endTagSeen;
    }

    public boolean wasEndTagSeen() {
        return this.endTagSeen;
    }

    public ProcessingState getCurrent() {
        return this.current;
    }

    protected FileFormat getFileFormat() {
        return this.format;
    }

    @Override
    public T parseMessage(DataSource source) {
        try {
            return LexicalAnalyzerSelector.select(source).accept(this);
        }
        catch (IOException ioe) {
            throw new OrekitException(ioe, (Localizable)LocalizedCoreFormats.SIMPLE_MESSAGE, ioe.getLocalizedMessage());
        }
    }

    @Override
    public String getFormatVersionKey() {
        return this.formatVersionKey;
    }

    @Override
    public Map<String, XmlTokenBuilder> getSpecialXmlElementsBuilders() {
        HashMap<String, XmlTokenBuilder> builders = new HashMap<String, XmlTokenBuilder>();
        if (this.formatVersionKey != null) {
            builders.put(this.root, new MessageVersionXmlTokenBuilder());
        }
        return builders;
    }

    public void anticipateNext(ProcessingState anticipated) {
        this.next = anticipated;
    }

    @Override
    public void process(ParseToken token) {
        for (int i = 0; i < 100; ++i) {
            if (this.current.processToken(token)) {
                return;
            }
            this.current = this.next;
            this.next = this.fallback;
        }
        throw new OrekitInternalError(null);
    }
}

