/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.utils.lexical;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.hipparchus.exception.Localizable;
import org.orekit.data.DataSource;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.ccsds.utils.lexical.KvnLexicalAnalyzer;
import org.orekit.files.ccsds.utils.lexical.LexicalAnalyzer;
import org.orekit.files.ccsds.utils.lexical.XmlLexicalAnalyzer;

public class LexicalAnalyzerSelector {
    private static final int BUFFER = 4096;
    private static final byte[] UCS_4_BE_BOM = new byte[]{0, 0, -2, -1, 0, 0, 0, 60, 0, 0, 0, 63, 0, 0, 0, 120, 0, 0, 0, 109, 0, 0, 0, 108};
    private static final byte[] UCS_4_LE_BOM = new byte[]{-1, -2, 0, 0, 60, 0, 0, 0, 63, 0, 0, 0, 120, 0, 0, 0, 109, 0, 0, 0, 108, 0, 0, 0};
    private static final byte[] UTF_16_BE_BOM = new byte[]{-2, -1, 0, 60, 0, 63, 0, 120, 0, 109, 0, 108};
    private static final byte[] UTF_16_LE_BOM = new byte[]{-1, -2, 60, 0, 63, 0, 120, 0, 109, 0, 108, 0};
    private static final byte[] UTF_8_BOM = new byte[]{-17, -69, -65, 60, 63, 120, 109, 108};
    private static final byte[] UCS_4_BE = new byte[]{0, 0, 0, 60, 0, 0, 0, 63, 0, 0, 0, 120, 0, 0, 0, 109, 0, 0, 0, 108};
    private static final byte[] UCS_4_LE = new byte[]{60, 0, 0, 0, 63, 0, 0, 0, 120, 0, 0, 0, 109, 0, 0, 0, 108, 0, 0, 0};
    private static final byte[] UTF_16_BE = new byte[]{0, 60, 0, 63, 0, 120, 0, 109, 0, 108};
    private static final byte[] UTF_16_LE = new byte[]{60, 0, 63, 0, 120, 0, 109, 0, 108, 0};
    private static final byte[] UTF_8 = new byte[]{60, 63, 120, 109, 108};
    private static final String CHARS_BOM = "\ufeff<?xml";
    private static final String CHARS = "<?xml";

    private LexicalAnalyzerSelector() {
    }

    public static LexicalAnalyzer select(DataSource source) throws IOException {
        DataSource.Opener opener = source.getOpener();
        if (opener.rawDataIsBinary()) {
            return LexicalAnalyzerSelector.select(source.getName(), opener.openStreamOnce());
        }
        return LexicalAnalyzerSelector.select(source.getName(), opener.openReaderOnce());
    }

    private static LexicalAnalyzer select(String name, InputStream stream) throws IOException {
        int n;
        if (stream == null) {
            throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_FIND_FILE, name);
        }
        BufferedInputStream bis = new BufferedInputStream(stream, 4096);
        int size = UCS_4_BE_BOM.length;
        bis.mark(size);
        byte[] first = new byte[size];
        for (int read = 0; read < first.length; read += n) {
            n = bis.read(first, read, size - read);
            if (n >= 0) continue;
            bis.reset();
            return new KvnLexicalAnalyzer(new DataSource(name, () -> bis));
        }
        if (LexicalAnalyzerSelector.checkSequence(first, UTF_8) || LexicalAnalyzerSelector.checkSequence(first, UTF_8_BOM) || LexicalAnalyzerSelector.checkSequence(first, UTF_16_LE) || LexicalAnalyzerSelector.checkSequence(first, UTF_16_LE_BOM) || LexicalAnalyzerSelector.checkSequence(first, UTF_16_BE) || LexicalAnalyzerSelector.checkSequence(first, UTF_16_BE_BOM) || LexicalAnalyzerSelector.checkSequence(first, UCS_4_LE) || LexicalAnalyzerSelector.checkSequence(first, UCS_4_LE_BOM) || LexicalAnalyzerSelector.checkSequence(first, UCS_4_BE) || LexicalAnalyzerSelector.checkSequence(first, UCS_4_BE_BOM)) {
            bis.reset();
            return new XmlLexicalAnalyzer(new DataSource(name, () -> bis));
        }
        bis.reset();
        return new KvnLexicalAnalyzer(new DataSource(name, () -> bis));
    }

    private static LexicalAnalyzer select(String name, Reader reader) throws IOException {
        int n;
        if (reader == null) {
            throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_FIND_FILE, name);
        }
        BufferedReader br = new BufferedReader(reader, 4096);
        int size = CHARS_BOM.length();
        br.mark(size);
        char[] first = new char[size];
        for (int read = 0; read < first.length; read += n) {
            n = br.read(first, read, size - read);
            if (n >= 0) continue;
            br.reset();
            return new KvnLexicalAnalyzer(new DataSource(name, () -> br));
        }
        String firstString = new String(first);
        if (firstString.startsWith(CHARS) || CHARS_BOM.equals(firstString)) {
            br.reset();
            return new XmlLexicalAnalyzer(new DataSource(name, () -> br));
        }
        br.reset();
        return new KvnLexicalAnalyzer(new DataSource(name, () -> br));
    }

    private static boolean checkSequence(byte[] first, byte[] reference) {
        for (int i = 0; i < reference.length; ++i) {
            if (first[i] == reference[i]) continue;
            return false;
        }
        return true;
    }
}

