/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.utils.generation;

import java.io.IOException;
import java.util.List;
import org.orekit.files.ccsds.utils.FileFormat;
import org.orekit.files.ccsds.utils.generation.AbstractGenerator;
import org.orekit.utils.AccurateFormatter;
import org.orekit.utils.units.Unit;

public class XmlGenerator
extends AbstractGenerator {
    public static final int DEFAULT_INDENT = 2;
    public static final String UNITS = "units";
    private static final String PROLOG = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>%n";
    private static final String ROOT_START = "<%s id=\"%s\" version=\"%.1f\">%n";
    private static final String START_TAG = "<%s>%n";
    private static final String END_TAG = "</%s>%n";
    private static final String LEAF_0_ATTRIBUTES = "<%s>%s</%s>%n";
    private static final String LEAF_1_ATTRIBUTE = "<%s %s=\"%s\">%s</%s>%n";
    private static final String LEAF_2_ATTRIBUTES = "<%s %s=\"%s\" %s=\"%s\">%s</%s>%n";
    private static final String COMMENT = "COMMENT";
    private final int indentation;
    private int level;

    public XmlGenerator(Appendable output, int indentation, String outputName, boolean writeUnits) throws IOException {
        super(output, outputName, writeUnits);
        this.indentation = indentation;
        this.level = 0;
        this.writeRawData(String.format(AccurateFormatter.STANDARDIZED_LOCALE, PROLOG, new Object[0]));
    }

    @Override
    public FileFormat getFormat() {
        return FileFormat.XML;
    }

    @Override
    public void startMessage(String root, String messageTypeKey, double version) throws IOException {
        this.indent();
        this.writeRawData(String.format(AccurateFormatter.STANDARDIZED_LOCALE, ROOT_START, root, messageTypeKey, version));
        ++this.level;
    }

    @Override
    public void endMessage(String root) throws IOException {
        --this.level;
        this.indent();
        this.writeRawData(String.format(AccurateFormatter.STANDARDIZED_LOCALE, END_TAG, root));
    }

    @Override
    public void writeComments(List<String> comments) throws IOException {
        for (String comment : comments) {
            this.writeEntry(COMMENT, comment, null, false);
        }
    }

    public void writeOneAttributeElement(String name, String value, String attributeName, String attributeValue) throws IOException {
        this.indent();
        this.writeRawData(String.format(AccurateFormatter.STANDARDIZED_LOCALE, LEAF_1_ATTRIBUTE, name, attributeName, attributeValue, value, name));
    }

    public void writeTwoAttributesElement(String name, String value, String attribute1Name, String attribute1Value, String attribute2Name, String attribute2Value) throws IOException {
        this.indent();
        this.writeRawData(String.format(AccurateFormatter.STANDARDIZED_LOCALE, LEAF_2_ATTRIBUTES, name, attribute1Name, attribute1Value, attribute2Name, attribute2Value, value, name));
    }

    @Override
    public void writeEntry(String key, String value, Unit unit, boolean mandatory) throws IOException {
        if (value == null) {
            this.complain(key, mandatory);
        } else {
            this.indent();
            if (this.writeUnits(unit)) {
                this.writeRawData(String.format(AccurateFormatter.STANDARDIZED_LOCALE, LEAF_1_ATTRIBUTE, key, UNITS, this.siToCcsdsName(unit.getName()), value, key));
            } else {
                this.writeRawData(String.format(AccurateFormatter.STANDARDIZED_LOCALE, LEAF_0_ATTRIBUTES, key, value, key));
            }
        }
    }

    @Override
    public void enterSection(String name) throws IOException {
        this.indent();
        this.writeRawData(String.format(AccurateFormatter.STANDARDIZED_LOCALE, START_TAG, name));
        ++this.level;
        super.enterSection(name);
    }

    @Override
    public String exitSection() throws IOException {
        String name = super.exitSection();
        --this.level;
        this.indent();
        this.writeRawData(String.format(AccurateFormatter.STANDARDIZED_LOCALE, END_TAG, name));
        return name;
    }

    private void indent() throws IOException {
        for (int i = 0; i < this.level * this.indentation; ++i) {
            this.writeRawData(' ');
        }
    }
}

