/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.utils.generation;

import java.io.IOException;
import java.util.List;
import org.hipparchus.util.FastMath;
import org.orekit.files.ccsds.utils.FileFormat;
import org.orekit.files.ccsds.utils.generation.AbstractGenerator;
import org.orekit.utils.AccurateFormatter;
import org.orekit.utils.units.Unit;

public class KvnGenerator
extends AbstractGenerator {
    private static final String COMMENT = "COMMENT";
    private static final String START = "_START";
    private static final String STOP = "_STOP";
    private final String kvFormat;
    private final int unitsColumn;
    private final String commentFormat;

    public KvnGenerator(Appendable output, int paddingWidth, String outputName, int unitsColumn) {
        super(output, outputName, unitsColumn > 0);
        this.kvFormat = "%-" + FastMath.max((int)1, (int)paddingWidth) + "s = %s";
        StringBuilder builder = new StringBuilder(COMMENT);
        builder.append(' ');
        while (builder.length() < paddingWidth + 3) {
            builder.append(' ');
        }
        builder.append("%s%n");
        this.unitsColumn = unitsColumn;
        this.commentFormat = builder.toString();
    }

    @Override
    public FileFormat getFormat() {
        return FileFormat.KVN;
    }

    @Override
    public void startMessage(String root, String messageTypeKey, double version) throws IOException {
        this.writeEntry(messageTypeKey, String.format(AccurateFormatter.STANDARDIZED_LOCALE, "%.1f", version), null, true);
    }

    @Override
    public void endMessage(String root) {
    }

    @Override
    public void writeComments(List<String> comments) throws IOException {
        for (String comment : comments) {
            this.writeRawData(String.format(AccurateFormatter.STANDARDIZED_LOCALE, this.commentFormat, comment));
        }
    }

    @Override
    public void writeEntry(String key, String value, Unit unit, boolean mandatory) throws IOException {
        if (value == null) {
            this.complain(key, mandatory);
        } else {
            String s = String.format(AccurateFormatter.STANDARDIZED_LOCALE, this.kvFormat, key, value);
            this.writeRawData(s);
            if (this.writeUnits(unit)) {
                for (int column = s.length(); column < this.unitsColumn; ++column) {
                    this.writeRawData(' ');
                }
                this.writeRawData('[');
                this.writeRawData(this.siToCcsdsName(unit.getName()));
                this.writeRawData(']');
            }
            this.newLine();
        }
    }

    @Override
    public void enterSection(String name) throws IOException {
        this.writeRawData(name);
        this.writeRawData(START);
        this.newLine();
        super.enterSection(name);
    }

    @Override
    public String exitSection() throws IOException {
        String name = super.exitSection();
        this.writeRawData(name);
        this.writeRawData(STOP);
        this.newLine();
        return name;
    }
}

