/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.utils.generation;

import java.io.IOException;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import org.orekit.files.ccsds.definitions.TimeConverter;
import org.orekit.files.ccsds.ndm.NdmConstituent;
import org.orekit.files.ccsds.section.CommentsContainer;
import org.orekit.files.ccsds.section.Header;
import org.orekit.files.ccsds.section.HeaderKey;
import org.orekit.files.ccsds.section.Metadata;
import org.orekit.files.ccsds.section.Segment;
import org.orekit.files.ccsds.section.XmlStructureKey;
import org.orekit.files.ccsds.utils.ContextBinding;
import org.orekit.files.ccsds.utils.FileFormat;
import org.orekit.files.ccsds.utils.generation.Generator;
import org.orekit.files.ccsds.utils.generation.MessageWriter;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.DateComponents;
import org.orekit.time.DateTimeComponents;
import org.orekit.time.TimeComponents;
import org.orekit.time.TimeScale;
import org.orekit.time.UTCScale;

public abstract class AbstractMessageWriter<H extends Header, S extends Segment<?, ?>, F extends NdmConstituent<H, S>>
implements MessageWriter<H, S, F> {
    public static final String DEFAULT_ORIGINATOR = "OREKIT";
    private final String root;
    private final String formatVersionKey;
    private final double defaultVersion;
    private ContextBinding context;
    private TimeConverter timeConverter;
    private double version;

    public AbstractMessageWriter(String root, String formatVersionKey, double defaultVersion, ContextBinding context) {
        this.root = root;
        this.defaultVersion = defaultVersion;
        this.formatVersionKey = formatVersionKey;
        this.version = defaultVersion;
        this.setContext(context);
    }

    public void setContext(ContextBinding context) {
        this.context = context;
        this.timeConverter = context.getTimeSystem().getConverter(context);
    }

    public ContextBinding getContext() {
        return this.context;
    }

    public TimeConverter getTimeConverter() {
        return this.timeConverter;
    }

    public double getDefaultVersion() {
        return this.defaultVersion;
    }

    @Override
    public void writeHeader(Generator generator, H header) throws IOException {
        ZonedDateTime zdt = ZonedDateTime.now(ZoneOffset.UTC);
        UTCScale utc = this.context.getDataContext().getTimeScales().getUTC();
        AbsoluteDate date = new AbsoluteDate(zdt.getYear(), zdt.getMonthValue(), zdt.getDayOfMonth(), zdt.getHour(), zdt.getMinute(), (double)zdt.getSecond(), (TimeScale)utc);
        if (header != null) {
            if (!Double.isNaN(((Header)header).getFormatVersion())) {
                this.version = ((Header)header).getFormatVersion();
            }
            if (((Header)header).getCreationDate() == null) {
                ((Header)header).setCreationDate(date);
            }
            if (((Header)header).getOriginator() == null) {
                ((Header)header).setOriginator(DEFAULT_ORIGINATOR);
            }
            ((Header)header).validate(this.version);
        }
        generator.startMessage(this.root, this.formatVersionKey, this.version);
        if (generator.getFormat() == FileFormat.XML) {
            generator.enterSection(XmlStructureKey.header.name());
        }
        if (header != null) {
            generator.writeComments(((CommentsContainer)header).getComments());
        }
        DateTimeComponents creationDate = (header == null ? date : ((Header)header).getCreationDate()).getComponents(utc);
        DateComponents dc = creationDate.getDate();
        TimeComponents tc = creationDate.getTime();
        generator.writeEntry(HeaderKey.CREATION_DATE.name(), generator.dateToString(dc.getYear(), dc.getMonth(), dc.getDay(), tc.getHour(), tc.getMinute(), tc.getSecond()), null, true);
        generator.writeEntry(HeaderKey.ORIGINATOR.name(), header == null ? DEFAULT_ORIGINATOR : ((Header)header).getOriginator(), null, true);
        if (header != null) {
            generator.writeEntry(HeaderKey.MESSAGE_ID.name(), ((Header)header).getMessageId(), null, false);
        }
        if (generator.getFormat() == FileFormat.XML) {
            generator.exitSection();
        }
        generator.newLine();
        if (generator.getFormat() == FileFormat.XML) {
            generator.enterSection(XmlStructureKey.body.name());
        }
    }

    @Override
    public void writeSegment(Generator generator, S segment) throws IOException {
        ((Metadata)((Segment)segment).getMetadata()).validate(this.version);
        ((Segment)segment).getData().validate(this.version);
        if (generator.getFormat() == FileFormat.XML) {
            generator.enterSection(XmlStructureKey.segment.name());
        }
        this.writeSegmentContent(generator, this.version, segment);
        if (generator.getFormat() == FileFormat.XML) {
            generator.exitSection();
        }
    }

    public abstract void writeSegmentContent(Generator var1, double var2, S var4) throws IOException;

    @Override
    public void writeFooter(Generator generator) throws IOException {
        if (generator.getFormat() == FileFormat.XML) {
            generator.exitSection();
        }
        generator.endMessage(this.root);
    }
}

