/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.tdm;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.hipparchus.exception.Localizable;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.ccsds.definitions.FrameFacade;
import org.orekit.files.ccsds.ndm.tdm.AngleType;
import org.orekit.files.ccsds.ndm.tdm.CorrectionApplied;
import org.orekit.files.ccsds.ndm.tdm.DataQuality;
import org.orekit.files.ccsds.ndm.tdm.IntegrationReference;
import org.orekit.files.ccsds.ndm.tdm.ObservationType;
import org.orekit.files.ccsds.ndm.tdm.RangeMode;
import org.orekit.files.ccsds.ndm.tdm.RangeUnits;
import org.orekit.files.ccsds.ndm.tdm.RangeUnitsConverter;
import org.orekit.files.ccsds.ndm.tdm.TdmMetadataKey;
import org.orekit.files.ccsds.ndm.tdm.TimetagReference;
import org.orekit.files.ccsds.ndm.tdm.TrackingMode;
import org.orekit.files.ccsds.section.Metadata;
import org.orekit.time.AbsoluteDate;

public class TdmMetadata
extends Metadata {
    private String trackId;
    private List<ObservationType> dataTypes;
    private AbsoluteDate startTime;
    private AbsoluteDate stopTime;
    private Map<Integer, String> participants = new TreeMap<Integer, String>();
    private TrackingMode mode;
    private int[] path;
    private int[] path1;
    private int[] path2;
    private Map<Integer, String> ephemerisNames = new TreeMap<Integer, String>();
    private String transmitBand;
    private String receiveBand;
    private int turnaroundNumerator;
    private int turnaroundDenominator;
    private TimetagReference timetagRef;
    private double integrationInterval;
    private IntegrationReference integrationRef;
    private double freqOffset;
    private RangeMode rangeMode;
    private double rawRangeModulus;
    private RangeUnits rangeUnits;
    private AngleType angleType;
    private FrameFacade referenceFrame;
    private String interpolationMethod;
    private int interpolationDegree;
    private double doppplerCountBias = Double.NaN;
    private double dopplerCountScale = 1.0;
    private boolean doppplerCountRollover = false;
    private Map<Integer, Double> transmitDelays = new TreeMap<Integer, Double>();
    private Map<Integer, Double> receiveDelays = new TreeMap<Integer, Double>();
    private DataQuality dataQuality;
    private double correctionAngle1;
    private double correctionAngle2;
    private double correctionDoppler;
    private double correctionMagnitude;
    private double rawCorrectionRange;
    private double correctionRcs;
    private double correctionReceive;
    private double correctionTransmit;
    private double correctionAberrationYearly;
    private double correctionAberrationDiurnal;
    private CorrectionApplied correctionsApplied;

    public TdmMetadata() {
        super(null);
    }

    @Override
    public void validate(double version) {
        super.validate(version);
        if (this.participants.isEmpty()) {
            throw new OrekitException((Localizable)OrekitMessages.UNINITIALIZED_VALUE_FOR_KEY, new Object[]{TdmMetadataKey.PARTICIPANT_1});
        }
    }

    public String getTrackId() {
        return this.trackId;
    }

    public void setTrackId(String trackId) {
        this.refuseFurtherComments();
        this.trackId = trackId;
    }

    public List<ObservationType> getDataTypes() {
        return this.dataTypes;
    }

    public void setDataTypes(List<ObservationType> dataTypes) {
        this.refuseFurtherComments();
        this.dataTypes = new ArrayList<ObservationType>();
        this.dataTypes.addAll(dataTypes);
    }

    public AbsoluteDate getStartTime() {
        return this.startTime;
    }

    public void setStartTime(AbsoluteDate startTime) {
        this.refuseFurtherComments();
        this.startTime = startTime;
    }

    public AbsoluteDate getStopTime() {
        return this.stopTime;
    }

    public void setStopTime(AbsoluteDate stopTime) {
        this.refuseFurtherComments();
        this.stopTime = stopTime;
    }

    public Map<Integer, String> getParticipants() {
        return this.participants;
    }

    public void setParticipants(Map<Integer, String> participants) {
        this.refuseFurtherComments();
        this.participants = new TreeMap<Integer, String>();
        this.participants.putAll(participants);
    }

    public void addParticipant(int participantNumber, String participant) {
        this.refuseFurtherComments();
        this.participants.put(participantNumber, participant);
    }

    public TrackingMode getMode() {
        return this.mode;
    }

    public void setMode(TrackingMode mode) {
        this.refuseFurtherComments();
        this.mode = mode;
    }

    public int[] getPath() {
        return this.safeCopy(this.path);
    }

    public void setPath(int[] path) {
        this.refuseFurtherComments();
        this.path = this.safeCopy(path);
    }

    public int[] getPath1() {
        return this.safeCopy(this.path1);
    }

    public void setPath1(int[] path1) {
        this.refuseFurtherComments();
        this.path1 = this.safeCopy(path1);
    }

    public int[] getPath2() {
        return this.safeCopy(this.path2);
    }

    public void setPath2(int[] path2) {
        this.refuseFurtherComments();
        this.path2 = this.safeCopy(path2);
    }

    public Map<Integer, String> getEphemerisNames() {
        return this.ephemerisNames;
    }

    public void setEphemerisNames(Map<Integer, String> ephemerisNames) {
        this.refuseFurtherComments();
        this.ephemerisNames = new TreeMap<Integer, String>();
        this.ephemerisNames.putAll(ephemerisNames);
    }

    public void addEphemerisName(int participantNumber, String ephemerisName) {
        this.refuseFurtherComments();
        this.ephemerisNames.put(participantNumber, ephemerisName);
    }

    public String getTransmitBand() {
        return this.transmitBand;
    }

    public void setTransmitBand(String transmitBand) {
        this.refuseFurtherComments();
        this.transmitBand = transmitBand;
    }

    public String getReceiveBand() {
        return this.receiveBand;
    }

    public void setReceiveBand(String receiveBand) {
        this.refuseFurtherComments();
        this.receiveBand = receiveBand;
    }

    public int getTurnaroundNumerator() {
        return this.turnaroundNumerator;
    }

    public void setTurnaroundNumerator(int turnaroundNumerator) {
        this.refuseFurtherComments();
        this.turnaroundNumerator = turnaroundNumerator;
    }

    public int getTurnaroundDenominator() {
        return this.turnaroundDenominator;
    }

    public void setTurnaroundDenominator(int turnaroundDenominator) {
        this.refuseFurtherComments();
        this.turnaroundDenominator = turnaroundDenominator;
    }

    public TimetagReference getTimetagRef() {
        return this.timetagRef;
    }

    public void setTimetagRef(TimetagReference timetagRef) {
        this.refuseFurtherComments();
        this.timetagRef = timetagRef;
    }

    public double getIntegrationInterval() {
        return this.integrationInterval;
    }

    public void setIntegrationInterval(double integrationInterval) {
        this.refuseFurtherComments();
        this.integrationInterval = integrationInterval;
    }

    public IntegrationReference getIntegrationRef() {
        return this.integrationRef;
    }

    public void setIntegrationRef(IntegrationReference integrationRef) {
        this.refuseFurtherComments();
        this.integrationRef = integrationRef;
    }

    public double getFreqOffset() {
        return this.freqOffset;
    }

    public void setFreqOffset(double freqOffset) {
        this.refuseFurtherComments();
        this.freqOffset = freqOffset;
    }

    public RangeMode getRangeMode() {
        return this.rangeMode;
    }

    public void setRangeMode(RangeMode rangeMode) {
        this.refuseFurtherComments();
        this.rangeMode = rangeMode;
    }

    public double getRangeModulus(RangeUnitsConverter converter) {
        if (this.rangeUnits == RangeUnits.km) {
            return this.rawRangeModulus * 1000.0;
        }
        if (this.rangeUnits == RangeUnits.s) {
            return this.rawRangeModulus * 2.99792458E8;
        }
        return converter.ruToMeters(this, this.startTime, this.rawRangeModulus);
    }

    public double getRawRangeModulus() {
        return this.rawRangeModulus;
    }

    public void setRawRangeModulus(double rawRangeModulus) {
        this.refuseFurtherComments();
        this.rawRangeModulus = rawRangeModulus;
    }

    public RangeUnits getRangeUnits() {
        return this.rangeUnits;
    }

    public void setRangeUnits(RangeUnits rangeUnits) {
        this.refuseFurtherComments();
        this.rangeUnits = rangeUnits;
    }

    public AngleType getAngleType() {
        return this.angleType;
    }

    public void setAngleType(AngleType angleType) {
        this.refuseFurtherComments();
        this.angleType = angleType;
    }

    public FrameFacade getReferenceFrame() {
        return this.referenceFrame;
    }

    public void setReferenceFrame(FrameFacade referenceFrame) {
        this.refuseFurtherComments();
        this.referenceFrame = referenceFrame;
    }

    public String getInterpolationMethod() {
        return this.interpolationMethod;
    }

    public void setInterpolationMethod(String interpolationMethod) {
        this.refuseFurtherComments();
        this.interpolationMethod = interpolationMethod;
    }

    public int getInterpolationDegree() {
        return this.interpolationDegree;
    }

    public void setInterpolationDegree(int interpolationDegree) {
        this.refuseFurtherComments();
        this.interpolationDegree = interpolationDegree;
    }

    public double getDopplerCountBias() {
        return this.doppplerCountBias;
    }

    public void setDopplerCountBias(double dopplerCountBias) {
        this.refuseFurtherComments();
        this.doppplerCountBias = dopplerCountBias;
    }

    public double getDopplerCountScale() {
        return this.dopplerCountScale;
    }

    public void setDopplerCountScale(double dopplerCountScale) {
        this.refuseFurtherComments();
        this.dopplerCountScale = dopplerCountScale;
    }

    public boolean hasDopplerCountRollover() {
        return this.doppplerCountRollover;
    }

    public void setDopplerCountRollover(boolean dopplerCountRollover) {
        this.refuseFurtherComments();
        this.doppplerCountRollover = dopplerCountRollover;
    }

    public Map<Integer, Double> getTransmitDelays() {
        return this.transmitDelays;
    }

    public void setTransmitDelays(Map<Integer, Double> transmitDelays) {
        this.refuseFurtherComments();
        this.transmitDelays = new TreeMap<Integer, Double>();
        this.transmitDelays.putAll(transmitDelays);
    }

    public void addTransmitDelay(int participantNumber, double transmitDelay) {
        this.refuseFurtherComments();
        this.transmitDelays.put(participantNumber, transmitDelay);
    }

    public Map<Integer, Double> getReceiveDelays() {
        return this.receiveDelays;
    }

    public void setReceiveDelays(Map<Integer, Double> receiveDelays) {
        this.refuseFurtherComments();
        this.receiveDelays = new TreeMap<Integer, Double>();
        this.receiveDelays.putAll(receiveDelays);
    }

    public void addReceiveDelay(int participantNumber, double receiveDelay) {
        this.refuseFurtherComments();
        this.receiveDelays.put(participantNumber, receiveDelay);
    }

    public DataQuality getDataQuality() {
        return this.dataQuality;
    }

    public void setDataQuality(DataQuality dataQuality) {
        this.refuseFurtherComments();
        this.dataQuality = dataQuality;
    }

    public double getCorrectionAngle1() {
        return this.correctionAngle1;
    }

    public void setCorrectionAngle1(double correctionAngle1) {
        this.refuseFurtherComments();
        this.correctionAngle1 = correctionAngle1;
    }

    public double getCorrectionAngle2() {
        return this.correctionAngle2;
    }

    public void setCorrectionAngle2(double correctionAngle2) {
        this.refuseFurtherComments();
        this.correctionAngle2 = correctionAngle2;
    }

    public double getCorrectionDoppler() {
        return this.correctionDoppler;
    }

    public void setCorrectionDoppler(double correctionDoppler) {
        this.refuseFurtherComments();
        this.correctionDoppler = correctionDoppler;
    }

    public double getCorrectionMagnitude() {
        return this.correctionMagnitude;
    }

    public void setCorrectionMagnitude(double correctionMagnitude) {
        this.refuseFurtherComments();
        this.correctionMagnitude = correctionMagnitude;
    }

    public double getCorrectionRange(RangeUnitsConverter converter) {
        if (this.rangeUnits == RangeUnits.km) {
            return this.rawCorrectionRange * 1000.0;
        }
        if (this.rangeUnits == RangeUnits.s) {
            return this.rawCorrectionRange * 2.99792458E8;
        }
        return converter.ruToMeters(this, this.startTime, this.rawCorrectionRange);
    }

    public double getRawCorrectionRange() {
        return this.rawCorrectionRange;
    }

    public void setRawCorrectionRange(double rawCorrectionRange) {
        this.refuseFurtherComments();
        this.rawCorrectionRange = rawCorrectionRange;
    }

    public double getCorrectionRcs() {
        return this.correctionRcs;
    }

    public void setCorrectionRcs(double correctionRcs) {
        this.refuseFurtherComments();
        this.correctionRcs = correctionRcs;
    }

    public double getCorrectionAberrationYearly() {
        return this.correctionAberrationYearly;
    }

    public void setCorrectionAberrationYearly(double correctionAberrationYearly) {
        this.refuseFurtherComments();
        this.correctionAberrationYearly = correctionAberrationYearly;
    }

    public double getCorrectionAberrationDiurnal() {
        return this.correctionAberrationDiurnal;
    }

    public void setCorrectionAberrationDiurnal(double correctionAberrationDiurnal) {
        this.refuseFurtherComments();
        this.correctionAberrationDiurnal = correctionAberrationDiurnal;
    }

    public double getCorrectionReceive() {
        return this.correctionReceive;
    }

    public void setCorrectionReceive(double correctionReceive) {
        this.refuseFurtherComments();
        this.correctionReceive = correctionReceive;
    }

    public double getCorrectionTransmit() {
        return this.correctionTransmit;
    }

    public void setCorrectionTransmit(double correctionTransmit) {
        this.refuseFurtherComments();
        this.correctionTransmit = correctionTransmit;
    }

    public CorrectionApplied getCorrectionsApplied() {
        return this.correctionsApplied;
    }

    public void setCorrectionsApplied(CorrectionApplied correctionsApplied) {
        this.refuseFurtherComments();
        this.correctionsApplied = correctionsApplied;
    }

    private int[] safeCopy(int[] original) {
        return original == null ? null : (int[])original.clone();
    }
}

