/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.tdm;

import java.io.IOException;
import org.orekit.files.ccsds.definitions.TimeConverter;
import org.orekit.files.ccsds.ndm.tdm.Observation;
import org.orekit.files.ccsds.ndm.tdm.ObservationType;
import org.orekit.files.ccsds.ndm.tdm.ObservationsBlock;
import org.orekit.files.ccsds.ndm.tdm.RangeUnitsConverter;
import org.orekit.files.ccsds.ndm.tdm.TdmDataKey;
import org.orekit.files.ccsds.ndm.tdm.TdmMetadata;
import org.orekit.files.ccsds.section.AbstractWriter;
import org.orekit.files.ccsds.section.KvnStructureKey;
import org.orekit.files.ccsds.section.XmlStructureKey;
import org.orekit.files.ccsds.utils.FileFormat;
import org.orekit.files.ccsds.utils.generation.Generator;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.units.Unit;

class ObservationsBlockWriter
extends AbstractWriter {
    private final ObservationsBlock observationsBlock;
    private final TimeConverter timeConverter;
    private final TdmMetadata metadata;
    private final RangeUnitsConverter converter;

    ObservationsBlockWriter(ObservationsBlock observationsBlock, TimeConverter timeConverter, TdmMetadata metadata, RangeUnitsConverter converter) {
        super(XmlStructureKey.data.name(), KvnStructureKey.DATA.name());
        this.observationsBlock = observationsBlock;
        this.timeConverter = timeConverter;
        this.metadata = metadata;
        this.converter = converter;
    }

    @Override
    protected void writeContent(Generator generator) throws IOException {
        generator.writeComments(this.observationsBlock.getComments());
        for (Observation observation : this.observationsBlock.getObservations()) {
            ObservationType type = observation.getType();
            AbsoluteDate date = observation.getEpoch();
            double siValue = observation.getMeasurement();
            double rawValue = type.siToRaw(this.converter, this.metadata, date, siValue);
            if (generator.getFormat() == FileFormat.KVN) {
                StringBuilder builder = new StringBuilder();
                builder.append(generator.dateToString(this.timeConverter, date));
                builder.append(' ');
                builder.append(generator.doubleToString(rawValue));
                generator.writeEntry(observation.getType().name(), builder.toString(), null, false);
                continue;
            }
            generator.enterSection(TdmDataKey.observation.name());
            generator.writeEntry(TdmDataKey.EPOCH.name(), this.timeConverter, date, true);
            generator.writeEntry(type.name(), rawValue, Unit.ONE, true);
            generator.exitSection();
        }
    }
}

