/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.odm.opm;

import java.util.Collections;
import java.util.List;
import org.orekit.files.ccsds.ndm.odm.CartesianCovariance;
import org.orekit.files.ccsds.ndm.odm.KeplerianElements;
import org.orekit.files.ccsds.ndm.odm.KeplerianElementsKey;
import org.orekit.files.ccsds.ndm.odm.SpacecraftParameters;
import org.orekit.files.ccsds.ndm.odm.StateVector;
import org.orekit.files.ccsds.ndm.odm.UserDefined;
import org.orekit.files.ccsds.ndm.odm.opm.Maneuver;
import org.orekit.files.ccsds.section.Data;

public class OpmData
implements Data {
    private final StateVector stateVectorBlock;
    private final KeplerianElements keplerianElementsBlock;
    private final SpacecraftParameters spacecraftParametersBlock;
    private final CartesianCovariance covarianceBlock;
    private final List<Maneuver> maneuverBlocks;
    private final UserDefined userDefinedBlock;
    private final double mass;

    public OpmData(StateVector stateVectorBlock, KeplerianElements keplerianElementsBlock, SpacecraftParameters spacecraftParametersBlock, CartesianCovariance covarianceBlock, List<Maneuver> maneuverBlocks, UserDefined userDefinedBlock, double mass) {
        this.stateVectorBlock = stateVectorBlock;
        this.keplerianElementsBlock = keplerianElementsBlock;
        this.spacecraftParametersBlock = spacecraftParametersBlock;
        this.covarianceBlock = covarianceBlock;
        this.maneuverBlocks = maneuverBlocks;
        this.userDefinedBlock = userDefinedBlock;
        this.mass = mass;
    }

    @Override
    public void validate(double version) {
        this.stateVectorBlock.validate(version);
        if (this.keplerianElementsBlock != null) {
            this.keplerianElementsBlock.validate(version);
            this.keplerianElementsBlock.checkNotNaN(this.keplerianElementsBlock.getA(), KeplerianElementsKey.SEMI_MAJOR_AXIS);
        }
        if (this.spacecraftParametersBlock != null) {
            this.spacecraftParametersBlock.validate(version);
        }
        if (this.covarianceBlock != null) {
            this.covarianceBlock.setEpoch(this.stateVectorBlock.getEpoch());
            this.covarianceBlock.validate(version);
        }
        for (Maneuver maneuver : this.maneuverBlocks) {
            maneuver.validate(version);
        }
        if (this.userDefinedBlock != null) {
            this.userDefinedBlock.validate(version);
        }
    }

    public StateVector getStateVectorBlock() {
        return this.stateVectorBlock;
    }

    public KeplerianElements getKeplerianElementsBlock() {
        return this.keplerianElementsBlock;
    }

    public SpacecraftParameters getSpacecraftParametersBlock() {
        return this.spacecraftParametersBlock;
    }

    public CartesianCovariance getCovarianceBlock() {
        return this.covarianceBlock;
    }

    public double getMass() {
        return this.mass;
    }

    public int getNbManeuvers() {
        return this.maneuverBlocks.size();
    }

    public List<Maneuver> getManeuvers() {
        return Collections.unmodifiableList(this.maneuverBlocks);
    }

    public Maneuver getManeuver(int index) {
        return this.maneuverBlocks.get(index);
    }

    public boolean hasManeuvers() {
        return !this.maneuverBlocks.isEmpty();
    }

    public UserDefined getUserDefinedBlock() {
        return this.userDefinedBlock;
    }
}

