/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.odm.opm;

import java.util.List;
import org.orekit.data.DataContext;
import org.orekit.files.ccsds.ndm.NdmConstituent;
import org.orekit.files.ccsds.ndm.odm.CommonMetadata;
import org.orekit.files.ccsds.ndm.odm.KeplerianElements;
import org.orekit.files.ccsds.ndm.odm.opm.Maneuver;
import org.orekit.files.ccsds.ndm.odm.opm.OpmData;
import org.orekit.files.ccsds.section.Header;
import org.orekit.files.ccsds.section.Segment;
import org.orekit.orbits.CartesianOrbit;
import org.orekit.orbits.KeplerianOrbit;
import org.orekit.orbits.Orbit;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.TimeStamped;
import org.orekit.utils.IERSConventions;
import org.orekit.utils.PVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public class Opm
extends NdmConstituent<Header, Segment<CommonMetadata, OpmData>>
implements TimeStamped {
    public static final String ROOT = "opm";
    public static final String FORMAT_VERSION_KEY = "CCSDS_OPM_VERS";
    private final double mu;

    public Opm(Header header, List<Segment<CommonMetadata, OpmData>> segments, IERSConventions conventions, DataContext dataContext, double mu) {
        super(header, segments, conventions, dataContext);
        this.mu = mu;
    }

    public CommonMetadata getMetadata() {
        return (CommonMetadata)((Segment)this.getSegments().get(0)).getMetadata();
    }

    public OpmData getData() {
        return (OpmData)((Segment)this.getSegments().get(0)).getData();
    }

    @Override
    public AbsoluteDate getDate() {
        return this.getData().getStateVectorBlock().getEpoch();
    }

    public int getNbManeuvers() {
        return this.getData().getNbManeuvers();
    }

    public List<Maneuver> getManeuvers() {
        return this.getData().getManeuvers();
    }

    public Maneuver getManeuver(int index) {
        return this.getData().getManeuver(index);
    }

    public boolean hasManeuvers() {
        return this.getData().hasManeuvers();
    }

    public TimeStampedPVCoordinates getPVCoordinates() {
        return this.getData().getStateVectorBlock().toTimeStampedPVCoordinates();
    }

    public CartesianOrbit generateCartesianOrbit() {
        return new CartesianOrbit(this.getPVCoordinates(), this.getMetadata().getFrame(), this.getData().getStateVectorBlock().getEpoch(), this.mu);
    }

    public KeplerianOrbit generateKeplerianOrbit() {
        CommonMetadata metadata = this.getMetadata();
        OpmData data = this.getData();
        KeplerianElements keplerianElements = data.getKeplerianElementsBlock();
        if (keplerianElements != null) {
            return keplerianElements.generateKeplerianOrbit(metadata.getFrame());
        }
        return new KeplerianOrbit((PVCoordinates)this.getPVCoordinates(), metadata.getFrame(), data.getStateVectorBlock().getEpoch(), this.mu);
    }

    public SpacecraftState generateSpacecraftState() {
        return new SpacecraftState((Orbit)this.generateCartesianOrbit(), this.getData().getMass());
    }
}

