/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.odm.omm;

import java.util.List;
import org.orekit.data.DataContext;
import org.orekit.files.ccsds.ndm.NdmConstituent;
import org.orekit.files.ccsds.ndm.odm.KeplerianElements;
import org.orekit.files.ccsds.ndm.odm.omm.OmmData;
import org.orekit.files.ccsds.ndm.odm.omm.OmmMetadata;
import org.orekit.files.ccsds.ndm.odm.omm.OmmTle;
import org.orekit.files.ccsds.section.Header;
import org.orekit.files.ccsds.section.Segment;
import org.orekit.orbits.KeplerianOrbit;
import org.orekit.orbits.Orbit;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.analytical.tle.TLE;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.TimeStamped;
import org.orekit.utils.IERSConventions;

public class Omm
extends NdmConstituent<Header, Segment<OmmMetadata, OmmData>>
implements TimeStamped {
    public static final String ROOT = "omm";
    public static final String FORMAT_VERSION_KEY = "CCSDS_OMM_VERS";

    public Omm(Header header, List<Segment<OmmMetadata, OmmData>> segments, IERSConventions conventions, DataContext dataContext) {
        super(header, segments, conventions, dataContext);
    }

    public OmmMetadata getMetadata() {
        return (OmmMetadata)((Segment)this.getSegments().get(0)).getMetadata();
    }

    public OmmData getData() {
        return (OmmData)((Segment)this.getSegments().get(0)).getData();
    }

    @Override
    public AbsoluteDate getDate() {
        return this.getData().getKeplerianElementsBlock().getEpoch();
    }

    public KeplerianOrbit generateKeplerianOrbit() {
        return this.getData().getKeplerianElementsBlock().generateKeplerianOrbit(this.getMetadata().getFrame());
    }

    public SpacecraftState generateSpacecraftState() {
        return new SpacecraftState((Orbit)this.generateKeplerianOrbit(), this.getData().getMass());
    }

    public TLE generateTLE() {
        OmmMetadata metadata = this.getMetadata();
        KeplerianElements kep = this.getData().getKeplerianElementsBlock();
        OmmTle tle = this.getData().getTLEBlock();
        return new TLE(tle.getNoradID(), tle.getClassificationType(), metadata.getLaunchYear(), metadata.getLaunchNumber(), metadata.getLaunchPiece(), tle.getEphemerisType(), tle.getElementSetNumber(), kep.getEpoch(), kep.getMeanMotion(), tle.getMeanMotionDot(), tle.getMeanMotionDotDot(), kep.getE(), kep.getI(), kep.getPa(), kep.getRaan(), kep.getAnomaly(), tle.getRevAtEpoch(), tle.getBStar(), this.getDataContext().getTimeScales().getUTC());
    }
}

