/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.odm.oem;

import java.util.List;
import org.orekit.files.ccsds.ndm.odm.CartesianCovariance;
import org.orekit.files.ccsds.ndm.odm.oem.OemData;
import org.orekit.files.ccsds.ndm.odm.oem.OemMetadata;
import org.orekit.files.ccsds.section.Segment;
import org.orekit.files.general.EphemerisFile;
import org.orekit.frames.Frame;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.CartesianDerivativesFilter;
import org.orekit.utils.TimeStampedPVCoordinates;

public class OemSegment
extends Segment<OemMetadata, OemData>
implements EphemerisFile.EphemerisSegment<TimeStampedPVCoordinates> {
    private final double mu;

    public OemSegment(OemMetadata metadata, OemData data, double mu) {
        super(metadata, data);
        this.mu = mu;
    }

    @Override
    public double getMu() {
        return this.mu;
    }

    @Override
    public List<TimeStampedPVCoordinates> getCoordinates() {
        return ((OemData)this.getData()).getCoordinates();
    }

    @Override
    public CartesianDerivativesFilter getAvailableDerivatives() {
        return ((OemData)this.getData()).getAvailableDerivatives();
    }

    public List<CartesianCovariance> getCovarianceMatrices() {
        return ((OemData)this.getData()).getCovarianceMatrices();
    }

    @Override
    public Frame getFrame() {
        return ((OemMetadata)this.getMetadata()).getFrame();
    }

    @Override
    public Frame getInertialFrame() {
        Frame frame = this.getFrame();
        while (!frame.isPseudoInertial()) {
            frame = frame.getParent();
        }
        return frame;
    }

    @Override
    public AbsoluteDate getStart() {
        AbsoluteDate start = ((OemMetadata)this.getMetadata()).getUseableStartTime();
        if (start != null) {
            return start;
        }
        return ((OemMetadata)this.getMetadata()).getStartTime();
    }

    @Override
    public AbsoluteDate getStop() {
        AbsoluteDate stop = ((OemMetadata)this.getMetadata()).getUseableStopTime();
        if (stop != null) {
            return stop;
        }
        return ((OemMetadata)this.getMetadata()).getStopTime();
    }

    @Override
    public int getInterpolationSamples() {
        return ((OemMetadata)this.getMetadata()).getInterpolationDegree() + 1;
    }
}

