/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.odm.ocm;

import java.util.Collections;
import java.util.List;
import org.orekit.bodies.CelestialBodies;
import org.orekit.files.ccsds.definitions.BodyFacade;
import org.orekit.files.ccsds.ndm.odm.ocm.ShadowModel;
import org.orekit.files.ccsds.section.CommentsContainer;
import org.orekit.time.AbsoluteDate;

public class Perturbations
extends CommentsContainer {
    private String atmosphericModel;
    private String gravityModel;
    private int gravityDegree;
    private int gravityOrder;
    private double equatorialRadius = Double.NaN;
    private double gm = Double.NaN;
    private List<BodyFacade> nBodyPerturbations;
    private double centralBodyRotation = Double.NaN;
    private double oblateFlattening = Double.NaN;
    private String oceanTidesModel;
    private String solidTidesModel;
    private String reductionTheory;
    private String albedoModel;
    private int albedoGridSize;
    private ShadowModel shadowModel;
    private List<BodyFacade> shadowBodies;
    private String srpModel;
    private String spaceWeatherSource;
    private AbsoluteDate spaceWeatherEpoch;
    private String interpMethodSW;
    private double fixedGeomagneticKp = Double.NaN;
    private double fixedGeomagneticAp = Double.NaN;
    private double fixedGeomagneticDst = Double.NaN;
    private double fixedF10P7 = Double.NaN;
    private double fixedF10P7Mean = Double.NaN;
    private double fixedM10P7 = Double.NaN;
    private double fixedM10P7Mean = Double.NaN;
    private double fixedS10P7 = Double.NaN;
    private double fixedS10P7Mean = Double.NaN;
    private double fixedY10P7 = Double.NaN;
    private double fixedY10P7Mean = Double.NaN;

    public Perturbations(CelestialBodies celestialBodies) {
        this.shadowBodies = Collections.singletonList(new BodyFacade(celestialBodies.getEarth().getName(), celestialBodies.getEarth()));
    }

    public String getAtmosphericModel() {
        return this.atmosphericModel;
    }

    public void setAtmosphericModel(String atmosphericModel) {
        this.atmosphericModel = atmosphericModel;
    }

    public String getGravityModel() {
        return this.gravityModel;
    }

    public int getGravityDegree() {
        return this.gravityDegree;
    }

    public int getGravityOrder() {
        return this.gravityOrder;
    }

    public void setGravityModel(String name, int degree, int order) {
        this.gravityModel = name;
        this.gravityDegree = degree;
        this.gravityOrder = order;
    }

    public double getEquatorialRadius() {
        return this.equatorialRadius;
    }

    public void setEquatorialRadius(double equatorialRadius) {
        this.equatorialRadius = equatorialRadius;
    }

    public double getGm() {
        return this.gm;
    }

    public void setGm(double gm) {
        this.gm = gm;
    }

    public List<BodyFacade> getNBodyPerturbations() {
        return this.nBodyPerturbations;
    }

    public void setNBodyPerturbations(List<BodyFacade> nBody) {
        this.nBodyPerturbations = nBody;
    }

    public double getCentralBodyRotation() {
        return this.centralBodyRotation;
    }

    public void setCentralBodyRotation(double centralBodyRotation) {
        this.centralBodyRotation = centralBodyRotation;
    }

    public double getOblateFlattening() {
        return this.oblateFlattening;
    }

    public void setOblateFlattening(double oblateFlattening) {
        this.oblateFlattening = oblateFlattening;
    }

    public String getOceanTidesModel() {
        return this.oceanTidesModel;
    }

    public void setOceanTidesModel(String oceanTidesModel) {
        this.oceanTidesModel = oceanTidesModel;
    }

    public String getSolidTidesModel() {
        return this.solidTidesModel;
    }

    public void setSolidTidesModel(String solidTidesModel) {
        this.solidTidesModel = solidTidesModel;
    }

    public String getReductionTheory() {
        return this.reductionTheory;
    }

    public void setReductionTheory(String reductionTheory) {
        this.reductionTheory = reductionTheory;
    }

    public String getAlbedoModel() {
        return this.albedoModel;
    }

    public void setAlbedoModel(String albedoModel) {
        this.albedoModel = albedoModel;
    }

    public int getAlbedoGridSize() {
        return this.albedoGridSize;
    }

    public void setAlbedoGridSize(int albedoGridSize) {
        this.albedoGridSize = albedoGridSize;
    }

    public ShadowModel getShadowModel() {
        return this.shadowModel;
    }

    public void setShadowModel(ShadowModel shadowModel) {
        this.shadowModel = shadowModel;
    }

    public List<BodyFacade> getShadowBodies() {
        return this.shadowBodies;
    }

    public void setShadowBodies(List<BodyFacade> shadowBodies) {
        this.shadowBodies = shadowBodies;
    }

    public String getSrpModel() {
        return this.srpModel;
    }

    public void setSrpModel(String srpModel) {
        this.srpModel = srpModel;
    }

    public String getSpaceWeatherSource() {
        return this.spaceWeatherSource;
    }

    public void setSpaceWeatherSource(String spaceWeatherSource) {
        this.spaceWeatherSource = spaceWeatherSource;
    }

    public AbsoluteDate getSpaceWeatherEpoch() {
        return this.spaceWeatherEpoch;
    }

    public void setSpaceWeatherEpoch(AbsoluteDate spaceWeatherEpoch) {
        this.spaceWeatherEpoch = spaceWeatherEpoch;
    }

    public String getInterpMethodSW() {
        return this.interpMethodSW;
    }

    public void setInterpMethodSW(String interpMethodSW) {
        this.refuseFurtherComments();
        this.interpMethodSW = interpMethodSW;
    }

    public double getFixedGeomagneticKp() {
        return this.fixedGeomagneticKp;
    }

    public void setFixedGeomagneticKp(double fixedGeomagneticKp) {
        this.fixedGeomagneticKp = fixedGeomagneticKp;
    }

    public double getFixedGeomagneticAp() {
        return this.fixedGeomagneticAp;
    }

    public void setFixedGeomagneticAp(double fixedGeomagneticAp) {
        this.fixedGeomagneticAp = fixedGeomagneticAp;
    }

    public double getFixedGeomagneticDst() {
        return this.fixedGeomagneticDst;
    }

    public void setFixedGeomagneticDst(double fixedGeomagneticDst) {
        this.fixedGeomagneticDst = fixedGeomagneticDst;
    }

    public double getFixedF10P7() {
        return this.fixedF10P7;
    }

    public void setFixedF10P7(double fixedF10P7) {
        this.fixedF10P7 = fixedF10P7;
    }

    public double getFixedF10P7Mean() {
        return this.fixedF10P7Mean;
    }

    public void setFixedF10P7Mean(double fixedF10P7Mean) {
        this.fixedF10P7Mean = fixedF10P7Mean;
    }

    public double getFixedM10P7() {
        return this.fixedM10P7;
    }

    public void setFixedM10P7(double fixedM10P7) {
        this.fixedM10P7 = fixedM10P7;
    }

    public double getFixedM10P7Mean() {
        return this.fixedM10P7Mean;
    }

    public void setFixedM10P7Mean(double fixedM10P7Mean) {
        this.fixedM10P7Mean = fixedM10P7Mean;
    }

    public double getFixedS10P7() {
        return this.fixedS10P7;
    }

    public void setFixedS10P7(double fixedS10P7) {
        this.fixedS10P7 = fixedS10P7;
    }

    public double getFixedS10P7Mean() {
        return this.fixedS10P7Mean;
    }

    public void setFixedS10P7Mean(double fixedS10P7Mean) {
        this.fixedS10P7Mean = fixedS10P7Mean;
    }

    public double getFixedY10P7() {
        return this.fixedY10P7;
    }

    public void setFixedY10P7(double fixedY10P7) {
        this.fixedY10P7 = fixedY10P7;
    }

    public double getFixedY10P7Mean() {
        return this.fixedY10P7Mean;
    }

    public void setFixedY10P7Mean(double fixedY10P7Mean) {
        this.fixedY10P7Mean = fixedY10P7Mean;
    }
}

